/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.TreePath;
import org.opengts.Version;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.SystemProps;
import org.opengts.dbtools.DBAdmin;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBFactoryTree;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.opt.admin.AboutDialog;
import org.opengts.opt.admin.DBInfoNode;
import org.opengts.opt.admin.DBNodeCustomView;
import org.opengts.opt.admin.EditorNode;
import org.opengts.opt.admin.FactoryNode;
import org.opengts.opt.admin.dbinfo.DBInfoTabs;
import org.opengts.opt.admin.dmtpcalc.DMTPCalculator;
import org.opengts.opt.admin.edit.DBTableEditor;
import org.opengts.opt.admin.rules.RuleEvaluator;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VDialog;
import org.opengts.opt.ui.VFrame;
import org.opengts.opt.ui.VMenu;
import org.opengts.opt.ui.VMenuItem;
import org.opengts.opt.ui.VOptionPane;
import org.opengts.opt.ui.VPopupMenu;
import org.opengts.opt.ui.VPopupMenuProvider;
import org.opengts.opt.ui.VScrollPane;
import org.opengts.opt.ui.VTree;
import org.opengts.opt.ui.VTreeNode;
import org.opengts.opt.ui.VTreeViewer;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;

public class GTSAdmin
extends VFrame {
    public static final String APP_VERSION = "1.2.2";
    public static final String APP_COPYRIGHT = "Copyright 2007-2013, GeoTelematic Solutions, Inc.";
    public static final String APP_URL = "http://www.geotelematic.com";
    public static final String GTS_COMPILED_VERSION = "E2.5.3-B05";
    public static final String GTS_LIBRARY_VERSION = Version.getVersion();
    public static final String PROP_BROWSE_PAGE_SIZE = "gtsAdmin.browsePageSize";
    public static final String PROP_ALLOW_DELETE = "gtsAdmin.allowRecordDelete";
    private static final String PROP_APPLE_MENUBAR = "apple.laf.useScreenMenuBar";
    private static final String PROP_APPLE_ABOUT_NAME = "com.apple.mrj.application.apple.menu.about.name";
    private static final String PROP_APPLE_GROWBOX_INTRUDE = "com.apple.mrj.application.growbox.intrudes";
    private static final String PROP_APPLE_LIVE_RESIZE = "com.apple.mrj.application.live-resize";
    private static final String PROP_APPLE_SMALL_TABS = "com.apple.macos.smallTabs";
    public static final Color COLOR_BACKGROUND = new Color(238, 238, 238);
    private static boolean dbConnectionOK = true;
    private static GTSAdmin singleInstance = null;
    private GTSTreeViewer treeViewer = null;
    private List<EditorNode> rootEditorNodes = null;
    private VMenu contextMenu = null;
    private int updatingFactoryNodes = 0;
    private Runnable updateFactoryNodeRunnable = null;
    private static AboutDialog aboutDialog = null;
    private static Runnable showAbout = null;

    public static boolean DBConnectionOK() {
        return dbConnectionOK;
    }

    public static GTSAdmin getInstance() {
        if (singleInstance == null) {
            singleInstance = new GTSAdmin();
        }
        return singleInstance;
    }

    private GTSAdmin() {
        super("GTS Administration v1.2.2");
        this.setBackground(COLOR_BACKGROUND);
        this.initMenuBar();
        VBox content = this.getContentBox();
        content.setGBCX(0.5, 0, 1);
        content.setGBCY(0.5, 0, 1);
        this.treeViewer = new GTSTreeViewer();
        content.add((Component)((Object)this.treeViewer), (Object)content.getDefaultGBC());
        this.initTreeNodes();
        this.setActionOnClose(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GTSAdmin.this.exit();
            }
        }, "close");
        this.centerOnScreen(950, 700);
    }

    protected void initMenuBar() {
        boolean macMenuBar = RTConfig.getBoolean((String)PROP_APPLE_MENUBAR, (boolean)false);
        if (!macMenuBar) {
            VMenu file = new VMenu("File", 70);
            this.addMenu((JMenu)file);
            file.add((JMenuItem)new VMenuItem("Exit", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GTSAdmin.this.exit();
                }
            }, 120));
        }
        VMenu utils = new VMenu("Utilities", 85);
        this.addMenu((JMenu)utils);
        utils.add((JMenuItem)new VMenuItem("DMTP Optimization Calculator ...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DMTPCalculator.showDialog();
            }
        }, 100));
        if (Device.getRuleFactory() != null) {
            utils.add((JMenuItem)new VMenuItem("Rule Evaluator ...", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    RuleEvaluator.showDialog();
                }
            }, 114));
        }
        if (RTConfig.isDebugMode()) {
            utils.add((JMenuItem)new VMenuItem("Color Chooser", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JColorChooser.showDialog(null, "Color Chooser ...", Color.white);
                }
            }, 99));
        }
        VMenu help = new VMenu("Help", 72);
        this.addMenu((JMenu)help);
        help.add((JMenuItem)new VMenuItem("About ...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GTSAdmin.showAbout();
            }
        }, 97));
        this.addMenuSpace();
        this.contextMenu = new VMenu("Context", 67);
        this.contextMenu.setPopupMenuProvider(new VPopupMenuProvider(){

            public JPopupMenu getPopupMenu() {
                VTreeNode selNode = GTSAdmin.this.getSelectedNode();
                if (selNode != null) {
                    return selNode.getPopupMenu();
                }
                JPopupMenu popup = null;
                return popup;
            }
        });
        this.addMenu((JMenu)this.contextMenu);
        this.contextMenu.setVisible(false);
    }

    private VTreeNode _addFactoryNode(DBFactoryTree dbFactNode, DBInfoTabs dbInfo, VTreeNode parentNode) {
        final DBFactory dbFact = dbFactNode.getDBFactory();
        if (dbFact == null) {
            Print.logError((String)"Null DBFactory!", (Object[])new Object[0]);
            return null;
        }
        final FactoryNode treeNode = new FactoryNode(dbFact);
        treeNode.setCustomView((Component)((Object)dbInfo));
        treeNode.setPopupMenuProvider(new VPopupMenuProvider(){

            public JPopupMenu getPopupMenu() {
                VPopupMenu popup = new VPopupMenu(dbFact.getUntranslatedTableName());
                try {
                    if (!dbFact.tableExists()) {
                        popup.add((Action)new AbstractAction("Create Table"){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                GTSAdmin.this.createTable((DBFactory<? extends DBRecord>)dbFact);
                                ((VBox)treeNode.getCustomView()).refresh();
                                GTSAdmin.this.updateFactoryNodes();
                            }
                        }).setEnabled(GTSAdmin.DBConnectionOK());
                        popup.addSeparator();
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                popup.add((Action)new AbstractAction("Update Columns"){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        GTSAdmin.this.updateColumns((DBFactory<? extends DBRecord>)dbFact, true);
                        GTSAdmin.this.getTree().nodeChanged(treeNode);
                        ((VBox)treeNode.getCustomView()).refresh();
                        GTSAdmin.this.updateFactoryNodes();
                    }
                }).setEnabled(GTSAdmin.DBConnectionOK());
                if (treeNode.hasChildren()) {
                    popup.addSeparator();
                    popup.add((Action)new AbstractAction("Expand All"){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            GTSAdmin.this.getTree().setExpandAll(treeNode, true);
                        }
                    });
                    popup.add((Action)new AbstractAction("Collapse All"){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            GTSAdmin.this.getTree().setExpandAll(treeNode, false);
                        }
                    });
                }
                return popup;
            }
        });
        parentNode.setAllowsChildren(true);
        this.getTree().addNode(parentNode, treeNode);
        return treeNode;
    }

    private void _addFactoryTree(DBFactoryTree dbFactTree, DBInfoTabs dbInfo, VTreeNode parentNode) {
        DBFactory dbFact;
        DBFactory dBFactory = dbFact = dbFactTree != null ? dbFactTree.getDBFactory() : null;
        if (dbFact == null) {
            Print.logError((String)"Null DBFactory!", (Object[])new Object[0]);
            return;
        }
        VTreeNode treeNode = this._addFactoryNode(dbFactTree, dbInfo, parentNode);
        if (treeNode != null) {
            DBFactoryTree[] children = dbFactTree.getChildren();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    this._addFactoryTree(children[i], dbInfo, treeNode);
                }
            }
        } else {
            Print.logError((String)("Unable to create node for " + dbFactTree), (Object[])new Object[0]);
        }
    }

    protected void initTreeNodes() {
        DBFactoryTree[] dbFactTree = this.getDBFactoryTree();
        this.treeViewer.setContextMenu(null);
        this.rootEditorNodes = new Vector<EditorNode>();
        for (int i = 0; i < dbFactTree.length; ++i) {
            EditorNode editNode = this._addEditorTree(dbFactTree[i], null);
            if (editNode == null) continue;
            this.getTree().addNode(null, editNode);
            this.rootEditorNodes.add(editNode);
        }
        DBInfoTabs dbInfo = new DBInfoTabs(this.treeViewer);
        final DBInfoNode dbNode = new DBInfoNode();
        dbNode.setPopupMenuProvider(new VPopupMenuProvider(){

            public JPopupMenu getPopupMenu() {
                VPopupMenu popup = new VPopupMenu("DBInfo");
                popup.add((Action)new AbstractAction("Update Tables"){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        GTSAdmin.this.updateTables();
                        GTSAdmin.this.refreshSelectedNode();
                        GTSAdmin.this.updateFactoryNodes();
                    }
                }).setEnabled(GTSAdmin.DBConnectionOK());
                popup.addSeparator();
                popup.add((Action)new AbstractAction("Expand All"){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        GTSAdmin.this.getTree().setExpandAll(dbNode, true);
                    }
                });
                popup.add((Action)new AbstractAction("Collapse All"){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        GTSAdmin.this.getTree().setExpandAll(dbNode, false);
                    }
                });
                return popup;
            }
        });
        this.getTree().addNode(null, dbNode);
        for (int i = 0; i < dbFactTree.length; ++i) {
            this._addFactoryTree(dbFactTree[i], dbInfo, dbNode);
        }
    }

    public GTSTree getTree() {
        return (GTSTree)this.treeViewer.getVTree();
    }

    public VTreeNode getSelectedNode() {
        return this.getTree().getSelectedNode();
    }

    public void refreshSelectedNode() {
        VTreeNode selNode = this.getSelectedNode();
        if (selNode != null) {
            Component comp = selNode.getCustomView();
            if (comp instanceof VScrollPane) {
                comp = ((VScrollPane)comp).getViewportView();
            }
            if (comp instanceof VBox) {
                ((VBox)comp).refresh();
            }
            this.getTree().nodeChanged(selNode);
        }
    }

    private DBNodeCustomView _createEditorNodeCustomView(EditorNode treeNode) {
        if (treeNode != null) {
            DBFactory dbFact;
            DBFactoryTree dbFactTree = treeNode.getDBFactoryTree();
            DBFactory dBFactory = dbFact = dbFactTree != null ? dbFactTree.getDBFactory() : null;
            if (dbFact != null) {
                String tableName = dbFact.getUntranslatedTableName();
                if (tableName.equals("Diagnostic")) {
                    return null;
                }
                if (tableName.equals("Property")) {
                    return null;
                }
                if (!dbFact.isViewable()) {
                    return null;
                }
                return new DBTableEditor(dbFactTree, this.getTree(), treeNode);
            }
        }
        return null;
    }

    private EditorNode _addEditorNode(final DBFactoryTree dbFactTree, VTreeNode parentNode) {
        final DBFactory dbFact = dbFactTree.getDBFactory();
        if (dbFact == null) {
            Print.logError((String)"Null DBFactory!", (Object[])new Object[0]);
            return null;
        }
        EditorNode treeNode = new EditorNode(dbFactTree);
        DBNodeCustomView customView = this._createEditorNodeCustomView(treeNode);
        if (customView == null) {
            return null;
        }
        treeNode.setCustomView((Component)new VScrollPane((Component)((Object)customView), true, true));
        final EditorNode editorNode = treeNode;
        final DBNodeCustomView editor = customView;
        editorNode.setPopupMenuProvider(new VPopupMenuProvider(){

            public JPopupMenu getPopupMenu() {
                VPopupMenu popup = new VPopupMenu(dbFact.getUntranslatedTableName());
                if (editor instanceof DBTableEditor) {
                    if (dbFactTree.hasDBRecord()) {
                        popup.add((Action)new AbstractAction("Reload"){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                GTSAdmin.this.reloadRecord(editorNode);
                            }
                        }).setEnabled(GTSAdmin.DBConnectionOK());
                        popup.addSeparator();
                        popup.add((Action)new AbstractAction("Close"){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                GTSAdmin.this.closeRecord(editorNode);
                            }
                        }).setEnabled(GTSAdmin.DBConnectionOK());
                        if (dbFactTree.isEditable()) {
                            popup.addSeparator();
                            popup.add((Action)new AbstractAction("Save"){

                                @Override
                                public void actionPerformed(ActionEvent ae) {
                                    ((DBTableEditor)editor).saveRecord();
                                }
                            }).setEnabled(GTSAdmin.DBConnectionOK());
                            popup.addSeparator();
                            popup.add((Action)new AbstractAction("Delete"){

                                @Override
                                public void actionPerformed(ActionEvent ae) {
                                    GTSAdmin.this.deleteRecord(editorNode);
                                }
                            }).setEnabled(GTSAdmin.DBConnectionOK());
                        }
                    } else if (dbFactTree.hasParentDBRecord()) {
                        popup.add((Action)new AbstractAction("Open"){

                            @Override
                            public void actionPerformed(ActionEvent ae) {
                                GTSAdmin.this.openRecord(editorNode);
                            }
                        }).setEnabled(GTSAdmin.DBConnectionOK());
                        if (dbFactTree.isEditable()) {
                            popup.addSeparator();
                            popup.add((Action)new AbstractAction("New"){

                                @Override
                                public void actionPerformed(ActionEvent ae) {
                                    GTSAdmin.this.newRecord(editorNode);
                                }
                            }).setEnabled(GTSAdmin.DBConnectionOK());
                        }
                    }
                }
                if (dbFactTree.hasChildren()) {
                    popup.addSeparator();
                    popup.add((Action)new AbstractAction("Expand All"){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            GTSAdmin.this.getTree().setExpandAll(editorNode, true);
                        }
                    });
                    popup.add((Action)new AbstractAction("Collapse All"){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            GTSAdmin.this.getTree().setExpandAll(editorNode, false);
                        }
                    });
                }
                return popup;
            }
        });
        if (parentNode != null) {
            parentNode.setAllowsChildren(true);
        }
        this.getTree().addNode(parentNode, editorNode);
        return editorNode;
    }

    private EditorNode _addEditorTree(DBFactoryTree dbFactTree, VTreeNode parentNode) {
        DBFactory dbFact;
        DBFactory dBFactory = dbFact = dbFactTree != null ? dbFactTree.getDBFactory() : null;
        if (dbFact == null) {
            Print.logError((String)"Null DBFactory!", (Object[])new Object[0]);
        } else if (!dbFact.isViewable()) {
            return null;
        }
        EditorNode treeNode = this._addEditorNode(dbFactTree, parentNode);
        if (treeNode != null) {
            DBFactoryTree[] children;
            if (dbFact.getUntranslatedTableName().equalsIgnoreCase(Account.TABLE_NAME())) {
                DBNodeCustomView editor = treeNode.getNodeCustomEditor();
                editor.refresh();
            }
            if ((children = dbFactTree.getChildren()) != null) {
                for (int i = 0; i < children.length; ++i) {
                    this._addEditorTree(children[i], treeNode);
                }
            }
        } else {
            Print.logError((String)("Unable to create node for " + dbFactTree), (Object[])new Object[0]);
        }
        return treeNode;
    }

    public boolean reloadRecord(EditorNode node) {
        DBNodeCustomView editor;
        if (node.hasEditorChanged(false)) {
            String tableName = node.getTableName();
            String keyValue = node.getKeyValue();
            boolean ok = VOptionPane.showYesNoDialog((Component)((Object)this), (Object)("All changes will be lost!\nAre you sure you want to reload " + tableName + " '" + keyValue + "'?"), (String)"Confirm Reload");
            if (!ok) {
                return false;
            }
        }
        if ((editor = node.getNodeCustomEditor()).reloadRecord()) {
            this.getTree().nodeChanged(node);
            if (node.hasChildren()) {
                this.getTree().setNodeExpanded(node, true);
            }
            return true;
        }
        return false;
    }

    public boolean openRecord(EditorNode node) {
        DBNodeCustomView editor = node.getNodeCustomEditor();
        if (editor.openRecord()) {
            this.getTree().nodeChanged(node);
            if (node.hasChildren()) {
                this.getTree().setNodeExpanded(node, true);
            }
            return true;
        }
        return false;
    }

    public boolean newRecord(EditorNode node) {
        DBNodeCustomView editor = node.getNodeCustomEditor();
        if (editor.newRecord()) {
            this.getTree().nodeChanged(node);
            if (node.hasChildren()) {
                this.getTree().setNodeExpanded(node, true);
            }
            return true;
        }
        return false;
    }

    public boolean closeRecord(EditorNode node) {
        if (node.hasEditorChanged(true)) {
            String tableName = node.getTableName();
            String keyValue = node.getKeyValue();
            boolean ok = VOptionPane.showYesNoDialog((Component)((Object)this), (Object)("All changes will be lost!\nAre you sure you want to close " + tableName + " '" + keyValue + "'?"), (String)"Confirm Close");
            if (!ok) {
                return false;
            }
        }
        return this._closeRecord(node);
    }

    private boolean _closeRecord(EditorNode node) {
        DBNodeCustomView editor;
        VTreeNode[] children = node.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                EditorNode child = (EditorNode)children[i];
                if (this._closeRecord(child)) continue;
                return false;
            }
        }
        if ((editor = node.getNodeCustomEditor()).closeRecord()) {
            this.getTree().nodeChanged(node);
            if (node.hasChildren()) {
                this.getTree().setNodeExpanded(node, false);
            }
            return true;
        }
        return false;
    }

    public boolean deleteRecord(EditorNode node) {
        DBNodeCustomView editor = node.getNodeCustomEditor();
        if (editor.deleteRecord()) {
            this._closeRecord(node);
            return true;
        }
        return false;
    }

    private void updateColumns(final DBFactory<? extends DBRecord> dbFact, boolean checkVersion) {
        boolean ok;
        String gtsPropVersion;
        String gtsCurrVersion;
        if (dbFact == null) {
            return;
        }
        final String tableName = dbFact.getUntranslatedTableName();
        if (checkVersion && !(gtsCurrVersion = GTS_LIBRARY_VERSION).equals(gtsPropVersion = SystemProps.getGTSVersion((String)"?")) && !(ok = VOptionPane.showYesNoDialog((Component)((Object)this), (Object)("Library/Table versions do not match!\nLibrary Version: " + gtsCurrVersion + "\n" + "Table Version: " + gtsPropVersion + "\n" + "Are you sure you want to update columns for table '" + tableName + "'?"), (String)"Confirm Update Columns"))) {
            return;
        }
        final VDialog msgDialog = VOptionPane.showProgressDialog((Component)((Object)this), (Object)"This may take a few minutes if there are many records in the table.\nPlease wait while the columns for this table are being updated.\n(Please allow this process to run to completion)", (String)("Alter Columns [table " + tableName + "]"), (boolean)false);
        msgDialog.setDoNothingOnClose();
        msgDialog.setModal(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1500L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                Print.logInfo((String)("Updating columns for table '" + tableName + "' ..."), (Object[])new Object[0]);
                int mask = 6;
                dbFact.validateColumns(mask, true);
                MethodAction.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        msgDialog.dispose();
                    }
                });
            }
        }).start();
        msgDialog.show();
        Print.logDebug((String)"Done ...", (Object[])new Object[0]);
    }

    private boolean createTable(DBFactory<? extends DBRecord> dbFact) {
        try {
            if (dbFact != null && !dbFact.tableExists()) {
                Print.logInfo((String)("Creating table: " + dbFact.getUntranslatedTableName()), (Object[])new Object[0]);
                dbFact.createTable();
                return true;
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Unable to create table: " + dbFact.getUntranslatedTableName()), (Throwable)dbe);
        }
        return false;
    }

    private void updateTables() {
        boolean ok;
        String gtsCurrVersion = GTS_LIBRARY_VERSION;
        String gtsPropVersion = SystemProps.getGTSVersion((String)"?");
        if (!gtsCurrVersion.equals(gtsPropVersion) && !(ok = VOptionPane.showYesNoDialog((Component)((Object)this), (Object)("Library/Table versions do not match!\nLibrary Version: " + gtsCurrVersion + "\n" + "Table Version: " + gtsPropVersion + "\n" + "Are you sure you want to update the tables?"), (String)"Confirm Update Tables"))) {
            return;
        }
        try {
            OrderedMap dbFactMap = DBAdmin.getTableFactoryMap();
            Iterator i = dbFactMap.keyIterator();
            while (i.hasNext()) {
                String tn = (String)i.next();
                DBFactory dbFact = (DBFactory)dbFactMap.get((Object)tn);
                if (!dbFact.tableExists()) {
                    this.createTable((DBFactory<? extends DBRecord>)dbFact);
                    continue;
                }
                this.updateColumns((DBFactory<? extends DBRecord>)dbFact, false);
            }
        }
        catch (DBException dbe) {
            Print.logException((String)"Table Updating", (Throwable)dbe);
            VOptionPane.showErrorDialog((Component)((Object)this), (Object)("Error encountered while updating tables\n" + (Object)((Object)dbe)), (String)"Error Updating Tables");
        }
        SystemProps.updateVersions();
    }

    public static void showAbout() {
        if (aboutDialog == null) {
            aboutDialog = new AboutDialog((Frame)((Object)GTSAdmin.getInstance()));
            showAbout = new Runnable(){

                @Override
                public void run() {
                    aboutDialog.setVisible(true);
                }
            };
        }
        try {
            if (MethodAction.isDispatchThread()) {
                showAbout.run();
            } else {
                MethodAction.invokeLater((Runnable)showAbout);
            }
        }
        catch (Throwable th) {
            Print.logError((String)("Unable to display 'About' panel: " + th), (Object[])new Object[0]);
        }
    }

    public static void exitApp() {
        if (MethodAction.isDispatchThread()) {
            GTSAdmin.getInstance().exit();
        } else {
            try {
                MethodAction.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GTSAdmin.getInstance().exit();
                    }
                });
            }
            catch (Throwable th) {
                System.exit(0);
            }
        }
    }

    public void exit() {
        boolean changed = false;
        for (EditorNode node : this.rootEditorNodes) {
            if (!node.hasEditorChanged(true)) continue;
            changed = true;
            break;
        }
        boolean ok = false;
        ok = changed ? VOptionPane.showYesNoDialog((Component)((Object)this), (Object)"All changes will be lost!\nAre you sure you want to exit this application?", (String)"Confirm Exit") : VOptionPane.showYesNoDialog((Component)((Object)this), (Object)"Are you sure you want to exit this application?", (String)"Confirm Exit");
        if (!ok) {
            return;
        }
        System.exit(0);
    }

    private DBFactoryTree[] getDBFactoryTree() {
        DBFactory acctFact = DBAdmin.getTableFactory((String)Account.TABLE_NAME());
        return DBFactoryTree.getDBFactoryTree((DBFactory)acctFact);
    }

    public void updateFactoryNodes() {
        if (this.updatingFactoryNodes <= 0) {
            ++this.updatingFactoryNodes;
            if (this.updateFactoryNodeRunnable == null) {
                this.updateFactoryNodeRunnable = new Runnable(){

                    @Override
                    public void run() {
                        GTSAdmin.this._updateFactoryNode(null);
                        GTSAdmin.this.updatingFactoryNodes = 0;
                    }
                };
            }
            MethodAction.invokeLater((Runnable)this.updateFactoryNodeRunnable);
        }
    }

    private void _updateFactoryNode(VTreeNode node) {
        VTreeNode[] children;
        GTSTree tree;
        FactoryNode fnode;
        DBInfoTabs infoTabs;
        if (node == null) {
            node = this.getTree().getRootNode();
        }
        if (node instanceof FactoryNode && (infoTabs = (fnode = (FactoryNode)node).getInfoTabs()) != null) {
            DBFactory<? extends DBRecord> dbFact = fnode.getDBFactory();
            fnode.setColumnError(infoTabs.getColumnErrors(dbFact));
            this.getTree().nodeChanged(fnode);
        }
        if ((tree = this.getTree()).isNodeExpanded(node) && node.hasChildren() && (children = node.getChildren()) != null) {
            for (int i = 0; i < children.length; ++i) {
                this._updateFactoryNode(children[i]);
            }
        }
    }

    public static void main(String[] argv) {
        if (argv.length > 0 && argv[0].startsWith("-v")) {
            System.out.println(APP_VERSION);
            System.exit(0);
        }
        DBConfig.cmdLineInit((String[])argv, (boolean)true);
        Print.setLogLevel((int)5);
        Print.setLogHeaderLevel((int)5);
        String laf = VFrame.setLookAndFeel((String)RTConfig.getString((String)"laf", null));
        Print.logInfo((String)("Set LookAndFeel: " + laf), (Object[])new Object[0]);
        if (OSTools.isMacOSX()) {
            System.setProperty(PROP_APPLE_MENUBAR, "true");
            System.setProperty(PROP_APPLE_ABOUT_NAME, "GTSAdmin");
            try {
                String malClz = "org.opengts.extra.macosx.MacAppListener";
                new MethodAction((Object)malClz, new Class[]{ActionListener.class}).invoke(new Object[]{new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if ("quit".equals(ae.getActionCommand())) {
                            GTSAdmin.exitApp();
                            return;
                        }
                        if ("about".equals(ae.getActionCommand())) {
                            GTSAdmin.showAbout();
                            return;
                        }
                    }
                }});
            }
            catch (Throwable th) {
                Print.logError((String)("Unable to initialize Mac ApplicationListener: " + th), (Object[])new Object[0]);
            }
        }
        DBTableEditor.initEditors();
        GTSAdmin.getInstance().setVisible(true);
        GTSAdmin.showAbout();
        try {
            Device.exists((String)"account", (String)"device");
            dbConnectionOK = true;
        }
        catch (DBException dbe) {
            Print.logException((String)"Error connecting to Account table", (Throwable)dbe);
            String host = DBProvider.getDBHost();
            int port = DBProvider.getDBPort();
            VOptionPane.showErrorDialog((Component)((Object)GTSAdmin.getInstance()), (Object)("UNABLE TO CONNECT TO DATABASE AT '" + host + ":" + port + "'\n" + "\n" + "Database Table query/edit will not be possible"), (String)"Database Error");
            dbConnectionOK = false;
        }
    }

    private class GTSTree
    extends VTree {
        public GTSTree(String treeTitle) {
            super(treeTitle, null, false);
        }

        public void treeWillExpand(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            VTreeNode node = (VTreeNode)path.getLastPathComponent();
            node.populateChildren((VTree)this);
            GTSAdmin.this.updateFactoryNodes();
        }
    }

    private class GTSTreeViewer
    extends VTreeViewer {
        public GTSTreeViewer() {
            super("GTS Administration", null, true);
            this.addSelectionListener(new VTree.VTreeSelectionListener(){

                public void selectionChanged(VTree tree) {
                    VTreeNode selNode = tree.getSelectedNode();
                    if (selNode == null) {
                        GTSAdmin.this.contextMenu.setTitle("");
                        GTSAdmin.this.contextMenu.setVisible(false);
                    } else if (selNode instanceof EditorNode) {
                        String name = ((EditorNode)selNode).getTableName();
                        GTSAdmin.this.contextMenu.setTitle(name + " Node");
                        GTSAdmin.this.contextMenu.setVisible(true);
                    } else if (selNode instanceof FactoryNode) {
                        String name = ((FactoryNode)selNode).getTableName();
                        GTSAdmin.this.contextMenu.setTitle("DB " + name + " Node");
                        GTSAdmin.this.contextMenu.setVisible(true);
                    } else if (selNode.getPopupMenu() != null) {
                        GTSAdmin.this.contextMenu.setTitle(selNode.toString() + " Node");
                        GTSAdmin.this.contextMenu.setVisible(true);
                    } else {
                        GTSAdmin.this.contextMenu.setTitle("");
                        GTSAdmin.this.contextMenu.setVisible(false);
                    }
                }
            });
            this.setPreferredTreeWidth(220);
        }

        public VTree createVTree(String treeTitle) {
            return new GTSTree(treeTitle);
        }
    }
}

