/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.admin;

import java.awt.Component;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBRecord;
import org.opengts.opt.admin.dbinfo.DBInfoTabs;
import org.opengts.opt.ui.VIcon;
import org.opengts.opt.ui.VScrollPane;
import org.opengts.opt.ui.VTree;
import org.opengts.opt.ui.VTreeNode;

public class FactoryNode
extends VTreeNode {
    public static final int ERR_OK = 0;
    public static final int ERR_WARN = 1;
    public static final int ERR_ERROR = 2;
    private static String COLOR_NODE_OK = "#000000";
    private static String COLOR_NODE_WARN = "#999900";
    private static String COLOR_NODE_ERROR = "#CC0000";
    private int columnError = 0;

    public FactoryNode(DBFactory dbFact) {
        super((Object)dbFact, false);
        this.setOpenIcon(VIcon.getImageResource((String)"org/opengts/opt/ui/images/TreeLeaf_gray_11.gif"));
        this.setClosedIcon(VIcon.getImageResource((String)"org/opengts/opt/ui/images/TreeLeaf_black_11.gif"));
        this.setLeafIcon(VIcon.getImageResource((String)"org/opengts/opt/ui/images/TreeLeaf_gray_11.gif"));
        this.setToolTipText("Right-click to view selectable options");
    }

    public DBInfoTabs getInfoTabs() {
        Component comp = this.getCustomView();
        if (comp instanceof VScrollPane) {
            comp = ((VScrollPane)comp).getViewportView();
        }
        if (comp instanceof DBInfoTabs) {
            return (DBInfoTabs)((Object)comp);
        }
        return null;
    }

    public void setColumnError(int error) {
        this.columnError = error;
    }

    public int getColumnError() {
        return this.columnError;
    }

    public DBFactory<? extends DBRecord> getDBFactory() {
        return (DBFactory)this.getUserObject();
    }

    public String getTableName() {
        DBFactory<? extends DBRecord> dbFact = this.getDBFactory();
        return dbFact != null ? dbFact.getUntranslatedTableName() : "";
    }

    public void populateChildren(VTree tree) {
        super.populateChildren(tree);
        VTreeNode[] ch = this.getChildren();
        for (int i = 0; i < ch.length; ++i) {
            FactoryNode node = (FactoryNode)ch[i];
            DBInfoTabs infoTabs = node.getInfoTabs();
            if (infoTabs == null) continue;
            DBFactory<? extends DBRecord> dbFact = node.getDBFactory();
            node.setColumnError(infoTabs.getColumnErrors(dbFact));
            tree.nodeChanged((VTreeNode)node);
        }
    }

    public long getRecordCount() {
        try {
            DBFactory<? extends DBRecord> dbFact = this.getDBFactory();
            return dbFact != null ? dbFact.getRecordCount("", false) : -1L;
        }
        catch (DBException dbe) {
            return -1L;
        }
    }

    public String toString() {
        String name = super.toString();
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        switch (this.getColumnError()) {
            case 0: {
                sb.append("<font color='" + COLOR_NODE_OK + "'>");
                sb.append(name);
                sb.append("</font>");
                break;
            }
            case 2: {
                sb.append("<b>");
                sb.append("<font color='" + COLOR_NODE_ERROR + "'>");
                sb.append(name);
                sb.append("</font>");
                sb.append("</b>");
                break;
            }
            case 1: {
                sb.append("<b>");
                sb.append("<font color='" + COLOR_NODE_WARN + "'>");
                sb.append(name);
                sb.append("</font>");
                sb.append("</b>");
                break;
            }
        }
        sb.append("</html>");
        return sb.toString();
    }
}

