/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config.views;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import org.opengts.db.DBConfig;
import org.opengts.dbtools.DBProvider;
import org.opengts.opt.config.GTSConfig;
import org.opengts.opt.config.GTSProperties;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VCheckBox;
import org.opengts.opt.ui.VFiller;
import org.opengts.opt.ui.VLabel;
import org.opengts.opt.ui.VOptionPane;
import org.opengts.opt.ui.VSeparator;
import org.opengts.opt.ui.VShell;
import org.opengts.opt.ui.VTextArea;
import org.opengts.opt.ui.VTextField;
import org.opengts.util.HTMLTools;
import org.opengts.util.ListTools;
import org.opengts.util.OSTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;

public class UpdateTables
extends GTSConfig.GTSBox {
    public static final String SUPPORT_CENTER = "Support Center";
    private static final boolean RUN_INITDB_SH = false;
    private VShell execShell = null;
    private VTextArea textOutput = null;
    private Print.RedirectStream textOutputStream = null;
    private VButton emailBtn = null;
    private VButton clipboardBtn = null;
    private int initDBRunning = 0;

    public UpdateTables(GTSConfig gtsConfig) {
        super(gtsConfig);
        VBox labelBox = new VBox(null, null, false);
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.0, 0, 1);
        this.add((Component)labelBox, this.getDefaultGBC());
        labelBox.setGBCX(0.5, 0, 1);
        labelBox.setGBCY(0.0, 0, 1);
        labelBox.add((Component)new VFiller(), (Object)labelBox.getDefaultGBC());
        VLabel label = new VLabel();
        GridBagConstraints labelGBC = VBox.NewGBC();
        VBox.SetGBCX((GridBagConstraints)labelGBC, (double)0.5, (int)1, (int)1);
        VBox.SetGBCY((GridBagConstraints)labelGBC, (double)0.0, (int)0, (int)1);
        labelGBC.fill = 2;
        labelGBC.anchor = 10;
        labelBox.add((Component)label, (Object)labelGBC);
        label.setText("\"UpdateTables\" initializes the database and/or updates existing tables columns.\nClick \"Run UpdateTables\" below to run and display the UpdateTables logs.");
        labelBox.setGBCX(0.5, 2, 1);
        labelBox.setGBCY(0.0, 0, 1);
        labelBox.add((Component)new VFiller(), (Object)labelBox.getDefaultGBC());
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.0, 1, 1);
        this.add((Component)new VSeparator(), this.getDefaultGBC());
        boolean USE_SHELL = true;
        if (USE_SHELL) {
            this.execShell = new VShell();
            this.execShell.combineOutput(true);
            this.execShell.setStdinHidden(true);
            this.execShell.setLineWrap(false);
            this.setGBCX(0.5, 0, 1);
            this.setGBCY(0.5, 2, 1);
            this.add((Component)this.execShell, this.getDefaultGBC());
            this.textOutput = this.execShell.getStdoutTextArea();
        } else {
            this.textOutput = new VTextArea(null, null, false);
            this.textOutput.setReadOnly(true);
            this.textOutput.setTextFont(VBox.FONT_MONOSPACED_PLAIN);
            this.textOutput.setLineWrap(false);
            this.setGBCX(0.5, 0, 1);
            this.setGBCY(0.5, 2, 1);
            this.add((Component)this.textOutput, this.getDefaultGBC());
        }
        this.textOutputStream = new Print.RedirectStream(){

            public void print(String s) {
                UpdateTables.this.textPrint(s);
            }
        };
        this.clipboardBtn = new VButton("Copy to Clipboard");
        this.clipboardBtn.setEnabled(false);
        this.clipboardBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UpdateTables.this.textOutput.copyToClipboard();
                GTSConfig.showInfoDialog("The UpdateTables log has been copied to the clipboard", "UpdateTables Clipboard");
            }
        });
        this.emailBtn = new VButton("EMail to Support Center");
        this.emailBtn.setEnabled(false);
        this.emailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UpdateTables.this.emailUpdateTables();
            }
        });
        VButton updateBtn = new VButton("Run UpdateTables");
        updateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                UpdateTables.this.runUpdateTables();
            }
        });
        VBox buttonBox = new VBox(null, null, false);
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.0, 3, 1);
        this.add((Component)buttonBox, this.getDefaultGBC());
        buttonBox.setGBCX(0.5, 0, 1);
        buttonBox.setGBCY(0.0, 0, 1);
        buttonBox.add((Component)new VFiller(), (Object)buttonBox.getDefaultGBC());
        buttonBox.setGBCX(0.0, 1, 1);
        buttonBox.setGBCY(0.0, 0, 1);
        buttonBox.add((Component)updateBtn, (Object)buttonBox.getDefaultGBC());
        buttonBox.setGBCX(0.0, 2, 1, 20, 0);
        buttonBox.setGBCY(0.0, 0, 1);
        buttonBox.add((Component)this.clipboardBtn, (Object)buttonBox.getDefaultGBC());
        buttonBox.setGBCX(0.0, 3, 1, 20, 0);
        buttonBox.setGBCY(0.0, 0, 1);
        buttonBox.add((Component)this.emailBtn, (Object)buttonBox.getDefaultGBC());
        buttonBox.setGBCX(0.5, 4, 1);
        buttonBox.setGBCY(0.0, 0, 1);
        buttonBox.add((Component)new VFiller(), (Object)buttonBox.getDefaultGBC());
    }

    @Override
    protected void _refresh() {
    }

    private void textPrintln(String s) {
        s = StringTools.replace((String)s, (String)"\\", (String)"/");
        this.textOutput.appendText(s + "\n", true);
    }

    private void textPrint(String s) {
        s = StringTools.replace((String)s, (String)"\\", (String)"/");
        this.textOutput.appendText(s, true);
    }

    private void runUpdateTables() {
        if (this.initDBRunning == 0) {
            this.textOutput.setText("");
            String dbName = DBProvider.getProvider().getJDBCName();
            VTextField rootUserTF = new VTextField(null, null, false, true);
            VTextField rootPassTF = new VTextField(null, null, false, true);
            VCheckBox loadDemoCB = new VCheckBox("(Re)Load 'Demo' Sample Data", false);
            VCheckBox sysAdminCB = new VCheckBox("Create 'sysadmin' Account", false);
            Object[] dialogFields = new Object[]{"'" + dbName + "' Database Provider:\n" + "Enter database root user/password (if required),\n" + "or click 'Cancel' to cancel update request.", new VSeparator(), "Database Root User:", rootUserTF, "Database Root Password:", rootPassTF, new VSeparator(), loadDemoCB, sysAdminCB};
            boolean rtn = VOptionPane.showOkCancelDialog((Component)GTSConfig.getViewContainer(), (Object)dialogFields, (String)"Database Root User/Password");
            if (!rtn) {
                return;
            }
            final String rootUser = rootUserTF.getText();
            final String rootPass = rootPassTF.getText();
            final boolean loadDemo = loadDemoCB.isSelected();
            final boolean sysAdmin = sysAdminCB.isSelected();
            ++this.initDBRunning;
            this.textOutput.setText("");
            this.textPrintln(StringTools.replicateString((String)"=", (int)80));
            this.textPrintln("");
            this.textPrintln("UpdateTables log output [" + GTSProperties.getServiceAccountID() + "]");
            new Thread(){

                @Override
                public void run() {
                    int execRtn = -1;
                    String gtsHome_ = GTSProperties.GTS_HOME + File.separator;
                    String binDir = gtsHome_ + "bin" + File.separator;
                    if (GTSProperties.isUnixOrMac()) {
                        try {
                            String initdbCmd = binDir + "initdb.sh";
                            initdbCmd = initdbCmd + " -tables=tca";
                            if (!StringTools.isBlank((String)rootUser)) {
                                initdbCmd = initdbCmd + " -rootUser=" + rootUser + " -rootPass=" + rootPass;
                            }
                            if (sysAdmin) {
                                initdbCmd = initdbCmd + " -createSysAdmin";
                            }
                            UpdateTables.this.textPrintln("% " + initdbCmd);
                            UpdateTables.this.textPrintln("");
                            execRtn = UpdateTables.this.execShell.execCommand(initdbCmd);
                            UpdateTables.this.textPrintln("");
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        if (execRtn >= 0 && loadDemo) {
                            UpdateTables.this.textPrintln(StringTools.replicateString((String)"=", (int)80));
                            UpdateTables.this.textPrintln("");
                            try {
                                String loadDemoCmd = gtsHome_ + "sampleData" + File.separator + "loadSampleData.sh";
                                UpdateTables.this.textPrintln("Loading sample data ...");
                                UpdateTables.this.textPrintln("% " + loadDemoCmd);
                                UpdateTables.this.textPrintln("");
                                execRtn = UpdateTables.this.execShell.execCommand(loadDemoCmd);
                                UpdateTables.this.textPrintln("");
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                        }
                        UpdateTables.this.textPrintln(StringTools.replicateString((String)"=", (int)80));
                        UpdateTables.this.textPrintln("");
                    } else if (GTSProperties.isWindows()) {
                        try {
                            String initdbCmd = binDir + "initdb.bat";
                            initdbCmd = initdbCmd + " -tables:tca";
                            if (!StringTools.isBlank((String)rootUser)) {
                                initdbCmd = initdbCmd + " -rootUser:" + rootUser;
                                if (!StringTools.isBlank((String)rootPass)) {
                                    initdbCmd = initdbCmd + " -rootPass:" + rootPass;
                                }
                            }
                            if (sysAdmin) {
                                initdbCmd = initdbCmd + " -createSysAdmin";
                            }
                            initdbCmd = StringTools.replace((String)initdbCmd, (String)"\\", (String)"/");
                            UpdateTables.this.textPrintln("> " + initdbCmd);
                            UpdateTables.this.textPrintln("");
                            execRtn = UpdateTables.this.execShell.execCommand(initdbCmd);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        UpdateTables.this.textPrintln(StringTools.replicateString((String)"=", (int)80));
                        UpdateTables.this.textPrintln("");
                        if (execRtn >= 0 && loadDemo) {
                            try {
                                String loadDemoCmd = gtsHome_ + "sampleData" + File.separator + "loadSampleData.bat";
                                UpdateTables.this.textPrintln("Loading sample data ...");
                                UpdateTables.this.textPrintln("% " + loadDemoCmd);
                                UpdateTables.this.textPrintln("");
                                execRtn = UpdateTables.this.execShell.execCommand(loadDemoCmd);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            UpdateTables.this.textPrintln(StringTools.replicateString((String)"=", (int)80));
                            UpdateTables.this.textPrintln("");
                        }
                    } else {
                        try {
                            String dbCfg = StringTools.className(DBConfig.class);
                            Object[] args = RTConfig.getCommandLineProperties().toStringArray(true);
                            args = (String[])ListTools.add((Object[])args, (Object)"-initTables");
                            args = (String[])ListTools.add((Object[])args, (Object)"-tables:tca");
                            if (!StringTools.isBlank((String)rootUser)) {
                                args = (String[])ListTools.add((Object[])args, (Object)("-rootUser:" + rootUser));
                                args = (String[])ListTools.add((Object[])args, (Object)("-rootPass:" + rootPass));
                            }
                            if (sysAdmin) {
                                args = (String[])ListTools.add((Object[])args, (Object)"-createSysAdmin");
                            }
                            String[] cmd = OSTools.createJavaCommand((String[])GTSProperties.CLASSPATH, (String)dbCfg, (String[])args);
                            UpdateTables.this.textPrint(GTSConfig.getFormattedCommandDisplay(cmd));
                            execRtn = UpdateTables.this.execShell.execCommand(cmd);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        UpdateTables.this.textPrintln(StringTools.replicateString((String)"=", (int)80));
                        UpdateTables.this.textPrintln("");
                        if (execRtn >= 0 && loadDemo) {
                            UpdateTables.this.textPrintln("(Loading sample data not supported)");
                        }
                    }
                    UpdateTables.this.textPrintln("");
                    if (execRtn < 0) {
                        UpdateTables.this.textPrintln("*** Command failed ***");
                    } else {
                        UpdateTables.this.textPrintln("Done.");
                    }
                    UpdateTables.this.initDBRunning--;
                }
            }.start();
            this.clipboardBtn.setEnabled(true);
            this.emailBtn.setEnabled(true);
        }
    }

    private void emailUpdateTables() {
        String serviceAcct = GTSProperties.getServiceAccountID();
        String serviceName = GTSProperties.getServiceAccountName();
        String toAddr = GTSProperties.getString("ServiceProvider.email", "");
        String fromAddr = GTSProperties.getString("Domain.EMailAddress", null);
        if ((StringTools.isBlank((String)fromAddr) || fromAddr.endsWith("example.com")) && (StringTools.isBlank((String)(fromAddr = GTSProperties.getString("smtp.user.emailAddress", null))) || fromAddr.endsWith("example.com"))) {
            GTSConfig.showErrorDialog("The 'From' EMail address has not yet been defined.", "UpdateTables EMail");
            return;
        }
        boolean okSend = GTSConfig.showConfirmDialog("Confirm email UpdateTables log to\n" + toAddr, "Confirm UpdateTables EMail");
        if (!okSend) {
            return;
        }
        String attachName = "initdb.out";
        String subject = "[" + serviceAcct + "] " + serviceName + " - " + attachName;
        String body = "Attached:\n" + attachName;
        byte[] ciOut = this.textOutput.getTextInterface().getText().getBytes();
        SendMail.Attachment attach = new SendMail.Attachment(ciOut, attachName, HTMLTools.MIME_PLAIN());
        SendMail.SetThreadModel((String)"current");
        SendMail.SmtpProperties smtpProps = null;
        boolean sent = SendMail.send((String)fromAddr, (String)toAddr, (String)subject, (String)body, (SendMail.Attachment)attach, smtpProps);
        if (sent) {
            GTSConfig.showInfoDialog("UpdateTables Log EMail Sent to\n" + toAddr, "UpdateTables EMail");
        } else {
            GTSConfig.showErrorDialog("Unable to send UpdateTables Log", "UpdateTables EMail");
        }
    }
}

