/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config.views;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import org.opengts.opt.config.GTSConfig;
import org.opengts.opt.config.GTSProperties;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VCheckBox;
import org.opengts.opt.ui.VComboBox;
import org.opengts.opt.ui.VLabel;
import org.opengts.opt.ui.VSeparator;
import org.opengts.opt.ui.VShell;
import org.opengts.opt.ui.VTextArea;
import org.opengts.opt.ui.VTextField;
import org.opengts.util.DateTime;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class TrackWar
extends GTSConfig.GTSBox {
    public static final String DEFAULT_WARNAME = "track";
    public static final String WAR = "war";
    public static final String _WAR = ".war";
    private String warName = null;
    private VLabel helpLabel = null;
    private VButton buildBtn = null;
    private VComboBox warSetCB = null;
    private VCheckBox deployCB = null;
    private VTextField deployAs = null;
    private VButton clearLogBtn = null;
    private VShell execShell = null;
    private VTextArea execOutput = null;
    private int antInProcess = 0;
    private long execCompleteTimeMS = 0L;

    public TrackWar(GTSConfig gtsConfig, OrderedSet<String> warSet) {
        super(gtsConfig);
        int spanX = 5;
        int col = 0;
        int row = 0;
        VLabel label = new VLabel();
        GridBagConstraints labelGBC = VBox.NewGBC();
        VBox.SetGBCX((GridBagConstraints)labelGBC, (double)0.5, (int)0, (int)spanX, (int)0, (int)0);
        VBox.SetGBCY((GridBagConstraints)labelGBC, (double)0.0, (int)row, (int)1, (int)5, (int)10);
        labelGBC.fill = 2;
        labelGBC.anchor = 10;
        this.add((Component)label, labelGBC);
        label.setText("This screen allows repackaging/redeploying '.war' files (servlets).");
        this.setGBCX(0.5, 0, spanX, 0, 0);
        this.setGBCY(0.0, ++row, 1, 0, 5);
        this.add((Component)new VSeparator(), this.getDefaultGBC());
        ++row;
        col = 0;
        if (warSet == null) {
            warSet = new OrderedSet(true);
            warSet.add(0, (Object)DEFAULT_WARNAME);
        }
        OrderedMap warMap = new OrderedMap();
        for (String wn : warSet) {
            warMap.put((Object)(wn + _WAR), (Object)wn);
        }
        this.warSetCB = new VComboBox(null, null, false);
        this.warSetCB.setModel((Map)warMap);
        this.warSetCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String warName = (String)TrackWar.this.warSetCB.getValue();
                TrackWar.this.setWarName(warName);
            }
        });
        this.setGBCX(0.0, col, 1, 2, 5);
        this.setGBCY(0.0, row, 1, 0, 0);
        this.add((Component)this.warSetCB, this.getDefaultGBC());
        this.warSetCB.setSelectedItem((Object)DEFAULT_WARNAME);
        this.buildBtn = new VButton("Build");
        this.buildBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TrackWar.this.buildTracWar();
            }
        });
        this.setGBCX(0.0, ++col, 1, 2, 5);
        this.setGBCY(0.0, row, 1, 0, 0);
        this.add((Component)this.buildBtn, this.getDefaultGBC());
        this.deployCB = new VCheckBox("Deploy", true);
        this.deployCB.setSelected(true);
        this.setGBCX(0.0, ++col, 1, 5, 5);
        this.setGBCY(0.0, row, 1, 0, 0);
        this.add((Component)this.deployCB, this.getDefaultGBC());
        this.deployAs = new VTextField(null, "As", false, false);
        this.deployAs.setColumns(14);
        this.deployAs.setReadOnly(false);
        this.deployAs.setText(_WAR);
        this.setGBCX(0.0, ++col, 1, 0, 5);
        this.setGBCY(0.0, row, 1, 0, 0);
        this.add((Component)this.deployAs, this.getDefaultGBC());
        this.deployCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TrackWar.this.deployAs.setReadOnly(!TrackWar.this.deployCB.isSelected());
            }
        });
        this.clearLogBtn = new VButton("Clear Log");
        this.clearLogBtn.setEnabled(true);
        this.clearLogBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TrackWar.this.execOutput.setText("");
            }
        });
        GridBagConstraints clearGBC = VBox.NewGBC();
        VBox.SetGBCX((GridBagConstraints)clearGBC, (double)0.0, (int)(++col), (int)1, (int)5, (int)5);
        VBox.SetGBCY((GridBagConstraints)clearGBC, (double)0.0, (int)row, (int)1);
        clearGBC.anchor = 13;
        this.add((Component)this.clearLogBtn, clearGBC);
        this.setGBCX(0.5, 0, spanX, 0, 0);
        this.setGBCY(0.0, ++row, 1, 0, 5);
        this.add((Component)new VSeparator(), this.getDefaultGBC());
        ++row;
        this.execShell = new VShell("Build Output", null, true){

            protected void execFinished(int exitStatus) {
                TrackWar.this.textPrintln("");
                TrackWar.this.textPrintln(StringTools.replicateString((String)"=", (int)80));
            }
        };
        this.execShell.combineOutput(true);
        this.execShell.setStdinHidden(true);
        this.execShell.setLineWrap(false);
        this.setGBCX(0.5, 0, spanX);
        this.setGBCY(0.5, row, 1);
        this.add((Component)this.execShell, this.getDefaultGBC());
        this.execOutput = this.execShell.getStdoutTextArea();
        ++row;
        this.setWarName(null);
    }

    @Override
    protected void _refresh() {
    }

    private void textPrintln(String s) {
        s = StringTools.replace((String)s, (String)"\\", (String)"/");
        this.execOutput.appendText(s + "\n", true);
    }

    private void textPrint(String s) {
        s = StringTools.replace((String)s, (String)"\\", (String)"/");
        this.execOutput.appendText(s, true);
    }

    public String getWarName() {
        return this.warName;
    }

    public void setWarName(String name) {
        this.warName = StringTools.blankDefault((String)name, (String)DEFAULT_WARNAME);
        String war = this.warName + _WAR;
        this.deployAs.setText(war);
        this.execOutput.setText("");
    }

    public boolean buildTracWar() {
        long nowMS = DateTime.getCurrentTimeMillis();
        if (StringTools.isBlank((String)GTSProperties.ANT_EXEC)) {
            GTSConfig.showErrorDialog("Unable to determine the location of the Apache 'ant' executable.", "'ant' executable not found");
            return false;
        }
        if (this.antInProcess == 0 && nowMS - this.execCompleteTimeMS > 4000L) {
            String deployAsWar;
            ++this.antInProcess;
            this.execCompleteTimeMS = nowMS;
            boolean autoDeploy = this.deployCB != null ? this.deployCB.isSelected() : false;
            String string = deployAsWar = autoDeploy && this.deployAs != null ? this.deployAs.getText() : null;
            if (StringTools.isBlank(deployAsWar)) {
                deployAsWar = null;
            } else {
                char[] ch = deployAsWar.toCharArray();
                for (int i = 0; i < ch.length; ++i) {
                    if (Character.isLetterOrDigit(ch[i]) || ch[i] == '_' || ch[i] == '-' || ch[i] == '.') continue;
                    GTSConfig.showErrorDialog("'Deploy As' filename contains invalid characters", "Inv alid 'Deploy As' filename");
                    return false;
                }
            }
            final String antCmd = this._getAntTrackWar(autoDeploy, deployAsWar);
            this.buildBtn.setEnabled(false);
            this.execOutput.setText("");
            this.textPrintln("");
            new Thread(){

                @Override
                public void run() {
                    int execRtn = -1;
                    if (GTSProperties.isUnixOrMac()) {
                        String cmd = antCmd;
                        TrackWar.this.textPrintln("% " + cmd);
                        TrackWar.this.textPrintln("");
                        try {
                            execRtn = TrackWar.this.execShell.execCommand(cmd);
                        }
                        catch (InterruptedException ie) {}
                    } else if (GTSProperties.isWindows()) {
                        String cmd = StringTools.replace((String)antCmd, (String)"\\", (String)"/");
                        TrackWar.this.textPrintln("> " + cmd);
                        TrackWar.this.textPrintln("");
                        try {
                            execRtn = TrackWar.this.execShell.execCommand(cmd);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        String cmd = StringTools.replace((String)antCmd, (String)"\\", (String)"/");
                        TrackWar.this.textPrintln("? " + cmd);
                        TrackWar.this.textPrintln("");
                        TrackWar.this.textPrintln("Unrecognized Operating system (command ignored)");
                    }
                    if (execRtn < 0) {
                        TrackWar.this.textPrintln("");
                        TrackWar.this.textPrintln("*** Command failed ***");
                        TrackWar.this.textPrintln("");
                    }
                    TrackWar.this.antInProcess--;
                }
            }.start();
            while (!this.execShell.isExecFinished()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable t) {}
            }
            this.buildBtn.setEnabled(true);
            this.execCompleteTimeMS = DateTime.getCurrentTimeMillis();
            return this.execShell.getExitStatus() == 0;
        }
        Print.logWarn((String)"Previous Ant command is still running ...", (Object[])new Object[0]);
        return false;
    }

    private String _getAntTrackWar(boolean autoDeploy, String deployAs) {
        StringBuffer sb = new StringBuffer();
        String wname = this.getWarName();
        sb.append(GTSProperties.ANT_EXEC);
        if (autoDeploy) {
            String tw = StringTools.trim((String)deployAs);
            if (!StringTools.isBlank((String)tw) && !tw.equalsIgnoreCase(wname + _WAR)) {
                String war = StringTools.endsWithIgnoreCase((String)tw, (String)_WAR) ? tw : tw + _WAR;
                sb.append(" -D" + wname + ".deployWar=").append(war);
            }
            sb.append(" " + wname + ".deploy");
        } else {
            sb.append(" " + wname + _WAR);
        }
        return sb.toString();
    }
}

