/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config.views;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import org.opengts.opt.config.GTSConfig;
import org.opengts.opt.config.GTSProperties;
import org.opengts.opt.config.TailOutput;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VLabel;
import org.opengts.opt.ui.VSeparator;
import org.opengts.opt.ui.VShell;
import org.opengts.opt.ui.VSplitPane;
import org.opengts.opt.ui.VTextArea;
import org.opengts.opt.ui.VTextField;
import org.opengts.util.OSTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class Tomcat
extends GTSConfig.GTSBox {
    private static final String TOMCAT_CLASS = "org.apache.catalina.startup.Bootstrap";
    private static final boolean TOMCAT_COMMANDS = false;
    private static final String TOMCAT_CATALINA_OUT = File.separator + "logs" + File.separator + "catalina.out";
    private static final String PSJAVA_PERL = File.separator + "bin" + File.separator + "psjava";
    private VTextField tomcatStatus = null;
    private VButton updateBtn = null;
    private VButton startBtn = null;
    private VButton stopBtn = null;
    private VButton clearLogsBtn = null;
    private VSplitPane logSplitView = null;
    private VShell execShell = null;
    private VTextArea execOutput = null;
    private int tomcatInProcess = 0;
    private TailOutput catalinaOutput = null;

    public static String getPSTomcatCommand() {
        StringBuffer sb = new StringBuffer();
        sb.append(GTSProperties.GTS_HOME);
        sb.append(PSJAVA_PERL);
        sb.append(" -q");
        if (GTSProperties.isWindows()) {
            sb.append(" \"-c=").append(TOMCAT_CLASS).append("\"");
        } else {
            sb.append(" -c=").append(TOMCAT_CLASS);
        }
        return sb.toString();
    }

    public static String getTomcatStartupCommand() {
        StringBuffer sb = new StringBuffer();
        sb.append(GTSProperties.GTS_HOME);
        sb.append(File.separator);
        sb.append("bin");
        sb.append(File.separator);
        if (OSTools.isWindows()) {
            sb.append("tomcat.bat startup");
        } else {
            sb.append("tomcat.sh startup");
        }
        return sb.toString();
    }

    public static String getTomcatShutdownCommand() {
        StringBuffer sb = new StringBuffer();
        sb.append(GTSProperties.GTS_HOME);
        sb.append(File.separator);
        sb.append("bin");
        sb.append(File.separator);
        if (OSTools.isWindows()) {
            sb.append("tomcat.bat shutdown");
        } else {
            sb.append("tomcat.sh shutdown");
        }
        return sb.toString();
    }

    public static File getTomcatCatalinaOutput() {
        StringBuffer sb = new StringBuffer();
        sb.append(GTSProperties.CATALINA_HOME);
        sb.append(TOMCAT_CATALINA_OUT);
        return new File(sb.toString());
    }

    public Tomcat(GTSConfig gtsConfig) {
        super(gtsConfig);
        VLabel label = new VLabel();
        GridBagConstraints labelGBC = VBox.NewGBC();
        VBox.SetGBCX((GridBagConstraints)labelGBC, (double)0.5, (int)0, (int)4, (int)0, (int)0);
        VBox.SetGBCY((GridBagConstraints)labelGBC, (double)0.0, (int)0, (int)1, (int)5, (int)10);
        labelGBC.fill = 2;
        labelGBC.anchor = 10;
        this.add((Component)label, labelGBC);
        label.setText("This screen checks the status of Tomcat and allows starting/stopping the Tomcat process.");
        this.setGBCX(0.5, 0, 4, 0, 0);
        this.setGBCY(0.0, 1, 1, 0, 5);
        this.add((Component)new VSeparator(), this.getDefaultGBC());
        this.tomcatStatus = new VTextField(null, "Tomcat Status: ", false);
        this.tomcatStatus.setColumns(8);
        this.tomcatStatus.setReadOnly(true);
        this.tomcatStatus.getJTextField().setFont(VBox.FONT_SANSERIF_BOLD((int)13));
        this.tomcatStatus.setText("Unknown");
        this.setGBCX(0.5, 0, 4, 10, 0);
        this.setGBCY(0.0, 2, 1, 0, 5);
        this.add((Component)this.tomcatStatus, this.getDefaultGBC());
        this.updateBtn = new VButton("Update Status");
        this.updateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Tomcat.this.updateButtons(0);
            }
        });
        this.setGBCX(0.0, 0, 1, 10, 5);
        this.setGBCY(0.0, 3, 1, 0, 0);
        this.add((Component)this.updateBtn, this.getDefaultGBC());
        this.startBtn = new VButton("Start Tomcat");
        this.startBtn.setEnabled(false);
        this.startBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Tomcat.this._disableButtons();
                Tomcat.this.setTomcatRunning(true);
            }
        });
        this.setGBCX(0.0, 1, 1, 5, 5);
        this.setGBCY(0.0, 3, 1, 0, 0);
        this.add((Component)this.startBtn, this.getDefaultGBC());
        this.stopBtn = new VButton("Stop Tomcat");
        this.stopBtn.setEnabled(false);
        this.stopBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Tomcat.this._disableButtons();
                Tomcat.this.setTomcatRunning(false);
            }
        });
        this.setGBCX(0.0, 2, 1, 5, 5);
        this.setGBCY(0.0, 3, 1, 0, 0);
        this.add((Component)this.stopBtn, this.getDefaultGBC());
        this.clearLogsBtn = new VButton("Clear Logs");
        this.clearLogsBtn.setEnabled(true);
        this.clearLogsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Tomcat.this.execOutput.setText("");
                Tomcat.this.catalinaOutput.setText("");
            }
        });
        GridBagConstraints clearGBC = VBox.NewGBC();
        VBox.SetGBCX((GridBagConstraints)clearGBC, (double)0.0, (int)3, (int)1, (int)5, (int)5);
        VBox.SetGBCY((GridBagConstraints)clearGBC, (double)0.0, (int)3, (int)1, (int)0, (int)0);
        clearGBC.anchor = 13;
        this.add((Component)this.clearLogsBtn, clearGBC);
        this.execShell = new VShell("Command Output", null, true){

            protected void execFinished(int exitStatus) {
                Tomcat.this.updateButtons(3000);
                Tomcat.this.execOutput.appendText("\n", true);
                Tomcat.this.execOutput.appendText(StringTools.replicateString((String)"=", (int)60) + "\n", true);
            }
        };
        this.execShell.combineOutput(true);
        this.execShell.setStdinHidden(true);
        this.execShell.setLineWrap(false);
        this.execOutput = this.execShell.getStdoutTextArea();
        this.catalinaOutput = new TailOutput();
        this.catalinaOutput.setMaxLogSize(50000L);
        this.execShell.setPreferredHeight(120);
        this.catalinaOutput.setPreferredHeight(300);
        this.logSplitView = new VSplitPane(0, (Component)this.execShell, (Component)((Object)this.catalinaOutput));
        this.setGBCX(0.5, 0, 4, 0, 0);
        this.setGBCY(0.5, 5, 1, 5, 0);
        this.add((Component)this.logSplitView, this.getDefaultGBC());
        this.logSplitView.setResizeWeight(0.0);
        this.catalinaOutput.setTailFile(Tomcat.getTomcatCatalinaOutput());
    }

    @Override
    protected void _refresh() {
        this.catalinaOutput.refresh();
        this.updateButtons(0);
    }

    private void _disableButtons() {
        this.tomcatStatus.setText("?");
        this.updateBtn.setEnabled(false);
        this.startBtn.setEnabled(false);
        this.stopBtn.setEnabled(false);
    }

    private void _updateButtons() {
        if (this.tomcatInProcess > 0) {
            this._disableButtons();
        } else if (this.isTomcatRunning()) {
            this.tomcatStatus.setText("Running");
            this.updateBtn.setEnabled(true);
            this.startBtn.setEnabled(false);
            this.stopBtn.setEnabled(true);
        } else {
            this.tomcatStatus.setText("Stopped");
            this.updateBtn.setEnabled(true);
            this.startBtn.setEnabled(true);
            this.stopBtn.setEnabled(false);
        }
    }

    private void updateButtons(final int waitMS) {
        final boolean isRunning = this.isTomcatRunning();
        this._disableButtons();
        new Thread(){

            @Override
            public void run() {
                if (waitMS > 0) {
                    int intervalMS = 500;
                    for (int ms = 0; ms < waitMS && isRunning == Tomcat.this.isTomcatRunning(); ms += intervalMS) {
                        try {
                            Thread.sleep(intervalMS);
                            continue;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Tomcat.this._updateButtons();
                    }
                });
            }
        }.start();
    }

    public boolean setTomcatRunning(boolean start) {
        boolean isRunning = this.isTomcatRunning();
        if (start == isRunning) {
            this.updateButtons(0);
            return true;
        }
        if (this.tomcatInProcess == 0) {
            String cmd;
            ++this.tomcatInProcess;
            this.execOutput.appendText("\n", true);
            if (start) {
                cmd = Tomcat.getTomcatStartupCommand();
                this.execOutput.appendText("Starting Tomcat web-server:\n\n", true);
            } else {
                cmd = Tomcat.getTomcatShutdownCommand();
                this.execOutput.appendText("Stopping Tomcat web-server:\n\n", true);
            }
            new Thread(){

                @Override
                public void run() {
                    if (GTSProperties.isUnixOrMac()) {
                        Tomcat.this.execOutput.appendText("% " + cmd + "\n", true);
                        try {
                            Tomcat.this.execShell.execCommand(cmd);
                        }
                        catch (InterruptedException ie) {}
                    } else if (GTSProperties.isWindows()) {
                        Tomcat.this.execOutput.appendText("> " + cmd + "\n\n", true);
                        try {
                            Tomcat.this.execShell.execCommand(cmd);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        Tomcat.this.execOutput.appendText("? " + cmd + "\n\n", true);
                        Tomcat.this.execOutput.appendText("Unrecognized Operating system (command ignored)", true);
                    }
                    Tomcat.this.tomcatInProcess--;
                }
            }.start();
            while (!this.execShell.isExecFinished()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable t) {}
            }
            return this.execShell.getExitStatus() == 0;
        }
        Print.logWarn((String)"Previous Tomcat start/stop is still running ...", (Object[])new Object[0]);
        return false;
    }

    public boolean isTomcatRunning() {
        if (GTSProperties.isUnixOrMac()) {
            try {
                String cmd = Tomcat.getPSTomcatCommand();
                Process process = Runtime.getRuntime().exec(cmd);
                if (process != null) {
                    process.waitFor();
                    int exitVal = process.exitValue();
                    return exitVal == 0;
                }
                Print.logError((String)("Unable to execute command: " + cmd), (Object[])new Object[0]);
                return false;
            }
            catch (Throwable th) {
                Print.logException((String)"Unable to determine if Tomcat is running:", (Throwable)th);
                return false;
            }
        }
        if (GTSProperties.isWindows()) {
            Print.logError((String)"Command not supported on this platform", (Object[])new Object[0]);
            return false;
        }
        Print.logError((String)"Command not supported on this platform", (Object[])new Object[0]);
        return false;
    }
}

