/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config.views;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import org.opengts.opt.config.GTSConfig;
import org.opengts.opt.config.GTSProperties;
import org.opengts.opt.config.TailOutput;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VFileChooser;
import org.opengts.opt.ui.VLabel;
import org.opengts.opt.ui.VSeparator;

public class LogFile
extends GTSConfig.GTSBox {
    private static final long MAX_TAIL_SIZE = 250000L;
    private VButton chooseBtn = null;
    private File lastLogDir = null;
    private VLabel tailLabel = new VLabel();
    private TailOutput tailOutput = null;

    public LogFile(GTSConfig gtsConfig, File logFile, long maxLogSize) {
        super(gtsConfig);
        GridBagConstraints labelGBC = VBox.NewGBC();
        VBox.SetGBCX((GridBagConstraints)labelGBC, (double)0.5, (int)0, (int)2, (int)0, (int)0);
        VBox.SetGBCY((GridBagConstraints)labelGBC, (double)0.0, (int)0, (int)1, (int)5, (int)10);
        labelGBC.fill = 2;
        labelGBC.anchor = 10;
        this.add((Component)this.tailLabel, labelGBC);
        this.chooseBtn = new VButton("Choose");
        this.chooseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LogFile.this.chooseFile();
            }
        });
        this.setGBCX(0.0, 2, 1, 0, 5);
        this.setGBCY(0.0, 0, 1);
        this.add((Component)this.chooseBtn, this.getDefaultGBC());
        this.setGBCX(0.5, 0, 3, 0, 0);
        this.setGBCY(0.0, 1, 1, 0, 5);
        this.add((Component)new VSeparator(), this.getDefaultGBC());
        this.tailOutput = new TailOutput();
        this.setGBCX(0.5, 0, 3);
        this.setGBCY(0.5, 2, 1);
        this.add((Component)((Object)this.tailOutput), this.getDefaultGBC());
        this.tailOutput.setMaxLogSize(maxLogSize);
        this.setTailFile(logFile);
    }

    private void chooseFile() {
        File logDir = this.lastLogDir != null ? this.lastLogDir : new File(GTSProperties.GTS_HOME + File.separator + "logs");
        VFileChooser fc = new VFileChooser(logDir, "Log Files", new String[]{"log", "out"});
        File selFile = fc.showChooser((Component)((Object)this), "View Log File", true);
        if (selFile != null) {
            this.lastLogDir = selFile.getParentFile();
            this.setTailFile(selFile);
        }
    }

    private void setTailFile(File logFile) {
        this.tailOutput.setTailFile(logFile);
        this.tailLabel.setText("Tailing log file '" + logFile + "'");
    }

    @Override
    protected void _refresh() {
        this.tailOutput.refresh();
    }
}

