/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config.views;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.opt.config.GTSConfig;
import org.opengts.opt.config.GTSProperties;
import org.opengts.opt.config.TailOutput;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VComboBox;
import org.opengts.opt.ui.VFiller;
import org.opengts.opt.ui.VLabel;
import org.opengts.opt.ui.VSeparator;
import org.opengts.opt.ui.VTextField;
import org.opengts.util.ListTools;
import org.opengts.util.Print;

public class DCServerMonitor
extends GTSConfig.GTSBox {
    private static final String PSJAVA_PERL = File.separator + "bin" + File.separator + "psjava";
    private VComboBox dcCombo = null;
    private VTextField dcStatus = null;
    private TailOutput tailOutput = null;
    private List<DCServerConfig> dcServers = null;

    public static String getPSDCServerCommand(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(GTSProperties.GTS_HOME);
        sb.append(PSJAVA_PERL);
        sb.append(" -q");
        if (GTSProperties.isWindows()) {
            sb.append(" \"-jar=").append(name).append(".jar\"");
        } else {
            sb.append(" -jar=").append(name).append(".jar");
        }
        return sb.toString();
    }

    public boolean isDCServerRunning(String name) {
        if (GTSProperties.isUnixOrMac()) {
            try {
                String cmd = DCServerMonitor.getPSDCServerCommand(name);
                Process process = Runtime.getRuntime().exec(cmd);
                if (process != null) {
                    process.waitFor();
                    int exitVal = process.exitValue();
                    return exitVal == 0;
                }
                Print.logError((String)("Unable to execute command: " + cmd), (Object[])new Object[0]);
                return false;
            }
            catch (Throwable th) {
                Print.logException((String)"Unable to determine if Tomcat is running:", (Throwable)th);
                return false;
            }
        }
        if (GTSProperties.isWindows()) {
            Print.logError((String)"Command not supported on this platform", (Object[])new Object[0]);
            return false;
        }
        Print.logError((String)"Command not supported on this platform", (Object[])new Object[0]);
        return false;
    }

    public DCServerMonitor(GTSConfig gtsConfig) {
        super(gtsConfig);
        int spanX = 4;
        int col = 0;
        int row = 0;
        VLabel label = new VLabel();
        GridBagConstraints labelGBC = VBox.NewGBC();
        VBox.SetGBCX((GridBagConstraints)labelGBC, (double)0.5, (int)0, (int)spanX, (int)0, (int)0);
        VBox.SetGBCY((GridBagConstraints)labelGBC, (double)0.0, (int)row, (int)1, (int)5, (int)10);
        labelGBC.fill = 2;
        labelGBC.anchor = 10;
        this.add((Component)label, labelGBC);
        label.setText("This screen allows monitoring Device Communication Server log files.");
        this.setGBCX(0.5, 0, spanX, 0, 0);
        this.setGBCY(0.0, ++row, 1, 0, 5);
        this.add((Component)new VSeparator(), this.getDefaultGBC());
        ++row;
        col = 0;
        this.dcCombo = new VComboBox(null, "Servers:", false);
        this.dcServers = DCServerFactory.getServerConfigList((boolean)true);
        Vector<String> dcNames = new Vector<String>();
        for (DCServerConfig dcs : this.dcServers) {
            dcNames.add(dcs.getName());
        }
        this.dcCombo.setModel(dcNames);
        this.dcCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DCServerMonitor.this.refresh();
            }
        });
        this.setGBCX(0.5, col, 1, 4, 0);
        this.setGBCY(0.0, row, 1, 0, 5);
        this.add((Component)this.dcCombo, this.getDefaultGBC());
        ++col;
        this.dcStatus = new VTextField(null, "Status:", false);
        this.dcStatus.setColumns(8);
        this.dcStatus.setReadOnly(true);
        this.dcStatus.getJTextField().setFont(VBox.FONT_SANSERIF_BOLD((int)13));
        this.dcStatus.setText("Unknown");
        this.setGBCX(0.5, col, 1, 10, 0);
        this.setGBCY(0.0, row, 1, 0, 5);
        this.add((Component)this.dcStatus, this.getDefaultGBC());
        this.setGBCX(0.5, ++col, 1, 0, 0);
        this.setGBCY(0.0, row, 1, 0, 5);
        this.add((Component)new VFiller(), this.getDefaultGBC());
        this.setGBCX(0.5, ++col, 1, 0, 0);
        this.setGBCY(0.0, row, 1, 0, 5);
        this.add((Component)new VFiller(), this.getDefaultGBC());
        this.setGBCX(0.5, 0, spanX, 0, 0);
        this.setGBCY(0.0, ++row, 1, 0, 5);
        this.add((Component)new VSeparator(), this.getDefaultGBC());
        this.tailOutput = new TailOutput();
        this.setGBCX(0.5, 0, spanX);
        this.setGBCY(0.5, ++row, 1);
        this.add((Component)((Object)this.tailOutput), this.getDefaultGBC());
        this.tailOutput.setMaxLogSize(100000L);
        this.tailOutput.setTailFile(null);
    }

    private String getSelectedDCServerName() {
        return this.dcCombo.getStringValue("");
    }

    private DCServerConfig getSelectedDCServerConfig() {
        return DCServerFactory.getServerConfig((String)this.getSelectedDCServerName());
    }

    @Override
    public void refresh() {
        DCServerConfig dcs = this.getSelectedDCServerConfig();
        Object[] jarPath = dcs != null ? dcs.getRunningJarPath() : null;
        boolean isRunning = !ListTools.isEmpty((Object[])jarPath);
        this.dcStatus.setText(isRunning ? "Running" : "Stopped");
        File logFile = isRunning ? DCServerConfig.getLogFilePath((File)jarPath[0]) : null;
        this.tailOutput.setTailFile(logFile);
        this.tailOutput.refresh();
    }
}

