/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config.views;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.opengts.opt.config.GTSConfig;
import org.opengts.opt.config.PropertyGroup;
import org.opengts.opt.config.PropertyGroupValidator;
import org.opengts.opt.config.PropertyItem;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VFiller;
import org.opengts.opt.ui.VLabelValue;
import org.opengts.opt.ui.VListViewer;
import org.opengts.opt.ui.VScrollPane;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class ConfigProperties
extends GTSConfig.GTSBox
implements VListViewer.ItemValidator {
    private ConfigLabelValue labelValue = null;
    private File configXMLFile = null;
    private String headerTitle = null;
    private Map<String, PropertyGroup> propGroupMap = null;
    private RTProperties privateConf = null;
    private boolean changed = false;

    public ConfigProperties(GTSConfig gtsConfig, PropertyGroup propGroup, RTProperties privateConf) {
        super(gtsConfig);
        this.headerTitle = propGroup.getDescription();
        this.privateConf = privateConf;
        this.propGroupMap = new OrderedMap();
        this.propGroupMap.put(propGroup.getName(), propGroup);
        this.init();
    }

    public ConfigProperties(GTSConfig gtsConfig, Map<String, PropertyGroup> propGroupMap, RTProperties privateConf) {
        super(gtsConfig);
        this.headerTitle = null;
        this.privateConf = privateConf;
        this.propGroupMap = propGroupMap;
        this.init();
    }

    public void init() {
        ConfigProperties container = this;
        if (!StringTools.isBlank((String)this.headerTitle)) {
            container = new VBox(this.headerTitle, null, true);
            this.setGBCX(0.5, 0, 1);
            this.setGBCY(0.5, 0, 1);
            this.add((Component)((Object)container), this.getDefaultGBC());
        }
        VBox configBox = new VBox(null, null, false);
        this.labelValue = new ConfigLabelValue();
        GridBagConstraints configGBC = VBox.NewGBC();
        VBox.SetGBCX((GridBagConstraints)configGBC, (double)0.5, (int)0, (int)1, (int)5, (int)0);
        VBox.SetGBCY((GridBagConstraints)configGBC, (double)0.0, (int)0, (int)1);
        configGBC.anchor = 18;
        configBox.add((Component)((Object)this.labelValue), (Object)configGBC);
        VBox.SetGBCX((GridBagConstraints)configGBC, (double)0.5, (int)0, (int)1);
        VBox.SetGBCY((GridBagConstraints)configGBC, (double)0.5, (int)1, (int)1);
        configBox.add((Component)new VFiller(), (Object)configGBC);
        VScrollPane scrollView = new VScrollPane((Component)configBox, true, true);
        container.setGBCX(0.5, 0, 1);
        container.setGBCY(0.5, 1, 1);
        container.add((Component)scrollView, container.getDefaultGBC());
        int pgCnt = 0;
        for (PropertyGroup pg : this.getPropertyGroups().values()) {
            if (pgCnt > 0) {
                this.labelValue.addSeparator();
            }
            int piCnt = 0;
            for (PropertyItem pi : pg.getPropertyList().values()) {
                if (StringTools.isBlank((String)pi.getKey())) {
                    this.labelValue.addSeparator();
                    continue;
                }
                if (pi.isHidden()) continue;
                VLabelValue.VLabelValueRow row = this.labelValue.addRow(pi.getTitle(), pi.getLabel(), pi.getHelp(), pi.getEditor(), pi, pi.getKey());
                row.setReadOnly(pi.getReadOnly());
                row.setToolTipText(pi.getToolTip());
                pi.setLabelValueRow(row);
                ++piCnt;
            }
            if (piCnt <= 0) continue;
            ++pgCnt;
        }
        this.refresh();
    }

    protected Map<String, PropertyGroup> getPropertyGroups() {
        if (this.propGroupMap == null) {
            this.propGroupMap = new OrderedMap();
        }
        return this.propGroupMap;
    }

    @Override
    protected void _refresh() {
        for (PropertyGroup pg : this.getPropertyGroups().values()) {
            for (PropertyItem pi : pg.getPropertyList().values()) {
                if (pi.isHidden()) continue;
                VLabelValue.VLabelValueRow row = this.labelValue.getRow(pi.getKey());
                if (row != null) {
                    String piKey = pi.getKey();
                    String piVal = pi.getValue();
                    String cfVal = this.privateConf.getString(piKey, piVal);
                    pi.setValue(cfVal);
                    row.setValue((Object)pi.getValue());
                    row.setReadOnly(pi.getReadOnly());
                    continue;
                }
                Print.logError((String)("Row key not found: " + pi.getKey()), (Object[])new Object[0]);
            }
        }
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged() {
        this.changed = true;
    }

    public void clearChanged() {
        this.changed = false;
    }

    public boolean isListItemValid(boolean okToAlertUser) {
        Iterator<PropertyGroup> i$ = this.propGroupMap.values().iterator();
        if (i$.hasNext()) {
            PropertyGroup pg = i$.next();
            if (!pg.isValid()) {
                return false;
            }
            PropertyGroupValidator validator = PropertyGroupValidator.GetValidator(pg.getName());
            String validateMsg = validator.getValidateMessage(pg, null);
            if (StringTools.isBlank((String)validateMsg)) {
                return true;
            }
            if (okToAlertUser) {
                GTSConfig.showErrorDialog(validateMsg, "Invalid value specified");
            }
            return false;
        }
        return true;
    }

    protected class ConfigLabelValue
    extends VLabelValue {
        public ConfigLabelValue() {
            super(null, null, false);
            this.setDoubleRowDisplay(true);
        }

        protected void changed(VLabelValue.VLabelValueRow row) {
            if (row != null) {
                String newVal;
                String key = row.getKey();
                PropertyItem pi = (PropertyItem)row.getData();
                Object rv = row.getValue();
                String string = newVal = rv != null ? rv.toString() : null;
                if (pi.setValue(newVal)) {
                    ConfigProperties.this.setChanged();
                }
                ConfigProperties.this.privateConf.setString(key, pi.getValue());
                ConfigProperties.this.refresh();
            }
        }
    }
}

