/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import org.opengts.opt.config.GTSProperties;
import org.opengts.opt.config.PropertyGroup;
import org.opengts.opt.config.PropertyItem;
import org.opengts.util.FileTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyItemLoader {
    public static final String TAG_GTSConfig = "GTSConfig";
    public static final String TAG_Welcome = "Welcome";
    public static final String TAG_ConfigProperties = "ConfigProperties";
    public static final String TAG_Property = "Property";
    public static final String TAG_Completion = "Completion";
    public static final String TAG_PropertyGroup = "PropertyGroup";
    public static final String TAG_PropertyItem = "PropertyItem";
    public static final String TAG_Description = "Description";
    public static final String TAG_Label = "Label";
    public static final String TAG_Help = "Help";
    public static final String TAG_Separator = "Separator";
    public static final String TAG_FieldLength = "FieldLength";
    public static final String TAG_DefaultValue = "DefaultValue";
    public static final String TAG_Selection = "Selection";
    public static final String TAG_SelectionItem = "SelectionItem";
    public static final String TAG_ReadOnly = "ReadOnly";
    public static final String TAG_ToolTip = "ToolTip";
    public static final String ATTR_name = "name";
    public static final String ATTR_class = "class";
    public static final String ATTR_key = "key";
    public static final String ATTR_type = "type";
    public static final String ATTR_readOnly = "readOnly";
    public static final String ATTR_hidden = "hidden";
    public static final String ATTR_blankOk = "blankOk";
    public static final String ATTR_default = "default";
    public static final String ATTR_unless = "unless";
    private String welcome = null;
    private Map<String, PropertyGroup> propGroupMap = null;
    private String completion = null;

    public PropertyItemLoader(File configXMLFile) {
        this.loadXML(configXMLFile);
    }

    public String getWelcome() {
        return StringTools.trim((String)this.welcome);
    }

    public Map<String, PropertyGroup> getPropertyGroupMap() {
        if (this.propGroupMap == null) {
            this.propGroupMap = new OrderedMap();
        }
        return this.propGroupMap;
    }

    public String getCompletion() {
        return StringTools.trim((String)this.completion);
    }

    protected boolean loadXML(File configXMLFile) {
        Document xmlDoc;
        if (configXMLFile == null) {
            Print.logError((String)"Specified GTSConfig XML file is null", (Object[])new Object[0]);
            return false;
        }
        File realCfgFile = FileTools.getRealFile((File)configXMLFile);
        if (realCfgFile == null) {
            Print.logError((String)("Unable to resolve GTSConfig file: " + configXMLFile), (Object[])new Object[0]);
            return false;
        }
        configXMLFile = realCfgFile;
        Print.logInfo((String)("Loading GTSConfig xml file: " + configXMLFile), (Object[])new Object[0]);
        Document document = xmlDoc = configXMLFile != null ? XMLTools.getDocument((File)configXMLFile) : null;
        if (xmlDoc == null) {
            Print.logError((String)("Unable to create XML Document from file: " + configXMLFile), (Object[])new Object[0]);
            return false;
        }
        Element gtsConfig = xmlDoc.getDocumentElement();
        if (!gtsConfig.getTagName().equalsIgnoreCase(TAG_GTSConfig)) {
            Print.logError((String)"Missing 'GTSConfig' tag", (Object[])new Object[0]);
            return false;
        }
        this.propGroupMap = new OrderedMap();
        HashSet<String> piSet = new HashSet<String>();
        NodeList gtsConfigNodeList = gtsConfig.getChildNodes();
        for (int n = 0; n < gtsConfigNodeList.getLength(); ++n) {
            Node configNode = gtsConfigNodeList.item(n);
            if (!(configNode instanceof Element)) continue;
            Element configNodeElem = (Element)configNode;
            String configNodeName = configNode.getNodeName();
            if (configNodeName.equalsIgnoreCase(TAG_ConfigProperties)) {
                NodeList propertyList = configNodeElem.getChildNodes();
                for (int p = 0; p < propertyList.getLength(); ++p) {
                    Node propertyNode = propertyList.item(p);
                    if (!(propertyNode instanceof Element)) continue;
                    Element propertyElem = (Element)propertyNode;
                    String propNodeName = propertyNode.getNodeName();
                    if (!propNodeName.equalsIgnoreCase(TAG_Property)) continue;
                    String propKey = XMLTools.getAttribute((Element)propertyElem, (String)ATTR_key, (String)"", (boolean)false);
                    String propVal = XMLTools.getNodeText((Node)propertyElem, (String)" ", (boolean)true).trim();
                    if (StringTools.isBlank((String)propKey) || GTSProperties.hasProperty(propKey)) continue;
                    GTSProperties.setString(propKey, propVal);
                }
                continue;
            }
            if (configNodeName.equalsIgnoreCase(TAG_Welcome)) {
                this.welcome = XMLTools.getNodeText((Node)configNodeElem, (String)"\n", (boolean)true);
                continue;
            }
            if (configNodeName.equalsIgnoreCase(TAG_PropertyGroup)) {
                String pgName = XMLTools.getAttribute((Element)configNodeElem, (String)ATTR_name, (String)"", (boolean)false);
                String pgClas = XMLTools.getAttribute((Element)configNodeElem, (String)ATTR_class, (String)"", (boolean)false);
                String pgDesc = null;
                OrderedMap piMap = new OrderedMap();
                NodeList groupNodeList = configNodeElem.getChildNodes();
                for (int e = 0; e < groupNodeList.getLength(); ++e) {
                    Node groupNode = groupNodeList.item(e);
                    if (!(groupNode instanceof Element)) continue;
                    Element groupNodeElem = (Element)groupNode;
                    String groupNodeName = groupNode.getNodeName();
                    if (groupNodeName.equalsIgnoreCase(TAG_PropertyItem)) {
                        PropertyItem pi = this.parseTag_PropertyItem((Map<String, PropertyItem>)piMap, groupNodeElem);
                        if (pi == null) continue;
                        if (piSet.contains(pi.getKey())) {
                            Print.logError((String)("PropertyItem key already defined: " + pgName + "/" + pi.getKey()), (Object[])new Object[0]);
                            return false;
                        }
                        piSet.add(pi.getKey());
                        piMap.put(pi.getKey(), pi);
                        continue;
                    }
                    if (groupNodeName.equalsIgnoreCase(TAG_Separator)) {
                        piMap.put("sep_" + piMap.size(), new PropertyItem());
                        continue;
                    }
                    if (!groupNodeName.equalsIgnoreCase(TAG_Description)) continue;
                    pgDesc = XMLTools.getNodeText((Node)groupNodeElem, (String)"\n", (boolean)true).trim();
                }
                this.propGroupMap.put(pgName, PropertyGroup.createPropertyGroup(pgClas, pgName, pgDesc, (Map<String, PropertyItem>)piMap));
                continue;
            }
            if (!configNodeName.equalsIgnoreCase(TAG_Completion)) continue;
            this.completion = XMLTools.getNodeText((Node)configNodeElem, (String)"\n", (boolean)true);
        }
        return true;
    }

    protected PropertyItem parseTag_PropertyItem(Map<String, PropertyItem> piMap, Element propertyItem) {
        String propValue;
        String key = XMLTools.getAttribute((Element)propertyItem, (String)ATTR_key, null, (boolean)false);
        String type = XMLTools.getAttribute((Element)propertyItem, (String)ATTR_type, null, (boolean)false);
        boolean hidden = XMLTools.getAttributeBoolean((Element)propertyItem, (String)ATTR_hidden, (boolean)false, (boolean)false);
        boolean blankOk = XMLTools.getAttributeBoolean((Element)propertyItem, (String)ATTR_blankOk, (boolean)true, (boolean)false);
        String desc = null;
        String label = null;
        String help = null;
        String tooltip = null;
        String dftValue = null;
        int fldLen = -1;
        Map selection = null;
        if (StringTools.isBlank((String)key)) {
            Print.logError((String)"Missing 'key' attribute", (Object[])new Object[0]);
            return null;
        }
        if (key.equalsIgnoreCase("none")) {
            return null;
        }
        if (key.equalsIgnoreCase("separator")) {
            return new PropertyItem();
        }
        boolean readOnly = XMLTools.getAttributeBoolean((Element)propertyItem, (String)ATTR_readOnly, (boolean)false, (boolean)false);
        PropertyItem readOnlyUnlessProp = null;
        String readOnlyUnlessVal = null;
        int typeEnum = 1;
        if (StringTools.isBlank((String)type)) {
            Print.logError((String)"Missing 'type' attribute", (Object[])new Object[0]);
            return null;
        }
        if (type.equalsIgnoreCase("none")) {
            typeEnum = 0;
        } else if (type.equalsIgnoreCase("boolean")) {
            typeEnum = 4;
        } else if (type.equalsIgnoreCase("long")) {
            typeEnum = 5;
        } else if (type.equalsIgnoreCase("double")) {
            typeEnum = 6;
        } else if (type.equalsIgnoreCase("password")) {
            typeEnum = 2;
        } else if (type.equalsIgnoreCase("string")) {
            typeEnum = 1;
        } else if (type.equalsIgnoreCase("list")) {
            typeEnum = 3;
        } else if (type.equalsIgnoreCase("color")) {
            typeEnum = 7;
        } else {
            Print.logError((String)("Unrecognized 'type' attribute: " + type), (Object[])new Object[0]);
            return null;
        }
        NodeList tagList = propertyItem.getChildNodes();
        for (int c = 0; c < tagList.getLength(); ++c) {
            Node tagNode = tagList.item(c);
            if (!(tagNode instanceof Element)) continue;
            String tagName = tagNode.getNodeName();
            Element tagElem = (Element)tagNode;
            if (tagName.equalsIgnoreCase(TAG_Description)) {
                desc = XMLTools.getNodeText((Node)tagElem, (String)"\n", (boolean)true).trim();
                if (desc.indexOf("\n") < 0 || StringTools.startsWithIgnoreCase((String)desc, (String)"<html")) continue;
                desc = "<html>" + StringTools.htmlFilterText((Object)desc) + "</html>";
                continue;
            }
            if (tagName.equalsIgnoreCase(TAG_Label)) {
                label = XMLTools.getNodeText((Node)tagElem, (String)"\n", (boolean)true);
                continue;
            }
            if (tagName.equalsIgnoreCase(TAG_Help)) {
                help = XMLTools.getNodeText((Node)tagElem, (String)"\n", (boolean)true);
                continue;
            }
            if (tagName.equalsIgnoreCase(TAG_ToolTip)) {
                tooltip = XMLTools.getNodeText((Node)tagElem, (String)" ", (boolean)true);
                continue;
            }
            if (tagName.equalsIgnoreCase(TAG_FieldLength)) {
                String lenStr = XMLTools.getNodeText((Node)tagElem, (String)" ", (boolean)false);
                if (StringTools.isBlank((String)lenStr)) {
                    fldLen = -1;
                    continue;
                }
                if (StringTools.isLong((String)lenStr, (boolean)true)) {
                    fldLen = (int)StringTools.parseLong((String)lenStr, (long)0L);
                    continue;
                }
                Print.logError((String)("Unrecognized 'FieldLength' tag value: " + lenStr), (Object[])new Object[0]);
                return null;
            }
            if (tagName.equalsIgnoreCase(TAG_DefaultValue)) {
                dftValue = XMLTools.getNodeText((Node)tagElem, (String)" ", (boolean)true);
                continue;
            }
            if (tagName.equalsIgnoreCase(TAG_ReadOnly)) {
                String unlessKey = XMLTools.getAttribute((Element)tagElem, (String)ATTR_unless, null, (boolean)false);
                String roValue = XMLTools.getNodeText((Node)tagElem, (String)" ", (boolean)false);
                readOnly = XMLTools.getAttributeBoolean((Element)tagElem, (String)ATTR_readOnly, (boolean)readOnly, (boolean)false);
                if (!StringTools.isBlank((String)unlessKey)) {
                    PropertyItem unlessProp = piMap.get(unlessKey);
                    if (unlessProp != null) {
                        readOnlyUnlessProp = unlessProp;
                        readOnlyUnlessVal = roValue;
                        continue;
                    }
                    Print.logError((String)("'ReadOnly' tag 'unless' property key not found: " + unlessKey), (Object[])new Object[0]);
                    return null;
                }
                readOnly = StringTools.parseBoolean((String)roValue, (boolean)readOnly);
                readOnlyUnlessProp = null;
                readOnlyUnlessVal = null;
                continue;
            }
            if (!tagName.equalsIgnoreCase(TAG_Selection)) continue;
            selection = new OrderedMap();
            NodeList selList = XMLTools.getChildElements((Node)tagElem, (String)TAG_SelectionItem);
            for (int s = 0; s < selList.getLength(); ++s) {
                Element selItem = (Element)selList.item(s);
                String selKey = XMLTools.getAttribute((Element)selItem, (String)ATTR_key, null, (boolean)false);
                boolean selDft = XMLTools.getAttributeBoolean((Element)selItem, (String)ATTR_default, (boolean)false, (boolean)false);
                if (!StringTools.isBlank((String)selKey)) {
                    String selDesc = StringTools.blankDefault((String)XMLTools.getNodeText((Node)selItem, (String)" ", (boolean)false), (String)selKey);
                    if (!selection.containsKey(selDesc)) {
                        if (StringTools.isBlank((String)selDesc)) {
                            Print.logWarn((String)("[" + key + "] Selection description is blank, key=" + selKey), (Object[])new Object[0]);
                        }
                        selection.put(selDesc, selKey);
                        if (!selDft || !StringTools.isBlank((String)dftValue)) continue;
                        dftValue = selKey;
                        continue;
                    }
                    Print.logError((String)("[" + key + "] Selection already contains description '" + selDesc + "', key=" + selKey), (Object[])new Object[0]);
                    continue;
                }
                Print.logError((String)("[" + key + "] Missing SelectionItem '" + ATTR_key + "' attribute"), (Object[])new Object[0]);
                return null;
            }
            if (selection.size() > 0) continue;
            Print.logError((String)("[" + key + "] Selection tag with no items"), (Object[])new Object[0]);
            return null;
        }
        String string = propValue = GTSProperties.hasProperty(key) ? GTSProperties.getString(key, dftValue) : dftValue;
        if (selection != null) {
            boolean foundDefault = StringTools.isBlank((String)dftValue);
            boolean foundValue = StringTools.isBlank((String)propValue);
            if (!foundDefault || !foundValue) {
                for (String selKey : selection.keySet()) {
                    String selVal = (String)selection.get(selKey);
                    if (!foundDefault && selVal.equals(dftValue)) {
                        foundDefault = true;
                    }
                    if (!foundValue && selVal.equals(propValue)) {
                        foundValue = true;
                    }
                    if (!foundDefault || !foundValue) continue;
                    break;
                }
            }
            if (!foundDefault) {
                Print.logError((String)("'DefaultValue' not found in 'Selection' list: " + dftValue), (Object[])new Object[0]);
                return null;
            }
            if (!foundValue) {
                Print.logWarn((String)("Property value not found in 'Selection' list: " + propValue), (Object[])new Object[0]);
                propValue = dftValue;
            }
        }
        PropertyItem pi = new PropertyItem(key, desc, typeEnum, fldLen);
        pi.setHidden(hidden);
        pi.setBlankOK(blankOk);
        pi.setReadOnly(readOnly, readOnlyUnlessProp, readOnlyUnlessVal);
        pi.setSelection(selection);
        pi.setDefaultValue(propValue);
        pi.setValue(propValue);
        pi.setLabel(label);
        pi.setHelp(help);
        pi.setToolTip(tooltip);
        return pi;
    }
}

