/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JColorChooser;
import org.opengts.opt.config.GTSProperties;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VCheckBox;
import org.opengts.opt.ui.VComboBox;
import org.opengts.opt.ui.VFiller;
import org.opengts.opt.ui.VLabelValue;
import org.opengts.opt.ui.VTextField;
import org.opengts.util.ColorTools;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.StringTools;

public class PropertyItem {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_PASSWORD = 2;
    public static final int TYPE_LIST = 3;
    public static final int TYPE_BOOLEAN = 4;
    public static final int TYPE_LONG = 5;
    public static final int TYPE_DOUBLE = 6;
    public static final int TYPE_COLOR = 7;
    private boolean hidden = false;
    private boolean blankOk = true;
    private String key = "";
    private String title = "";
    private String label = "";
    private String help = "";
    private String tooltip = "";
    private int type = 1;
    private int length = -1;
    private Map<String, String> list = null;
    private boolean readOnly = false;
    private PropertyItem unlessProp = null;
    private String unlessVal = "";
    private String dftValue = "";
    private String value = "";
    private boolean changed = false;
    private VLabelValue.VLabelValueRow labelValueRow = null;

    public static String GetTypeName(int type) {
        switch (type) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "STRING";
            }
            case 2: {
                return "PASSWORD";
            }
            case 3: {
                return "LIST";
            }
            case 4: {
                return "BOOLEAN";
            }
            case 5: {
                return "LONG";
            }
            case 6: {
                return "DOUBLE";
            }
            case 7: {
                return "COLOR";
            }
        }
        return "unknown[" + type + "]";
    }

    public PropertyItem() {
        this(null, null, 1, -1, null);
    }

    public PropertyItem(String key, String title, int type) {
        this(key, title, type, -1, null);
    }

    public PropertyItem(String key, String title, int type, int len) {
        this(key, title, type, len, null);
    }

    public PropertyItem(String key, String title, String[] list) {
        this(key, title, 3, -1, PropertyItem.ToMapList(list));
    }

    public PropertyItem(String key, String title, Map<String, String> list) {
        this(key, title, 3, -1, list);
    }

    protected PropertyItem(String key, String title, int type, int len, Map<String, String> list) {
        this.key = StringTools.trim((String)key);
        this.title = StringTools.trim((String)title);
        this.type = type;
        this.list = !ListTools.isEmpty(list) ? list : null;
        this.length = len;
    }

    public String getKey() {
        return this.key;
    }

    public String getTitle() {
        return this.title;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        if (this.length <= 0) {
            switch (this.getType()) {
                case 0: {
                    return 0;
                }
                case 4: {
                    return 5;
                }
                case 5: 
                case 6: {
                    return 10;
                }
                case 1: {
                    return 40;
                }
                case 2: {
                    return 16;
                }
            }
            return 40;
        }
        return this.length;
    }

    public void setLabelValueRow(VLabelValue.VLabelValueRow row) {
        this.labelValueRow = row;
    }

    public VLabelValue.VLabelValueRow getLabelValueRow() {
        return this.labelValueRow;
    }

    public void setHidden(boolean hide) {
        this.hidden = hide;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public boolean isHidden() {
        return this.getHidden() || StringTools.isBlank((String)this.getKey());
    }

    public void setBlankOK(boolean blank) {
        this.blankOk = blank;
    }

    public boolean getBlankOK() {
        return this.blankOk;
    }

    public static Map<String, String> ToMapList(String[] list) {
        if (ListTools.isEmpty((Object[])list)) {
            return null;
        }
        OrderedMap map = new OrderedMap();
        for (int i = 0; i < list.length; ++i) {
            map.put(list[i], list[i]);
        }
        return map;
    }

    public void setSelection(String[] list) {
        this.setSelection(PropertyItem.ToMapList(list));
    }

    public void setSelection(Map<String, String> list) {
        this.list = list;
    }

    public Map<String, String> getSelection() {
        return !ListTools.isEmpty(this.list) ? this.list : null;
    }

    public void setReadOnly(boolean readOnly, PropertyItem unlessProp, String unlessVal) {
        this.readOnly = readOnly;
        this.unlessProp = unlessProp;
        this.unlessVal = StringTools.trim((String)unlessVal);
    }

    public boolean getReadOnly() {
        String unlPropVal;
        if (this.unlessProp != null && (unlPropVal = this.unlessProp.getValue()).equals(this.unlessVal)) {
            return !this.readOnly;
        }
        return this.readOnly;
    }

    public boolean isReadOnly() {
        return this.getReadOnly();
    }

    public void setDefaultValue(String value) {
        this.dftValue = StringTools.trim((String)value);
    }

    public String getDefaultValue() {
        return StringTools.trim((String)this.dftValue);
    }

    public boolean setValue(String value) {
        boolean didChange;
        String oldVal = this.getValue();
        String newVal = StringTools.trim((String)value);
        this.value = !newVal.equals("") ? newVal : this.getDefaultValue();
        GTSProperties.setString(this.getKey(), this.value);
        boolean bl = didChange = !oldVal.equals(this.value);
        if (didChange) {
            this.changed = true;
        }
        return didChange;
    }

    public String getValue() {
        String v = StringTools.trim((String)this.value);
        return !v.equals("") ? v : this.getDefaultValue();
    }

    public String getValue(boolean tryLabelValueFirst) {
        if (tryLabelValueFirst) {
            Object rowVal;
            VLabelValue.VLabelValueRow row = this.getLabelValueRow();
            Object object = rowVal = row != null ? row.getValue() : null;
            if (rowVal != null) {
                return StringTools.trim((Object)rowVal);
            }
        }
        return this.getValue();
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean didChange) {
        this.changed = didChange;
    }

    public void clearChanged() {
        this.setChanged(false);
    }

    public void setToolTip(String tooltip) {
        this.tooltip = StringTools.trim((String)tooltip);
    }

    public String getToolTip() {
        return StringTools.trim((String)this.tooltip);
    }

    public void setLabel(String label) {
        this.label = StringTools.trim((String)label);
    }

    public String getLabel() {
        return StringTools.trim((String)this.label);
    }

    public void setHelp(String help) {
        this.help = StringTools.trim((String)help);
    }

    public String getHelp() {
        return StringTools.trim((String)this.help);
    }

    public VBox getEditor() {
        VBox editor = null;
        Map<String, String> list = this.getSelection();
        editor = !ListTools.isEmpty(list) ? new ComboEditor(list) : (this.getType() == 0 ? null : (this.getType() == 4 ? new BooleanEditor() : (this.getType() == 7 ? new ColorEditor() : new TextFieldEditor(this.getLength(), this.getType()))));
        if (editor != null) {
            editor.setReadOnly(this.isReadOnly());
            String dft = this.getValue();
            if (!StringTools.isBlank((String)dft)) {
                editor.setValue(dft);
            }
        }
        return editor;
    }

    public String toString() {
        return this.getTitle();
    }

    private class ColorEditor
    extends VBox
    implements ActionListener {
        private Color colorVal;
        private VButton colorBtn;

        public ColorEditor() {
            super(null, null, true);
            this.colorVal = null;
            this.colorBtn = null;
            this.colorVal = Color.white;
            this.colorBtn = new VButton(this.colorVal);
            this.colorBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Color c = JColorChooser.showDialog((Component)((Object)ColorEditor.this), "Color Chooser", ColorEditor.this.colorBtn.getBackground());
                    if (c != null) {
                        ColorEditor.this.setValue(c);
                        ColorEditor.this.actionPerformed(ae);
                    }
                }
            });
            this.colorBtn.setPreferredWidth(75);
            this.colorBtn.setPreferredHeight(20);
            this.setGBCX(0.0, 0, 1);
            this.setGBCY(0.0, 0, 1);
            this.add((Component)this.colorBtn, this.getDefaultGBC());
            this.setGBCX(0.5, 1, 1);
            this.setGBCY(0.0, 0, 1);
            this.add((Component)new VFiller(), this.getDefaultGBC());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.fireActionEvent(null);
        }

        public void setValue(Object value) {
            this.colorVal = value instanceof Color ? (Color)value : ColorTools.parseColor((String)StringTools.trim((Object)value), (Color)Color.white);
            this.colorBtn.setBackground(this.colorVal);
            this.colorBtn.setLedColor(this.colorVal);
        }

        public Object getValue() {
            return ColorTools.toHexString((Color)this.colorVal, (boolean)true);
        }

        public void setReadOnly(boolean ro) {
            if (ro) {
                this.colorBtn.setBackground(Color.lightGray);
                this.colorBtn.setLedColor(Color.lightGray);
            } else {
                this.colorBtn.setBackground(this.colorVal);
                this.colorBtn.setLedColor(this.colorVal);
            }
            super.setReadOnly(ro);
        }
    }

    private class BooleanEditor
    extends VBox
    implements ActionListener {
        private VCheckBox check;

        public BooleanEditor() {
            super(null, null, false);
            this.check = null;
            this.check = new VCheckBox(null, null, false);
            this.check.addActionListener((ActionListener)this);
            this.setGBCX(0.0, 0, 1);
            this.setGBCY(0.0, 0, 1);
            this.add((Component)this.check, this.getDefaultGBC());
            this.setGBCX(0.5, 1, 1);
            this.setGBCY(0.0, 0, 1);
            this.add((Component)new VFiller(), this.getDefaultGBC());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.fireActionEvent(null);
        }

        public void setValue(Object value) {
            this.check.setValue(value);
        }

        public Object getValue() {
            return this.check.getValue();
        }
    }

    private class ComboEditor
    extends VBox
    implements ActionListener {
        private VComboBox combo;

        public ComboEditor(Map<String, String> list) {
            super(null, null, false);
            this.combo = null;
            this.combo = new VComboBox(list);
            this.combo.addActionListener((ActionListener)this);
            this.setGBCX(0.0, 0, 1);
            this.setGBCY(0.0, 0, 1);
            this.add((Component)this.combo, this.getDefaultGBC());
            this.setGBCX(0.5, 1, 1);
            this.setGBCY(0.0, 0, 1);
            this.add((Component)new VFiller(), this.getDefaultGBC());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.fireActionEvent(null);
        }

        public void setValue(Object value) {
            this.combo.setSelectedProperty(value);
        }

        public Object getValue() {
            return this.combo.getSelectedProperty();
        }
    }

    private class TextFieldEditor
    extends VBox
    implements ActionListener {
        private VTextField textField = null;

        public TextFieldEditor(int columns, int type) {
            switch (type) {
                case 0: {
                    this.textField = null;
                    break;
                }
                case 5: {
                    this.textField = new VTextField(null, null, false, "formatted");
                    this.textField.getJTextField().setFont(VBox.FONT_MONOSPACED_PLAIN);
                    this.textField.setFormatMask(StringTools.replicateString((String)"*", (int)columns), "0123456789-");
                    break;
                }
                case 6: {
                    this.textField = new VTextField(null, null, false, "formatted");
                    this.textField.getJTextField().setFont(VBox.FONT_MONOSPACED_PLAIN);
                    this.textField.setFormatMask(StringTools.replicateString((String)"*", (int)columns), "0123456789-.");
                    break;
                }
                case 2: {
                    this.textField = new VTextField(null, null, false, "password");
                    break;
                }
                default: {
                    this.textField = new VTextField(null, null, false, "standard");
                }
            }
            if (this.textField != null) {
                this.textField.setColumns(columns);
                this.textField.addActionListener((ActionListener)this);
                this.setGBCX(0.0, 0, 1);
                this.setGBCY(0.0, 0, 1);
                this.add((Component)this.textField, this.getDefaultGBC());
            }
            this.setGBCX(0.5, 2, 1);
            this.setGBCY(0.0, 0, 1);
            this.add((Component)new VFiller(), this.getDefaultGBC());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.fireActionEvent(null);
        }

        public void setValue(Object value) {
            if (this.textField != null) {
                this.textField.setValue(value);
            }
        }

        public Object getValue() {
            if (this.textField != null) {
                return this.textField.getValue();
            }
            return null;
        }
    }
}

