/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config;

import java.util.HashMap;
import java.util.Map;
import org.opengts.opt.config.PropertyGroup;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class PropertyGroupValidator {
    private static PropertyGroupValidator AlwaysValid;
    private static PropertyGroupValidator DefaultValidator;
    private static Map<String, PropertyGroupValidator> ValidatorMap;
    private PropertyGroup propGroup = null;

    public static void SetDefaultValidator(PropertyGroupValidator pgv) {
        DefaultValidator = pgv != null ? pgv : AlwaysValid;
    }

    public static void AddValidator(String name, PropertyGroupValidator pgv) {
        if (!StringTools.isBlank((String)name) && pgv != null) {
            ValidatorMap.put(name, pgv);
        }
    }

    public static PropertyGroupValidator GetValidator(String name) {
        PropertyGroupValidator pgv = ValidatorMap.get(name);
        return pgv != null ? pgv : DefaultValidator;
    }

    public static boolean HasValidator(String name) {
        return ValidatorMap.containsKey(name);
    }

    public PropertyGroupValidator() {
        this(null);
    }

    public PropertyGroupValidator(PropertyGroup pg) {
        this.propGroup = pg;
    }

    public boolean hasPropertyGroup() {
        return this.propGroup != null;
    }

    public PropertyGroup getPropertyGroup() {
        return this.propGroup;
    }

    public String getValidateMessage(PropertyGroup pg, String itemKey) {
        if (pg != null) {
            if (this.propGroup != null && this.propGroup != pg) {
                Print.logError((String)"Invalid argument to 'PropertyGroupValidator.isValid'", (Object[])new Object[0]);
            }
            if (pg.isValid()) {
                return null;
            }
            return "Invalid PropertyGroup: " + pg.getName();
        }
        if (this.propGroup != null) {
            if (this.propGroup.isValid()) {
                return null;
            }
            return "Invalid PropertyGroup: " + this.propGroup.getName();
        }
        return null;
    }

    static {
        DefaultValidator = AlwaysValid = new PropertyGroupValidator();
        ValidatorMap = new HashMap<String, PropertyGroupValidator>();
    }
}

