/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config;

import java.util.Map;
import org.opengts.opt.config.PropertyItem;
import org.opengts.util.MethodAction;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class PropertyGroup {
    private String name = null;
    private String description = null;
    private Map<String, PropertyItem> propertyList = null;

    public static PropertyGroup createPropertyGroup(String pgClassName, String name, String desc, Map<String, PropertyItem> propList) {
        if (!StringTools.isBlank((String)pgClassName)) {
            try {
                Class<?> pgClass = Class.forName(pgClassName);
                MethodAction ma = new MethodAction(pgClass, new Class[]{String.class, String.class, Map.class});
                return (PropertyGroup)ma.invoke(new Object[]{name, desc, propList});
            }
            catch (ClassNotFoundException cnfe) {
                Print.logError((String)("PropertyGroup class not found: " + pgClassName), (Object[])new Object[0]);
            }
            catch (Throwable t) {
                Print.logError((String)("PropertyGroup creation error: " + pgClassName + " [" + t), (Object[])new Object[0]);
            }
        }
        return new PropertyGroup(name, desc, propList);
    }

    public PropertyGroup(String name, String desc, Map<String, PropertyItem> propList) {
        this.name = StringTools.trim((String)name);
        this.description = StringTools.trim((String)desc);
        this.propertyList = propList != null ? propList : new OrderedMap();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, PropertyItem> getPropertyList() {
        return this.propertyList;
    }

    public String getValue(String key) {
        if (StringTools.isBlank((String)key)) {
            return null;
        }
        PropertyItem pi = this.propertyList.get(key);
        if (pi == null) {
            Print.logError((String)("PropertyItem not found: " + key), (Object[])new Object[0]);
            return null;
        }
        String val = pi.getValue();
        return val;
    }

    public boolean hasChanged() {
        for (PropertyItem pi : this.propertyList.values()) {
            if (!pi.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void clearChanged() {
        for (PropertyItem pi : this.propertyList.values()) {
            pi.clearChanged();
        }
    }

    public boolean isValid() {
        return true;
    }
}

