/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VContextMenu;
import org.opengts.opt.ui.VPopupMenuProvider;
import org.opengts.opt.ui.VSplitPane;
import org.opengts.opt.ui.VTree;
import org.opengts.opt.ui.VTreeNode;

public class VTreeViewer
extends VBox {
    private VTree treeView = null;
    private VBox nodeView = null;
    private VSplitPane splitView = null;

    public VTreeViewer(String treeTitle) {
        this(null, treeTitle, -1, false);
    }

    public VTreeViewer(String boxTitle, String treeTitle, boolean bordered) {
        this(boxTitle, treeTitle, -1, bordered);
    }

    public VTreeViewer(String boxTitle, String treeTitle, int preferredTreeWidth, boolean bordered) {
        super(boxTitle, null, bordered);
        this.treeView = this.createVTree(treeTitle);
        this.treeView.addSelectionListener(new VTree.VTreeSelectionListener(){

            @Override
            public void selectionChanged(VTree tree) {
                VTreeNode node = tree.getSelectedNode();
                if (node != null) {
                    Component c = node.getCustomView();
                    VTreeViewer.this.setCustomView(c);
                } else {
                    VTreeViewer.this.setCustomView(null);
                }
            }
        });
        this.setPreferredTreeWidth(preferredTreeWidth);
        this.nodeView = new VBox(null, null, false);
        this.nodeView.setGBCX(0.5, 0, 1);
        this.nodeView.setGBCY(0.5, 0, 1);
        Component dftView = this.createDefaultView();
        if (dftView != null) {
            this.nodeView.add(dftView, this.nodeView.getDefaultGBC());
        }
        this.splitView = new VSplitPane(1, this.treeView, this.nodeView);
        this.splitView.setContinuousLayout(true);
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.5, 0, 1);
        this.add((Component)this.splitView, this.getDefaultGBC());
    }

    public VTree getVTree() {
        return this.treeView;
    }

    public VTreeNode getRootNode() {
        VTree tree = this.getVTree();
        return tree != null ? tree.getRootNode() : null;
    }

    public void addSelectionListener(VTree.VTreeSelectionListener tsl) {
        this.treeView.addSelectionListener(tsl);
    }

    public void removeSelectionListener(VTree.VTreeSelectionListener tsl) {
        this.treeView.removeSelectionListener(tsl);
    }

    public void setTreeTitle(String title) {
        this.getVTree().setTitle(title);
    }

    protected Component createDefaultView() {
        return null;
    }

    public VTree createVTree(String treeTitle) {
        return new VTree(treeTitle, null, false);
    }

    public void setPreferredTreeWidth(int width) {
        if (width > 0) {
            this.treeView.setPreferredWidth(width);
        }
    }

    public void addUserObjects(List usrObjs) {
        this.treeView.addUserObjects(null, usrObjs.toArray(), false);
    }

    public void addUserObjects(Object[] usrObjs) {
        this.treeView.addUserObjects(null, usrObjs, false);
    }

    public VTreeNode addUserObject(Object usrObj) {
        return this.treeView.addUserObject(null, usrObj, false);
    }

    protected void setCustomView(Component comp) {
        JPanel container = this.nodeView.getContainerArea();
        container.removeAll();
        this.nodeView.invalidate();
        this.nodeView.validate();
        if (comp != null) {
            GridBagConstraints gbc = this.nodeView.getDefaultGBC();
            this.nodeView.add(comp, gbc);
            if (comp instanceof VBox) {
                ((VBox)comp).refresh();
            }
        }
        this.nodeView.invalidate();
        this.nodeView.validate();
        this.nodeView.repaint();
    }

    public VContextMenu setContextMenu(JPopupMenu popup) {
        return this.treeView.setContextMenu(popup);
    }

    public VContextMenu setContextMenu(VPopupMenuProvider popupProv) {
        return this.treeView.setContextMenu(popupProv);
    }

    public VContextMenu getContextMenu() {
        return this.treeView.getContextMenu();
    }
}

