/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import org.opengts.opt.ui.VTextField;
import org.opengts.util.StringTools;

public class VTextIPAddress
extends VTextField {
    private static final int IP_SIZE = 4;

    public VTextIPAddress() {
        this(null, null, false);
    }

    public VTextIPAddress(String title, String label, boolean bordered) {
        super(title, label, bordered, "formatted");
        String format = "###" + StringTools.replicateString((String)".###", (int)3);
        super.setFormatMask(format, "0123456789");
        super.setColumns(format.length());
        super.getJTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent fe) {
                VTextIPAddress.this.setText(VTextIPAddress.this.getText());
            }
        });
    }

    @Override
    protected JTextField createTextField(String fieldType) {
        return new VIPAddrTextField();
    }

    protected String formatIPAddress(Object ip, boolean expand) {
        String ipAddr = ip != null ? ip.toString() : "";
        String format = expand ? "000" : "0";
        String[] n = StringTools.parseStringArray((String)ipAddr, (char)'.');
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            int v;
            if (i > 0) {
                sb.append(".");
            }
            int n2 = v = i < n.length ? StringTools.parseInt((String)n[i], (int)0) : 0;
            if (v < 0) {
                v = 0;
            } else if (v > 255) {
                v = 255;
            }
            sb.append(StringTools.format((int)v, (String)format));
        }
        return sb.toString();
    }

    @Override
    public void setText(String ipAddr) {
        super.setText(this.formatIPAddress(ipAddr, true));
    }

    @Override
    public void setValue(Object ipAddr) {
        super.setValue(this.formatIPAddress(ipAddr, true));
    }

    @Override
    public String getText() {
        return this.formatIPAddress(super.getText(), false);
    }

    @Override
    public Object getValue() {
        return this.formatIPAddress(super.getValue(), false);
    }

    protected class VIPAddrTextField
    extends VTextField.VJFormattedTextField {
        @Override
        protected void processKeyEvent(KeyEvent ke) {
            char ch;
            int type = ke.getID();
            if (type == 400 && (ch = ke.getKeyChar()) == '.') {
                int pos;
                String text = this.getText();
                int lastPos = text.lastIndexOf(46, pos = this.getCaretPosition());
                lastPos = lastPos < 0 ? 0 : lastPos + 1;
                int nextPos = text.indexOf(46, pos);
                if (nextPos < 0) {
                    nextPos = text.length();
                }
                if (pos - lastPos > 0) {
                    int len = pos - lastPos;
                    StringBuffer sb = new StringBuffer();
                    sb.append(text.substring(0, lastPos));
                    if (len < 3) {
                        sb.append(StringTools.replicateString((String)"0", (int)(3 - len)));
                    }
                    sb.append(text.substring(lastPos, lastPos + len));
                    sb.append(text.substring(nextPos));
                    this.setText(sb.toString().replace(' ', '0'));
                }
                this.setCaretPosition(nextPos);
            }
            super.processKeyEvent(ke);
        }
    }
}

