/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import org.opengts.opt.ui.VBarMeter;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VCheckBox;
import org.opengts.opt.ui.VComboBox;
import org.opengts.opt.ui.VDialog;
import org.opengts.opt.ui.VFiller;
import org.opengts.opt.ui.VLabelValue;
import org.opengts.opt.ui.VMenu;
import org.opengts.opt.ui.VMenuLayout;
import org.opengts.opt.ui.VOptionPane;
import org.opengts.opt.ui.VPopupMenu;
import org.opengts.opt.ui.VPopupMenuProvider;
import org.opengts.opt.ui.VSeparator;
import org.opengts.opt.ui.VSpinner;
import org.opengts.opt.ui.VTabbedPane;
import org.opengts.opt.ui.VTextArea;
import org.opengts.opt.ui.VTextField;
import org.opengts.opt.ui.VTreeNode;
import org.opengts.opt.ui.VTreeViewer;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class VTest {
    public static VTabbedPane gTabbedPane = null;
    private static VButton gDftBtn = null;
    private static VTreeViewer gTreeViewer = null;

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void test_VButton() {
        VBox box = new VBox();
        GridBagConstraints gbc = box.getDefaultGBC();
        ActionListener buttonAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Print.logStackTrace((String)"Button Action");
            }
        };
        final VButton btn = new VButton("Test");
        btn.setMnemonic(84);
        btn.addActionListener(buttonAction);
        VBox.SetGBCX(gbc, 0.0, 0, 1);
        VBox.SetGBCY(gbc, 0.0, 0, 1);
        box.add((Component)btn, gbc);
        VFiller filler1 = new VFiller();
        VBox.SetGBCX(gbc, 0.5, 1, 1);
        VBox.SetGBCY(gbc, 0.0, 0, 1);
        box.add((Component)filler1, gbc);
        VFiller filler2 = new VFiller();
        VBox.SetGBCX(gbc, 0.5, 0, 2);
        VBox.SetGBCY(gbc, 0.5, 1, 1);
        box.add((Component)filler2, gbc);
        btn.setDeBounceTime(1500);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                Print.logInfo((String)("Action Command: " + cmd), (Object[])new Object[0]);
                btn.setLedColor(Color.green.darker());
            }
        });
        btn.setActionCommand("Default");
        btn.setActionCommand("Caps Shift", 1);
        btn.setActionCommand("Alt Shift", 8);
        btn.setActionCommand("Caps/Alt Shift", 9);
        btn.setActionCommand("Alt Shift", 8);
        btn.setActionCommand("Ctrl Shift", 2);
        btn.setActionCommand("Ctrl/Alt Shift", 10);
        btn.setActionCommand("Meta Shift", 4);
        VDialog.showTestComponent(box);
        VTest.sleep(10000L);
    }

    private static void test_VCheckBox() {
        VCheckBox cb = new VCheckBox("Test", "Label", true);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Print.logInfo((String)"Action!", (Object[])new Object[0]);
            }
        });
        VDialog.showTestComponent(cb);
    }

    private static void test_VTextArea() {
        VTextArea ta = new VTextArea("Test", null, true);
        VDialog.showTestComponent(ta);
    }

    private static void _addFieldsToVLabelValue(String prefix, VLabelValue lv) {
        VTextField tf1 = new VTextField(null, null, false);
        lv.addRow(prefix + "] 1 Test Row:", tf1);
        VTextField tf2 = new VTextField(null, null, false);
        tf2.setColumns(10);
        lv.addRow(prefix + "] 2 Another Test Row:", tf2);
        VComboBox tf3 = new VComboBox(null, null, false);
        lv.addRow(prefix + "] 3 ComboBox Row:", tf3);
        VTextArea ta = new VTextArea(null, null, false);
        ta.setRows(7);
        lv.addRow(prefix + "] 4 Text Area:", ta);
        lv.invalidate();
        lv.validate();
        lv.repaint();
    }

    private static void test_VLabelValue() {
        VDialog dialog = new VDialog((Frame)null, "Label Value Test", true);
        VLabelValue lv = new VLabelValue(null, null, true);
        VBox content = dialog.getContentBox();
        content.add((Component)lv, content.getDefaultGBC());
        VTest._addFieldsToVLabelValue("A", lv);
        dialog.centerOnScreen(400, -1);
        dialog.show();
        VTest._addFieldsToVLabelValue("B", lv);
        dialog.centerOnScreen(400, -1);
        dialog.show();
        System.exit(0);
    }

    private static void test_VOptionPane() {
        Print.logInfo((String)("Return = " + VOptionPane.showTextAreaInputDialog(null, "TextArea input")), (Object[])new Object[0]);
    }

    private static void test_VSpinner() {
        final VSpinner x = new VSpinner(new String[]{"Apples", "Oranges", "Grapefruit"});
        x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Object val = x.getValue();
                Print.logInfo((String)("Selected type: " + StringTools.className((Object)val)), (Object[])new Object[0]);
            }
        });
        VDialog.showTestComponent(x);
    }

    private static void test_VTabbedPane(int tabPlacement, int tabLayout) {
        VDialog dialog = new VDialog((Frame)null, "Tabbed Pane Test", true);
        dialog.setExitOnClose();
        VBox content = dialog.getContentBox();
        content.setGBCX(0.5, 0, 1);
        content.setGBCY(0.5, 0, 1);
        gTabbedPane = new VTabbedPane(null, null, false, tabPlacement, tabLayout);
        content.add((Component)gTabbedPane, content.getDefaultGBC());
        VPopupMenuProvider popupProvider = new VPopupMenuProvider(){

            @Override
            public JPopupMenu getPopupMenu() {
                final int ndx = gTabbedPane.getSelectedIndex();
                if (ndx >= 0) {
                    VPopupMenu popup = new VPopupMenu("PopUp");
                    popup.add(new AbstractAction("Test 1"){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            Print.logInfo((String)("Selected Test1 : " + ndx), (Object[])new Object[0]);
                        }
                    });
                    popup.add(new AbstractAction("Test 2"){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            Print.logInfo((String)("Selected Test2 : " + ndx), (Object[])new Object[0]);
                        }
                    });
                    return popup;
                }
                return null;
            }
        };
        gTabbedPane.setContextMenu(popupProvider);
        gTabbedPane.addTab("How", new VButton("How"));
        gTabbedPane.addTab("Now", new VButton("Now"));
        gTabbedPane.addTab("Brown", new VButton("Brown"));
        gTabbedPane.addTab("Cow", new VButton("Cow"));
        dialog.centerOnScreen(400, 300);
        dialog.show();
    }

    private static void test_VTreeViewer() {
        VDialog dialog = new VDialog((Frame)null, "Tree Viewer", true);
        dialog.centerOnScreen(800, 400);
        dialog.setExitOnClose();
        VPopupMenuProvider popupProvider = new VPopupMenuProvider(){

            @Override
            public JPopupMenu getPopupMenu() {
                JPopupMenu popup = new JPopupMenu("PopUp");
                popup.add(new AbstractAction("Test"){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        VTreeNode node = gTreeViewer.getVTree().getSelectedNode();
                        if (node != null) {
                            gTreeViewer.getVTree().setUserObjects(node, new String[]{"Now", "is", "the", "time", "for", "all", "good", "men"}, false);
                        }
                    }
                });
                return popup;
            }
        };
        gTreeViewer = new VTreeViewer("Prototype Tree", "Tree", true);
        gTreeViewer.setContextMenu(popupProvider);
        gTreeViewer.setPreferredTreeWidth(150);
        VBox container = dialog.getContentBox();
        GridBagConstraints gbc = container.getDefaultGBC();
        container.setGBCX(0.5, 0, 1);
        container.setGBCY(0.5, 0, 1);
        container.add((Component)gTreeViewer, container.getDefaultGBC());
        gTreeViewer.getVTree().addUserObjects(null, new String[]{"how", "now", "brown", "cow"}, false);
        dialog.setVisible(true);
    }

    private static void test_VComboBox() {
        Object[] model = new Object[]{"One", new VSeparator(), "Two", "Three"};
        VComboBox cb = new VComboBox(null, "Test:", true){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
                this.addItem(new VSeparator());
                this.addItem("Orange");
            }
        };
        cb.setModel(model);
        VDialog.showTestComponent(cb);
    }

    private static void test_VBarMeter() {
        VBox box = new VBox();
        GridBagConstraints gbc = box.getDefaultGBC();
        VBarMeter gr1 = new VBarMeter();
        gr1.setTitle("Digital Audio Imp. Level %");
        gr1.setLabels(new String[]{"0", "25", "50", "75", "100", "125", "150"});
        gr1.setScale(0.0, 150.0);
        gr1.setColorRange(0.0, 95.0, 105.0);
        gr1.setMeterValue(99.0);
        VBox.SetGBCX(gbc, 0.0, 0, 1);
        VBox.SetGBCY(gbc, 0.5, 0, 1);
        box.add((Component)gr1, gbc);
        VBarMeter gr2 = new VBarMeter();
        gr2.setMeterWidth(15);
        gr2.setScale(0.0, 150.0);
        gr2.setScaledColorRange(0.87, 0.35, 0.0);
        gr2.setTickPosition(2);
        gr2.setMeterValue(77.0);
        VBox.SetGBCX(gbc, 0.0, 1, 1, 0, 0);
        VBox.SetGBCY(gbc, 0.5, 0, 1);
        box.add((Component)gr2, gbc);
        VDialog.showTestComponent(box);
        VTest.sleep(15000L);
    }

    private static void test_VMenu() {
        VBox box = new VBox();
        GridBagConstraints gbc = box.getDefaultGBC();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Print.logInfo((String)"Hello World", (Object[])new Object[0]);
            }
        };
        VMenu mainMenu = new VMenu("Hello World");
        VMenu subMenu_1 = new VMenu("Sub Menu 1");
        subMenu_1.setMaxRows(25, 4);
        mainMenu.add(subMenu_1);
        for (int i = 1; i <= 20; ++i) {
            subMenu_1.add("SubItem_" + i, al);
        }
        VMenu subMenu_2 = new VMenu("Sub Menu 2");
        subMenu_2.setMaxRows(25, 4);
        mainMenu.add(subMenu_2);
        for (int i = 1; i <= 25; ++i) {
            subMenu_2.add("SubItem_" + i, al);
        }
        VMenu subMenu_3 = new VMenu("Sub Menu 3");
        subMenu_3.setMaxRows(25, 4);
        mainMenu.add(subMenu_3);
        for (int i = 1; i <= 26; ++i) {
            subMenu_3.add("SubItem_" + i, al);
        }
        VMenu subMenu_4 = new VMenu("Sub Menu 4");
        subMenu_4.setMaxRows(25, 4);
        mainMenu.add(subMenu_4);
        VMenu subMenu_4_1 = new VMenu("Sub Menu 4.1");
        subMenu_4_1.add("SubItem_4.1", al);
        subMenu_4.add(subMenu_4_1);
        for (int i = 0; i < 500; ++i) {
            subMenu_4.add("SubItem_" + (i + 1), al);
        }
        JMenu flowMenu = new JMenu("Flow Menu");
        mainMenu.add(flowMenu);
        JPopupMenu p = flowMenu.getPopupMenu();
        p.setBackground(Color.gray);
        p.setLayout(new VMenuLayout(30));
        p.setFocusable(true);
        p.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Print.logInfo((String)"Key pressed", (Object[])new Object[0]);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                Print.logInfo((String)"Key released", (Object[])new Object[0]);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                Print.logInfo((String)"Key typed", (Object[])new Object[0]);
            }
        });
        for (int i = 0; i < 100; ++i) {
            flowMenu.add(new JMenuItem("FlowItem_" + i));
        }
        VDialog.showTestComponent(box, mainMenu);
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        if (RTConfig.getBoolean((String)"VBarMeter")) {
            VTest.test_VBarMeter();
        } else if (RTConfig.getBoolean((String)"VButton")) {
            VTest.test_VButton();
        } else if (RTConfig.getBoolean((String)"VCheckBox")) {
            VTest.test_VCheckBox();
        } else if (RTConfig.getBoolean((String)"VTextArea")) {
            VTest.test_VTextArea();
        } else if (RTConfig.getBoolean((String)"VLabelValue")) {
            VTest.test_VLabelValue();
        } else if (RTConfig.getBoolean((String)"VOptionPane")) {
            VTest.test_VOptionPane();
        } else if (RTConfig.getBoolean((String)"VSpinner")) {
            VTest.test_VSpinner();
        } else if (RTConfig.getBoolean((String)"VTabbedPane")) {
            VTest.test_VTabbedPane(1, 1);
        } else if (RTConfig.getBoolean((String)"VTreeViewer")) {
            VTest.test_VTreeViewer();
        } else if (RTConfig.getBoolean((String)"VComboBox")) {
            VTest.test_VComboBox();
        } else if (RTConfig.getBoolean((String)"VMenu")) {
            VTest.test_VMenu();
        } else if (RTConfig.getBoolean((String)"JColorChooser")) {
            JColorChooser.showDialog(null, "Color Chooser", Color.white);
        } else {
            Print.logError((String)"Unrecognized option", (Object[])new Object[0]);
        }
        System.exit(0);
    }
}

