/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VContextMenu;
import org.opengts.opt.ui.VPopupMenuProvider;
import org.opengts.util.StringTools;

public class VTabbedPane
extends VBox {
    public static final int TOP = 1;
    public static final int BOTTOM = 3;
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    public static final int WRAP_TAB_LAYOUT = 0;
    public static final int SCROLL_TAB_LAYOUT = 1;
    private VJTabbedPane tabbedView = null;
    private HashMap<String, Component> tabMap = new HashMap();
    private Comparator<Component> insertComparator = null;
    private String actionCmd = null;
    private Vector<ActionListener> actionListeners = null;

    public VTabbedPane() {
        this(1);
    }

    public VTabbedPane(int tabPlacement) {
        this(null, null, false, tabPlacement, 0);
    }

    public VTabbedPane(int tabPlacement, int tabLayout) {
        this(null, null, false, tabPlacement, tabLayout);
    }

    public VTabbedPane(String title, String label, boolean bordered) {
        this(title, label, bordered, 1, 0);
    }

    public VTabbedPane(String title, String label, boolean bordered, int tabPlacement) {
        this(title, label, bordered, tabPlacement, 0);
    }

    public VTabbedPane(String title, String label, boolean bordered, int tabPlacement, int tabLayout) {
        this(title, label, bordered, tabPlacement, 0, false);
    }

    public VTabbedPane(String title, String label, boolean bordered, int tabPlacement, int tabLayout, boolean scroll) {
        super(title, label, bordered);
        this.tabbedView = new VJTabbedPane(tabPlacement, tabLayout);
        this.tabbedView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VTabbedPane.this.fireActionEvent(null);
            }
        });
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.5, 0, 1);
        if (scroll) {
            this.add((Component)new JScrollPane(this.tabbedView), this.getDefaultGBC());
        } else {
            this.add((Component)this.tabbedView, this.getDefaultGBC());
        }
    }

    public VJTabbedPane getJTabbedPane() {
        return this.tabbedView;
    }

    public void setKeyTitle(String key, String title) {
        this.setComponentTitle(this.tabMap.get(key), title);
    }

    public void setComponentTitle(Component comp, String title) {
        int ndx = this.indexOf(comp);
        if (ndx >= 0) {
            this.setTitleAt(ndx, title != null ? title : "");
        }
    }

    public void setTitleAt(int ndx, String title) {
        this.getJTabbedPane().setTitleAt(ndx, title);
    }

    public void setInsertionComparator(Comparator<Component> comp) {
        this.insertComparator = comp;
    }

    public int getTabCount() {
        return this.getJTabbedPane().getTabCount();
    }

    public Component getComponentAt(int ndx) {
        return this.getJTabbedPane().getComponentAt(ndx);
    }

    public int getSelectedIndex() {
        return this.getJTabbedPane().getSelectedIndex();
    }

    public Component getSelectedComponent() {
        return this.getJTabbedPane().getSelectedComponent();
    }

    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        if (this.insertComparator != null) {
            index = this.getTabCount();
            for (int i = 0; i < index; ++i) {
                Component c = this.getComponentAt(i);
                if (this.insertComparator.compare(component, c) >= 0) continue;
                index = i;
                break;
            }
        }
        this.getJTabbedPane().insertTab(title, icon, component, tip, index);
        if (title != null) {
            this.tabMap.put(title, component);
        }
    }

    public void addTab(String title, Component component) {
        this.getJTabbedPane().addTab(title, component);
    }

    public void removeTabAt(int ndx) {
        this.getJTabbedPane().removeTabAt(ndx);
    }

    public void setSelectedIndex(int ndx) {
        this.getJTabbedPane().setSelectedIndex(ndx);
    }

    public int indexOf(Component comp) {
        if (comp != null) {
            int len = this.getTabCount();
            for (int i = 0; i < len; ++i) {
                Component c = this.getJTabbedPane().getComponentAt(i);
                if (c instanceof JScrollPane) {
                    c = ((JScrollPane)c).getViewport().getView();
                }
                if (!c.equals(comp)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void setActionCommand(String cmd) {
        this.actionCmd = cmd;
    }

    @Override
    public String getActionCommand() {
        return this.actionCmd;
    }

    @Override
    protected List<ActionListener> getActionListeners() {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        return this.actionListeners;
    }

    @Override
    public void addActionListener(ActionListener al) {
        if (al != null) {
            this.getActionListeners().add(al);
        }
    }

    @Override
    public void removeActionListener(ActionListener al) {
        if (al != null) {
            this.getActionListeners().remove(al);
        }
    }

    @Override
    protected void fireActionEvent(ActionEvent ae) {
        Component comp;
        List<ActionListener> listeners = this.getActionListeners();
        if (!listeners.isEmpty()) {
            if (ae == null) {
                ae = this.createActionEvent(this, null);
            }
            for (ActionListener al : listeners) {
                al.actionPerformed(ae);
            }
        }
        if ((comp = this.getSelectedComponent()) instanceof VBox) {
            ((VBox)comp).refresh();
        }
    }

    protected ActionEvent createActionEvent(Object src, String cmd) {
        Object s = src != null ? src : this;
        String c = cmd != null ? cmd : this.getActionCommand();
        return new ActionEvent(src, 1001, c);
    }

    @Override
    public void selectItemAt(Point p) {
        VJTabbedPane jv = this.getJTabbedPane();
        Point jp = SwingUtilities.convertPoint(this, p, jv);
        int ndx = jv.indexAtLocation(jp.x, jp.y);
        jv.setSelectedIndex(ndx);
    }

    public VContextMenu setContextMenu(JPopupMenu popup) {
        return VContextMenu.setContextMenu((JComponent)this.getJTabbedPane(), popup);
    }

    public VContextMenu setContextMenu(final VPopupMenuProvider popupProv) {
        VPopupMenuProvider tabbedPanePopupProv = new VPopupMenuProvider(){

            @Override
            public JPopupMenu getPopupMenu() {
                JPopupMenu pm;
                Component c = VTabbedPane.this.getSelectedComponent();
                if (c instanceof VPopupMenuProvider && (pm = ((VPopupMenuProvider)((Object)c)).getPopupMenu()) != null) {
                    return pm;
                }
                return popupProv != null ? popupProv.getPopupMenu() : null;
            }
        };
        return VContextMenu.setContextMenu((JComponent)this.getJTabbedPane(), tabbedPanePopupProv);
    }

    public VContextMenu getContextMenu() {
        return VContextMenu.getContextMenu(this.getJTabbedPane());
    }

    public static class VJTabbedPane
    extends JTabbedPane {
        public VJTabbedPane(int tabPlacement, int tabLayout) {
            super(tabPlacement, tabLayout);
        }

        public VJTabbedPane(int tabPlacement) {
            super(tabPlacement, 0);
        }

        @Override
        public void insertTab(String title, Icon icon, Component component, String tip, int index) {
            if (title.indexOf("\n") >= 0) {
                title = "<html><center>" + StringTools.htmlFilterText((Object)title) + "</center></html>";
            }
            super.insertTab(title, icon, component, tip, index);
        }
    }
}

