/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VFrame;
import org.opengts.opt.ui.VSplitPane;
import org.opengts.opt.ui.VTextArea;
import org.opengts.opt.ui.VTextField;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class VShell
extends VBox {
    private static final boolean SHELL_EXEC = true;
    private VTextArea stdoutTA = null;
    private VTextArea stdout = null;
    private VTextArea stderrTA = null;
    private VTextArea stderr = null;
    private VSplitPane splitView = null;
    private VTextField stdin = null;
    private Process process = null;
    private boolean processComplete = true;
    private int lastExitStatus = -1;

    public VShell() {
        this(null, null, false, true, false);
    }

    public VShell(String title, String label, boolean bordered) {
        this(title, label, bordered, true, false);
    }

    public VShell(String title, String label, boolean bordered, boolean combineStdoutStderr, boolean showStdin) {
        super(title, label, bordered);
        String stdoutTitle = !combineStdoutStderr ? "stdout" : null;
        this.stdoutTA = new VTextArea(stdoutTitle, null, !StringTools.isBlank((String)stdoutTitle));
        this.stdoutTA.setTextFont(FONT_MONOSPACED_PLAIN);
        this.stdoutTA.setReadOnly(true);
        this.stdoutTA.setLineWrap(true);
        this.stdout = this.stdoutTA;
        if (!combineStdoutStderr) {
            String stderrTitle;
            this.stderrTA = new VTextArea(stderrTitle, null, !StringTools.isBlank((String)(stderrTitle = "stderr")));
            this.stderrTA.setTextFont(FONT_MONOSPACED_PLAIN);
            this.stderrTA.setReadOnly(true);
            this.stderrTA.setLineWrap(true);
            this.stderr = this.stderrTA;
        } else {
            this.stderrTA = null;
            this.stderr = this.stdoutTA;
        }
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.5, 0, 1);
        if (this.stderrTA != null) {
            this.splitView = new VSplitPane(0, this.stdoutTA, this.stderrTA);
            this.splitView.setContinuousLayout(true);
            this.splitView.setResizeWeight(1.0);
            this.add((Component)this.splitView, this.getDefaultGBC());
        } else {
            this.add((Component)this.stdoutTA, this.getDefaultGBC());
        }
        if (showStdin) {
            String stdinTitle = "exec";
            this.stdin = new VTextField("stdin", null, true);
            this.setGBCX(0.5, 0, 1);
            this.setGBCY(0.0, 1, 1);
            this.add((Component)this.stdin, this.getDefaultGBC());
            this.stdin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String s = VShell.this.stdin.getText();
                    VShell.this.exec(s);
                    VShell.this.stdin.setText("");
                }
            });
        }
    }

    public void combineOutput(boolean combine) {
        if (combine) {
            this.stderr = this.stdoutTA;
            if (this.stderrTA != null) {
                this.stderrTA.setVisible(false);
                this.stdoutTA.setTitle("stdout/stderr");
            }
        } else if (this.stderrTA != null) {
            this.stderr = this.stderrTA;
            this.stderrTA.setVisible(true);
            this.stdoutTA.setTitle("stdout");
        } else {
            Print.logError((String)"Stdout already ommitted from this view", (Object[])new Object[0]);
        }
    }

    public void setStdinHidden(boolean hide) {
        if (this.stdin != null) {
            this.stdin.setVisible(!hide);
        } else if (!hide) {
            Print.logWarn((String)"Stdin field not defined", (Object[])new Object[0]);
        }
    }

    public void setLineWrap(boolean wrap) {
        if (this.stdoutTA != null) {
            this.stdoutTA.setLineWrap(wrap);
        }
        if (this.stderrTA != null) {
            this.stdoutTA.setLineWrap(wrap);
        }
    }

    public VTextArea getStdoutTextArea() {
        return this.stdoutTA;
    }

    public VTextArea getStderrTextArea() {
        return this.stderrTA;
    }

    public int execCommand(String cmdStr) throws InterruptedException {
        Process proc = this._exec(cmdStr);
        if (proc != null) {
            proc.waitFor();
            return proc.exitValue();
        }
        return -1;
    }

    public int execCommand(String[] cmdArray) throws InterruptedException {
        Process proc = this._exec(cmdArray);
        if (proc != null) {
            proc.waitFor();
            return proc.exitValue();
        }
        return -1;
    }

    public Process exec(String cmdStr) {
        return this._exec(cmdStr);
    }

    public Process exec(String[] cmdArray) {
        return this._exec(cmdArray);
    }

    private Process _exec(Object cmd) {
        this.lastExitStatus = -1;
        this.processComplete = false;
        Object[] a = null;
        String s = null;
        if (cmd == null) {
            return null;
        }
        if (cmd instanceof String) {
            s = (String)cmd;
            if (StringTools.isBlank((String)s)) {
                return null;
            }
        } else if (cmd instanceof String[]) {
            a = (String[])cmd;
            if (ListTools.isEmpty((Object[])a) || StringTools.isBlank((String)a[0])) {
                return null;
            }
        } else {
            return null;
        }
        try {
            this.process = s != null ? Runtime.getRuntime().exec(s) : Runtime.getRuntime().exec((String[])a);
            this._outputReader("stdout", this.process.getInputStream(), this.stdout);
            this._outputReader("stderr", this.process.getErrorStream(), this.stderr);
            return this.process;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (IllegalArgumentException iae) {
            Print.logError((String)("Invalid command: " + iae), (Object[])new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _execFinished(OutputReader r) {
        VShell vShell = this;
        synchronized (vShell) {
            if (!this.processComplete) {
                this.processComplete = true;
                this.lastExitStatus = r.getExitStatus();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VShell.this.execFinished(VShell.this.lastExitStatus);
                    }
                });
            }
        }
    }

    protected void execFinished(int exitStatus) {
        Print.logDebug((String)"Process finished [%d]", (Object[])new Object[]{exitStatus});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExecFinished() {
        boolean finished = true;
        VShell vShell = this;
        synchronized (vShell) {
            finished = this.processComplete;
        }
        return finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExitStatus() {
        int exitStatus = -1;
        VShell vShell = this;
        synchronized (vShell) {
            exitStatus = this.lastExitStatus;
        }
        return exitStatus;
    }

    private void _outputReader(String title, InputStream input, VTextArea textArea) {
        final OutputReader r = new OutputReader(title, input, textArea);
        new Thread(new Runnable(){

            @Override
            public void run() {
                VShell.this._outputReaderThread(r);
                VShell.this._execFinished(r);
            }
        }).start();
    }

    private void _outputReaderThread(OutputReader outReader) {
        int exitStatus = -1;
        boolean isDone = false;
        char[] ch = new char[1000];
        while (true) {
            boolean didRead = false;
            try {
                int len = outReader.getReader().read(ch, 0, ch.length);
                if (len > 0) {
                    didRead = true;
                    outReader.appendTextToBuffer(new String(ch, 0, len));
                }
            }
            catch (IOException ioe) {
                Print.logError((String)("'" + outReader.getTitle() + "' read error"), (Object[])new Object[0]);
            }
            if (didRead) continue;
            if (isDone) break;
            try {
                exitStatus = this.process.exitValue();
                isDone = true;
            }
            catch (IllegalThreadStateException itse) {
                // empty catch block
            }
            try {
                Thread.sleep(100L);
            }
            catch (Throwable t) {}
        }
        outReader.setExitStatus(exitStatus);
    }

    public static void main(String[] argv) {
        StringBuffer cmd = new StringBuffer();
        for (int i = 0; i < argv.length; ++i) {
            if (cmd.length() > 0) {
                cmd.append(" ");
            }
            cmd.append(argv[i]);
        }
        VShell shell = new VShell(null, null, false, true, true);
        shell.combineOutput(true);
        shell.setStdinHidden(false);
        Print.logInfo((String)"Showing window ...", (Object[])new Object[0]);
        VFrame.showTestComponent(shell, 800, 400);
        shell.exec(cmd.toString());
    }

    private class OutputReader {
        private String title = null;
        private Reader reader = null;
        private VTextArea textArea = null;
        private StringBuffer buffer = null;
        private boolean pendingOutput = false;
        private int exitStatus = -1;

        public OutputReader(String title, InputStream input, VTextArea text) {
            this.title = title;
            this.reader = new BufferedReader(new InputStreamReader(input));
            this.textArea = text;
            this.buffer = new StringBuffer();
            this.exitStatus = -1;
        }

        public String getTitle() {
            return this.title;
        }

        public Reader getReader() {
            return this.reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendTextToBuffer(String text) {
            OutputReader outputReader = this;
            synchronized (outputReader) {
                StringBuffer sb = this.buffer;
                if (!this.pendingOutput) {
                    this.pendingOutput = true;
                    sb.append(text);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OutputReader.this.appendBufferToTextArea();
                        }
                    });
                } else {
                    sb.append(text);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void appendBufferToTextArea() {
            OutputReader outputReader = this;
            synchronized (outputReader) {
                StringBuffer sb = this.buffer;
                if (sb.length() > 0) {
                    int x = sb.lastIndexOf("\n");
                    if (x >= 0) {
                        String s = sb.substring(0, x + 1);
                        this.textArea.appendText(s, true);
                        sb.delete(0, x + 1);
                    } else if (sb.length() > 256) {
                        String s = sb.toString();
                        this.textArea.appendText(s, true);
                        sb.setLength(0);
                    }
                }
                this.pendingOutput = false;
            }
        }

        public void setExitStatus(int exitStatus) {
            this.exitStatus = exitStatus;
        }

        public int getExitStatus() {
            return this.exitStatus;
        }
    }
}

