/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JSeparator;

public class VSeparator
extends JSeparator {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private Dimension margin = null;
    private Dimension prefSize = null;

    public VSeparator() {
        this(0);
    }

    public VSeparator(int orientation) {
        this(orientation, 0);
    }

    public VSeparator(int orientation, int margin) {
        super(orientation);
        if (orientation == 1) {
            this.setMargin(margin, 0);
        } else {
            this.setMargin(0, margin);
        }
    }

    public void setMargin(int xMargin, int yMargin) {
        this.margin = new Dimension(xMargin >= 0 ? xMargin : 0, yMargin >= 0 ? yMargin : 0);
    }

    public Dimension getMargin() {
        if (this.margin == null) {
            this.margin = new Dimension(0, 0);
        }
        return this.margin;
    }

    public boolean hasMargin() {
        if (this.margin == null) {
            return false;
        }
        return this.margin.width > 0 || this.margin.height > 0;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            Dimension d = super.getPreferredSize();
            int dW = d.width;
            int dH = d.height;
            if (this.getOrientation() == 1) {
                if (dW > 2) {
                    dW = 2;
                }
            } else if (dH > 2) {
                dH = 2;
            }
            Dimension m = this.getMargin();
            int W = dW > 0 ? dW + m.width : 0;
            int H = dH > 0 ? dH + m.height : 0;
            this.prefSize = new Dimension(W, H);
        }
        return this.prefSize;
    }

    @Override
    public void paint(Graphics g) {
        Dimension s = this.getSize();
        if (this.getOrientation() == 1) {
            int X = (s.width - 2) / 2;
            g.setColor(this.getForeground());
            g.drawLine(X, 0, X, s.height);
            g.setColor(this.getBackground());
            g.drawLine(X + 1, 0, X + 1, s.height);
        } else {
            int Y = (s.height - 2) / 2;
            g.setColor(this.getForeground());
            g.drawLine(0, Y, s.width, Y);
            g.setColor(this.getBackground());
            g.drawLine(0, Y + 1, s.width, Y + 1);
        }
    }
}

