/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.opengts.opt.ui.VMenu;
import org.opengts.util.Print;

public class VScrollMenu
extends VMenu {
    private JPopupMenu scrollPopup = null;

    public VScrollMenu(String title, int mnemonic) {
        super(title, mnemonic);
        this.setMaxItemsPerMenu(-1);
        this.initPopupMenu();
    }

    public VScrollMenu(String title) {
        this(title, 0);
    }

    public VScrollMenu() {
        this("", 0);
    }

    protected void initPopupMenu() {
        if (this.scrollPopup == null) {
            this.scrollPopup = new VScrollListPopup();
            this.scrollPopup.setInvoker(this);
        }
    }

    @Override
    protected Component _addItemToThisMenu(Component c) {
        if (c instanceof JMenuItem) {
            this.scrollPopup.add((JMenuItem)c);
        } else {
            this.scrollPopup.add(c);
        }
        return c;
    }

    @Override
    protected JMenu.WinListener createWinListener(JPopupMenu p) {
        Print.logInfo((String)"JMenu/JPopupMenu created ...", (Object[])new Object[0]);
        this.initPopupMenu();
        try {
            Field popupMenu = JMenu.class.getDeclaredField("popupMenu");
            popupMenu.setAccessible(true);
            popupMenu.set(this, this.scrollPopup);
            p = this.scrollPopup;
        }
        catch (Throwable th) {
            Print.logException((String)"JMenu.popupMenu access", (Throwable)th);
        }
        return super.createWinListener(p);
    }

    protected class VScrollComboPopup
    extends BasicComboPopup {
        public VScrollComboPopup(JComboBox cb) {
            super(cb);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (d.height > 300) {
                d.height = 300;
            }
            return d;
        }
    }

    protected class VScrollComboBoxUI
    extends BasicComboBoxUI {
        private VScrollComboPopup comboPopup = null;

        public VScrollComboPopup getPopupMenu() {
            return this.comboPopup;
        }

        @Override
        protected ComboPopup createPopup() {
            this.comboPopup = new VScrollComboPopup(this.comboBox);
            return this.comboPopup;
        }
    }

    protected class VScrollComboBox
    extends JComboBox {
        @Override
        public void updateUI() {
            this.setUI(new VScrollComboBoxUI());
        }

        public VScrollComboPopup getPopupMenu() {
            return ((VScrollComboBoxUI)this.getUI()).getPopupMenu();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (d.height > 300) {
                d.height = 300;
            }
            return d;
        }
    }

    protected class VScrollList
    extends JList {
        private List<Component> listData;

        public VScrollList() {
            this(new Vector<Component>());
        }

        public VScrollList(final List<Component> listData) {
            super(new AbstractListModel(){

                @Override
                public int getSize() {
                    return listData.size();
                }

                @Override
                public Object getElementAt(int i) {
                    return listData.get(i);
                }
            });
            this.listData = null;
            this.listData = listData;
            this.setBorder(null);
            this.setFocusable(false);
            this.setSelectionMode(0);
        }

        public List<Component> getList() {
            return this.listData;
        }

        @Override
        public void processMouseEvent(MouseEvent e) {
            if (e.isControlDown()) {
                e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers() ^ 2, e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
            }
            super.processMouseEvent(e);
        }
    }

    protected class VScrollListPopup
    extends JPopupMenu {
        private VScrollList list = null;
        private JScrollPane scroller = null;
        private MouseListener listMouseListener;
        private MouseMotionListener listMouseMotionListener;
        private ListSelectionListener listSelectionListener;

        public VScrollListPopup() {
            this.setName("VScrollListPopup");
            this.setLightWeightPopupEnabled(true);
            this.list = new VScrollList();
            this.scroller = new JScrollPane(this.list, 20, 31);
            this.scroller.setHorizontalScrollBar(null);
            this.scroller.setFocusable(false);
            this.scroller.getVerticalScrollBar().setFocusable(false);
            this.scroller.setBorder(null);
            this.setLayout(new BoxLayout(this, 1));
            this.setBorderPainted(true);
            this.setBorder(new LineBorder(Color.BLACK, 1));
            this.setOpaque(false);
            this.add(this.scroller);
            this.setDoubleBuffered(true);
            this.setFocusable(false);
        }

        @Override
        public JMenuItem add(JMenuItem menuItem) {
            this.list.getList().add(menuItem);
            return menuItem;
        }

        @Override
        public Component add(Component c) {
            this.list.getList().add(c);
            return c;
        }
    }
}

