/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VMenuItem;
import org.opengts.opt.ui.VMenuLayout;
import org.opengts.opt.ui.VPopupMenuProvider;
import org.opengts.util.ColorTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class VMenu
extends JMenu {
    public static final int MAX_ITEMS_PER_MENU = 32;
    public static int GlobalMaxItems = -1;
    public static int GlobalMaxRows = -1;
    private int screenHeight = 0;
    private int menuHeight = 0;
    private int itemCount = 0;
    private VMenu overflowMenu = null;
    private boolean isOverflowMenu = false;
    private int maxItems = -1;
    private int maxRows = -1;
    private LayoutManager oldLayout = null;
    private VPopupMenuProvider popupMenuProvider = null;

    public void setGlobalMaxItemsPerMenu(int maxItems) {
        GlobalMaxItems = maxItems > 0 ? maxItems : -1;
    }

    public void setGlobalMaxRows(int maxRows) {
        GlobalMaxRows = maxRows > 0 ? maxRows : -1;
    }

    public VMenu(String title, int mnemonic) {
        super(title);
        this.setMnemonic(mnemonic);
        this.screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.screenHeight -= 70;
        this.setMaxItemsPerMenu(GlobalMaxItems);
        this.setMaxRows(GlobalMaxRows);
    }

    public VMenu() {
        this("", 0);
    }

    public VMenu(String title) {
        this(title, 0);
    }

    public VMenu(String title, ActionListener al) {
        this(title, al, 0);
    }

    public VMenu(String title, ActionListener al, int mnemonic) {
        this(title, mnemonic);
        this.addActionListener(al);
    }

    private void _setOverflowMenu() {
        this.isOverflowMenu = true;
    }

    private boolean _isOverflowMenu() {
        return this.isOverflowMenu;
    }

    public void setTitle(String title) {
        super.setText(title);
    }

    public void setPopupMenuProvider(VPopupMenuProvider mp) {
        this.popupMenuProvider = mp;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return super.getPopupMenu();
    }

    public void setPopupMenu(JPopupMenu pum) {
        try {
            Field popupMenu = JMenu.class.getDeclaredField("popupMenu");
            popupMenu.setAccessible(true);
            popupMenu.set(this, pum);
            pum.setInvoker(this);
            Field popupListener = JMenu.class.getDeclaredField("popupListener");
            popupListener.setAccessible(true);
            popupListener.set(this, super.createWinListener(pum));
        }
        catch (Throwable th) {
            Print.logException((String)"Unable to set popupMenu", (Throwable)th);
        }
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        if (isIncluded && this.popupMenuProvider != null) {
            JPopupMenu pum = this.popupMenuProvider.getPopupMenu();
            this.setPopupMenu(pum);
        }
        super.menuSelectionChanged(isIncluded);
    }

    @Override
    protected void fireMenuKeyPressed(MenuKeyEvent event) {
        super.fireMenuKeyPressed(event);
    }

    @Override
    public void setPopupMenuVisible(boolean show) {
        super.setPopupMenuVisible(show);
    }

    public JMenu addMenu(JMenu menu) {
        return (JMenu)this.add(menu);
    }

    @Override
    public JMenuItem add(JMenuItem item) {
        return item != null ? (JMenuItem)this._addItem(item) : null;
    }

    public JSeparator add(JSeparator sep) {
        return sep != null ? (JSeparator)this._addItem(sep) : null;
    }

    public void add(JComponent[] item) {
        for (int i = 0; i < item.length; ++i) {
            JComponent jmi = item[i];
            if (jmi == null) continue;
            if (jmi instanceof JMenuItem) {
                this.add((JMenuItem)jmi);
                continue;
            }
            if (jmi instanceof JSeparator) {
                this.add((JSeparator)item[i]);
                continue;
            }
            Print.logError((String)("Unsupported menu item type: " + StringTools.className((Object)item[i])), (Object[])new Object[0]);
        }
    }

    @Override
    public JMenuItem add(String title) {
        return this.add(new VMenuItem(title));
    }

    public JMenuItem add(String title, ActionListener al) {
        return this.add(new VMenuItem(title, al));
    }

    public JMenuItem add(String title, ActionListener al, String cmd) {
        return this.add(new VMenuItem(title, al, cmd));
    }

    @Override
    public JMenuItem add(Action a) {
        JMenuItem mi = this.createActionComponent(a);
        mi.setAction(a);
        this.add(mi);
        return mi;
    }

    protected Component _addItem(Component item) {
        if (item != null) {
            if (!(!(item instanceof JMenu) || item instanceof VMenu && ((VMenu)item)._isOverflowMenu())) {
                ((JMenu)item).setOpaque(true);
            }
            Dimension d = item.getPreferredSize();
            if (this.overflowMenu == null) {
                boolean didOverflow = false;
                if (this.getMaxItemsPerMenu() > 0 && this.itemCount >= this.getMaxItemsPerMenu()) {
                    didOverflow = true;
                } else if (this.getMaxRows() <= 0 && this.menuHeight + d.height > this.screenHeight) {
                    didOverflow = true;
                }
                if (didOverflow) {
                    int rows = this.getMaxItemsPerMenu();
                    this.overflowMenu = new VMenu("More ...");
                    this.overflowMenu._setOverflowMenu();
                    this.overflowMenu.setOpaque(true);
                    this.overflowMenu.setBackground(ColorTools.mix((Color)Color.lightGray, (Color)Color.gray, (double)0.1));
                    this.overflowMenu.setMaxItemsPerMenu(this.getMaxItemsPerMenu());
                    this.overflowMenu.setMaxRows(this.getMaxRows());
                    super.add((Component)this.overflowMenu, -1);
                }
            }
            if (this.overflowMenu != null) {
                return this.overflowMenu._addItem(item);
            }
            ++this.itemCount;
            this.menuHeight += d.height;
            Component c = this._addItemToThisMenu(item);
            return c;
        }
        return null;
    }

    protected Component _addItemToThisMenu(Component c) {
        Component cc = super.add(c, -1);
        return cc;
    }

    public void setActionEnabled(String ac, boolean enable) {
        VButton.setActionEnabled(this, ac, enable);
    }

    public void addSeparator(JSeparator sep) {
        this.add(sep);
    }

    @Override
    public void addSeparator() {
        this.addSeparator(new Separator());
    }

    public void setMaxItemsPerMenu(int maxItems) {
        this.maxItems = maxItems > 0 ? maxItems : -1;
    }

    public int getMaxItemsPerMenu() {
        if (this.maxItems > 0) {
            return this.maxItems;
        }
        return -1;
    }

    public void setMaxRows(int maxRows, int maxCols) {
        this.setMaxItemsPerMenu(maxCols * maxRows - 1);
        this.setMaxRows(maxRows);
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows > 0 ? maxRows : -1;
        JPopupMenu p = this.getPopupMenu();
        LayoutManager layout = p.getLayout();
        if (layout instanceof VMenuLayout) {
            if (this.maxRows > 0) {
                ((VMenuLayout)layout).setRows(this.maxRows);
            } else if (this.oldLayout != null) {
                p.setLayout(this.oldLayout);
                this.oldLayout = null;
            } else {
                ((VMenuLayout)layout).setRows(this.maxRows);
            }
        } else if (this.maxRows > 0) {
            this.oldLayout = layout;
            p.setLayout(new VMenuLayout(this.maxRows));
            p.setBackground(Color.gray);
        }
    }

    public int getMaxRows() {
        if (this.maxRows > 0) {
            return this.maxRows;
        }
        return -1;
    }

    @Override
    protected JMenuItem createActionComponent(Action a) {
        VMenuItem mi = new VMenuItem((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon")){

            @Override
            protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
                PropertyChangeListener pcl = new ActionChangedListener(this);
                if (pcl == null) {
                    pcl = super.createActionPropertyChangeListener(a);
                }
                return pcl;
            }
        };
        mi.setHorizontalTextPosition(11);
        mi.setVerticalTextPosition(0);
        mi.setEnabled(a.isEnabled());
        return mi;
    }

    private void _installKeyListener() {
        Print.logInfo((String)"Installing KeyListener ...", (Object[])new Object[0]);
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Print.logInfo((String)"VMenu Captured Key Pressed ...", (Object[])new Object[0]);
            }
        });
        final JPopupMenu pu = this.getPopupMenu();
        pu.setFocusable(true);
        pu.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Print.logInfo((String)"JPopupMenu Captured Key Pressed ...", (Object[])new Object[0]);
            }
        });
        pu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Print.logInfo((String)("Popup will show: " + pu.isFocusable()), (Object[])new Object[0]);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Print.logInfo((String)("Requesting Popup focus: " + pu.requestFocusInWindow()), (Object[])new Object[0]);
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Print.logInfo((String)"Popup will hide", (Object[])new Object[0]);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                Print.logInfo((String)"Popup us cancelled", (Object[])new Object[0]);
            }
        });
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        WeakReference menuItem;

        public ActionChangedListener(JMenuItem mi) {
            this.setTarget(mi);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            JMenuItem mi = this.getTarget();
            if (mi == null) {
                Action action = (Action)e.getSource();
                action.removePropertyChangeListener(this);
            } else if (propertyName.equals("Name")) {
                String text = (String)e.getNewValue();
                mi.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                mi.setEnabled(enabledState);
            } else if (propertyName.equals("SmallIcon")) {
                Icon icon = (Icon)e.getNewValue();
                mi.setIcon(icon);
                mi.invalidate();
                mi.repaint();
            } else if (propertyName.equals("ActionCommandKey")) {
                mi.setActionCommand((String)e.getNewValue());
            }
        }

        public void setTarget(JMenuItem b) {
            this.menuItem = new WeakReference<JMenuItem>(b);
        }

        public JMenuItem getTarget() {
            return (JMenuItem)this.menuItem.get();
        }
    }

    public static class Separator
    extends JPopupMenu.Separator {
    }
}

