/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import javax.swing.JSeparator;
import org.opengts.opt.ui.VListViewer;
import org.opengts.opt.ui.VSeparator;
import org.opengts.util.StringTools;

public class VListItem
implements VListViewer.ItemValidator {
    protected String key = "";
    protected Object userObject = null;
    protected Component customView = null;
    protected String toolTipText = null;
    protected boolean isEnabled = true;
    protected Object listObject = null;
    private boolean okSelectNext = true;
    private boolean okSelectPrevious = true;

    public VListItem() {
        this("", null, null);
    }

    public VListItem(String key, Object userObj) {
        this(key, userObj, null);
    }

    public VListItem(String key, Object userObj, Component customComp) {
        this.key = StringTools.trim((String)key);
        this.userObject = userObj;
        this.isEnabled = userObj != null && !(userObj instanceof JSeparator);
        this.customView = customComp;
    }

    public Object getListObject() {
        if (this.listObject == null) {
            this.listObject = this.userObject != null ? this : this.createVSeparator();
        }
        return this.listObject;
    }

    protected VSeparator createVSeparator() {
        return new VSeparator(0, 3);
    }

    public boolean isSeparator() {
        return this.getListObject() instanceof JSeparator;
    }

    public void setKey(String key) {
        this.key = StringTools.trim((String)key);
    }

    public String getKey() {
        return this.key;
    }

    public void setCustomView(Component c) {
        this.customView = c;
    }

    public Component getCustomView() {
        return this.customView;
    }

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public boolean getEnabled() {
        return this.isEnabled;
    }

    public boolean isEnabled() {
        return this.getEnabled();
    }

    public void setAllowSelectNext(boolean nextOK) {
        this.okSelectNext = nextOK;
    }

    public boolean allowSelectNext() {
        return this.okSelectNext;
    }

    public void setAllowSelectPrevous(boolean prevOK) {
        this.okSelectPrevious = prevOK;
    }

    public boolean allowSelectPrevious() {
        return this.okSelectPrevious;
    }

    public boolean validateCustomView() {
        if (!(this.customView instanceof ValidatableView)) {
            return true;
        }
        return ((ValidatableView)((Object)this.customView)).validateEntries();
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public String toString() {
        return this.userObject != null ? this.userObject.toString() : "";
    }

    @Override
    public boolean isListItemValid(boolean okToAlertUser) {
        if (this.customView instanceof VListViewer.ItemValidator) {
            return ((VListViewer.ItemValidator)((Object)this.customView)).isListItemValid(okToAlertUser);
        }
        return true;
    }

    public static interface ValidatableView {
        public boolean validateEntries();
    }
}

