/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VContextMenu;
import org.opengts.opt.ui.VListItem;
import org.opengts.opt.ui.VPopupMenuProvider;
import org.opengts.util.ListTools;
import org.opengts.util.Print;

public class VList
extends VBox
implements ListSelectionListener {
    public static final int KEY_BINDING_NONE = 0;
    public static final int KEY_BINDING_NORMAL = 1;
    public static final int KEY_BINDING_CUSTOM = 2;
    private JList listArea = null;
    private Vector<Object> listData = null;
    private CustomKeyBindingHandler keyBindHandler = null;
    private List<VListSelectionListener> changeListeners = new Vector<VListSelectionListener>();

    public VList(String title, String label, boolean bordered) {
        super(title, label, bordered);
        this.listArea = this.createJList();
        this.listArea.setOpaque(true);
        this.listArea.setBackground(Color.white);
        this.listArea.setSelectionMode(0);
        this.listArea.addListSelectionListener(this);
        ListCellRenderer lcr = this.createListCellRenderer();
        if (lcr != null) {
            this.listArea.setCellRenderer(lcr);
        }
        super.setComponentListeners(this.listArea);
        this.listArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JList jv = VList.this.getJList();
                int index = jv.locationToIndex(e.getPoint());
                if (e.getClickCount() == 2) {
                    VList.this.doubleClicked(index);
                } else if (e.getClickCount() == 1) {
                    VList.this.singleClicked(index);
                }
            }
        });
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.5, 0, 1);
        JScrollPane scrollPane = new JScrollPane(this.listArea);
        this.add((Component)scrollPane, this.getDefaultGBC());
    }

    public JList getJList() {
        return this.listArea;
    }

    @Override
    public void setEnabled(boolean flag) {
        if (this.listArea != null) {
            this.listArea.setEnabled(flag);
        }
        super.setEnabled(flag);
    }

    public void setKeyBindingMode(int mode) {
        if (this.listArea instanceof VJList) {
            ((VJList)this.listArea).setKeyBindingMode(mode);
        }
    }

    public void setKeyBindingHandler(CustomKeyBindingHandler kbh) {
        if (this.listArea instanceof VJList) {
            ((VJList)this.listArea).setKeyBindingHandler(kbh);
        }
    }

    public void setAllowKeyBindings(boolean allow) {
        if (this.listArea instanceof VJList) {
            ((VJList)this.listArea).setAllowKeyBindings(allow);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.listArea != null) {
            this.listArea.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.listArea != null) {
            this.listArea.setForeground(color);
        }
    }

    public int getSelectionMode() {
        return this.listArea.getSelectionMode();
    }

    public void setSelectionMode(int mode) {
        this.listArea.setSelectionMode(mode);
    }

    public void addSelectionListener(VListSelectionListener lsl) {
        if (lsl != null && !this.changeListeners.contains(lsl)) {
            this.changeListeners.add(lsl);
        }
    }

    public void removeSelectionListener(VListSelectionListener lsl) {
        this.changeListeners.remove(lsl);
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        for (VListSelectionListener lsl : this.changeListeners) {
            if (lse.getValueIsAdjusting()) continue;
            lsl.selectionChanged(this);
        }
    }

    protected void doubleClicked(int index) {
        this.fireAction();
    }

    protected void singleClicked(int index) {
    }

    public VContextMenu setContextMenu(JPopupMenu popup) {
        return VContextMenu.setContextMenu((JComponent)this.listArea, popup);
    }

    public VContextMenu setContextMenu(VPopupMenuProvider popupProv) {
        return VContextMenu.setContextMenu((JComponent)this.listArea, popupProv);
    }

    public VContextMenu getContextMenu() {
        return VContextMenu.getContextMenu(this.listArea);
    }

    public void setListData(Component[] items) {
        this.listData = (Vector)ListTools.toList((Object[])items, new Vector());
        this.listArea.setListData(this.listData);
    }

    public void setListData(String[] items) {
        this.listData = (Vector)ListTools.toList((Object[])items, new Vector());
        this.listArea.setListData(this.listData);
    }

    public void setListData(VListItem[] items) {
        this.listData = (Vector)ListTools.toList((Object[])items, new Vector());
        this.listArea.setListData(this.listData);
    }

    public void setListData(List<?> items) {
        this.listData = items != null ? new Vector(items) : new Vector();
        this.listArea.setListData(this.listData);
    }

    public List<Object> getListData() {
        return this.listData;
    }

    public int getListSize() {
        if (ListTools.isEmpty(this.listData)) {
            return 0;
        }
        return this.listData.size();
    }

    public Object getValueAt(int ndx) {
        if (ListTools.isEmpty(this.listData)) {
            return null;
        }
        if (ndx >= 0 && ndx < this.listData.size()) {
            return this.listData.get(ndx);
        }
        return null;
    }

    public VListItem getItemAt(int ndx) {
        Object val = this.getValueAt(ndx);
        return val instanceof VListItem ? (VListItem)val : null;
    }

    public void clearSelection() {
        this.listArea.clearSelection();
    }

    public void setSelectedIndex(int ndx) {
        if (ndx >= 0) {
            this.listArea.setSelectedIndex(ndx);
        } else {
            this.listArea.clearSelection();
        }
    }

    public int getSelectedIndex() {
        return this.listArea.getSelectedIndex();
    }

    public int[] getSelectedIndices() {
        return this.listArea.getSelectedIndices();
    }

    public void setSelectedValue(Object val, boolean scroll) {
        this.listArea.setSelectedValue(val, scroll);
    }

    public void setSelectedValue(Object val) {
        this.setSelectedValue(val, true);
    }

    public Object getSelectedValue() {
        return this.listArea.getSelectedValue();
    }

    public Object[] getSelectedValues() {
        return this.listArea.getSelectedValues();
    }

    public VListItem getSelectedItem() {
        Object obj = this.listArea.getSelectedValue();
        return obj instanceof VListItem ? (VListItem)obj : null;
    }

    public VListItem[] getSelectedItems() {
        Object[] obj = this.listArea.getSelectedValues();
        if (obj == null) {
            return new VListItem[0];
        }
        VListItem[] item = new VListItem[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            if (!(obj[i] instanceof VListItem)) {
                return null;
            }
            item[i] = (VListItem)obj[i];
        }
        return item;
    }

    @Override
    public void selectItemAt(Point p) {
        JList jv = this.getJList();
        Point jp = SwingUtilities.convertPoint(this, p, jv);
        int ndx = jv.locationToIndex(jp);
        jv.setSelectedIndex(ndx);
    }

    public void setCellRenderer(ListCellRenderer cr) {
        this.listArea.setCellRenderer(cr);
    }

    public int getFixedCellHeight() {
        return this.listArea.getFixedCellHeight();
    }

    public void setFixedCellHeight(int h) {
        this.listArea.setFixedCellHeight(h);
    }

    @Override
    public void resetKeyboardActions() {
        super.resetKeyboardActions();
        this.listArea.resetKeyboardActions();
    }

    protected ListCellRenderer createListCellRenderer() {
        return new VListCellRenderer();
    }

    protected JList createJList() {
        return new VJList();
    }

    public static class PartitionCellRenderer
    extends VBox
    implements ListCellRenderer {
        private PartitionText[] partition = null;

        public PartitionCellRenderer() {
            this(new int[]{-1});
        }

        public PartitionCellRenderer(int[] width) {
            super(null, null, false);
            this.setOpaque(true);
            GridBagConstraints gbc = this.getDefaultGBC();
            VBox.SetGBCX(gbc, 0.0, -1, 1);
            VBox.SetGBCY(gbc, 0.0, 0, 1);
            gbc.anchor = 17;
            this.partition = new PartitionText[width.length];
            for (int i = 0; i < width.length; ++i) {
                Dimension d = new Dimension(width[i], 14);
                this.partition[i] = new PartitionText(d);
                if (i == width.length - 1) {
                    gbc.weightx = 0.5;
                    gbc.fill = 2;
                }
                this.add((Component)this.partition[i], gbc);
            }
            this.add((Component)new JPanel(), gbc);
        }

        @Override
        public boolean isOpaque() {
            return true;
        }

        public Component getListCellRendererComponent(JList list, Object val, int index, boolean isSel, boolean focus) {
            this.setBackground(isSel ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSel ? list.getSelectionForeground() : list.getForeground());
            this.setPartitionValues(list, val, isSel);
            this.setOpaque(true);
            return this;
        }

        public void setPartitionValues(JList list, Object val, boolean isSel) {
            this.setPartition(0, val.toString(), this.getBackground(), this.getForeground(), list.getFont());
        }

        public void setPartition(int i, String text, Color bg, Color fg, Font font) {
            if (this.partition != null && i < this.partition.length) {
                this.partition[i].setText(" " + text);
                this.partition[i].setEnabled(true);
                this.partition[i].setFont(font);
                this.partition[i].setBackground(bg);
                this.partition[i].setForeground(fg);
                this.partition[i].setOpaque(true);
            }
        }

        public class PartitionText
        extends JLabel {
            private Dimension d = null;

            public PartitionText(Dimension d) {
                this.d = d;
            }

            @Override
            public Dimension getPreferredSize() {
                if (this.d.width <= 0) {
                    int w = super.getPreferredSize().width;
                    return new Dimension(w, this.d.height);
                }
                return this.d;
            }
        }
    }

    public static class VJList
    extends JList {
        private CustomKeyBindingHandler keyBindingHandler = null;
        private int keyBindingMode = 1;

        protected Object getElementAtPoint(Point p) {
            int ndx = this.locationToIndex(p);
            Object item = ndx >= 0 ? this.getModel().getElementAt(ndx) : null;
            return item;
        }

        protected boolean isElementEnabledAtPoint(Point p) {
            Object item = this.getElementAtPoint(p);
            if (item instanceof JSeparator) {
                return false;
            }
            return !(item instanceof VListItem) || ((VListItem)item).isEnabled();
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            VListItem vli;
            Object item;
            int eventID = me.getID();
            if (!this.isElementEnabledAtPoint(me.getPoint())) {
                if (eventID == 500) {
                    this.requestFocus();
                }
                return;
            }
            int currNdx = this.getSelectedIndex();
            Object v0 = item = currNdx >= 0 ? this.getModel().getElementAt(currNdx) : null;
            if (item instanceof VListItem && !(vli = (VListItem)item).isEnabled() && (vli.allowSelectNext() || vli.allowSelectPrevious())) {
                Print.logDebug((String)"Only Previous/Next allowed on disabled VListItem", (Object[])new Object[0]);
                if (eventID == 500) {
                    this.requestFocus();
                }
                return;
            }
            super.processMouseEvent(me);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent me) {
            if (this.isElementEnabledAtPoint(me.getPoint())) {
                super.processMouseMotionEvent(me);
            }
        }

        public int getKeyBindingMode() {
            return this.keyBindingMode;
        }

        public void setKeyBindingMode(int mode) {
            if (mode <= 0) {
                this.keyBindingHandler = null;
                this.keyBindingMode = 0;
            } else if (mode >= 2) {
                this.keyBindingMode = 2;
            } else {
                this.keyBindingHandler = null;
                this.keyBindingMode = mode;
            }
        }

        public void setKeyBindingHandler(CustomKeyBindingHandler kbh) {
            if (kbh != null) {
                this.keyBindingHandler = kbh;
                this.keyBindingMode = 2;
            } else {
                this.keyBindingHandler = null;
                this.keyBindingMode = 1;
            }
        }

        public void setAllowKeyBindings(boolean allow) {
            this.setKeyBindingMode(allow ? 1 : 0);
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            int kc = e.getKeyCode();
            switch (this.getKeyBindingMode()) {
                case 0: {
                    return false;
                }
                case 1: {
                    boolean rtn = super.processKeyBinding(ks, e, condition, pressed);
                    Print.logInfo((String)("keyBinding: Stroke=" + ks + " Code=" + e.getKeyCode() + " Cond=" + condition + " Press=" + pressed + " Rtn=" + rtn), (Object[])new Object[0]);
                    return rtn;
                }
                case 2: {
                    if (this.keyBindingHandler != null) {
                        return this.keyBindingHandler.processKeyBinding(ks, e, condition, pressed);
                    }
                    if (condition != 0 || !pressed) break;
                    int ndx = -1;
                    switch (kc) {
                        case 37: 
                        case 38: {
                            ndx = this.getNextIndex(false);
                            break;
                        }
                        case 39: 
                        case 40: {
                            ndx = this.getNextIndex(true);
                        }
                    }
                    if (ndx < 0) break;
                    this.setSelectedIndex(ndx);
                }
            }
            return false;
        }

        public int getNextIndex(boolean forward) {
            Object newItem;
            ListModel model = this.getModel();
            int size = model.getSize();
            if (size <= 0) {
                return -1;
            }
            int start = this.getLeadSelectionIndex();
            int index = start;
            if (index < 0) {
                return 0;
            }
            Object thisItem = model.getElementAt(index);
            if (thisItem instanceof VListItem) {
                VListItem vli = (VListItem)thisItem;
                if (forward ? !vli.allowSelectNext() : !vli.allowSelectPrevious()) {
                    return -1;
                }
            }
            do {
                if (forward) {
                    if (++index >= size) {
                        index = 0;
                    }
                } else if (--index < 0) {
                    index = size - 1;
                }
                if (index != start) continue;
                return -1;
            } while ((newItem = model.getElementAt(index)) instanceof JSeparator || newItem instanceof VListItem && ((VListItem)newItem).isSeparator() || newItem instanceof VListItem && !((VListItem)newItem).isEnabled());
            return index;
        }

        @Override
        public void setSelectedIndex(int index) {
            if (index >= 0 && index < this.getModel().getSize()) {
                super.setSelectedIndex(index);
            }
        }

        @Override
        public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
            try {
                int searchNdx = startIndex;
                ListModel model = this.getModel();
                int max = model.getSize();
                int last = -1;
                while (true) {
                    int ndx;
                    if ((ndx = super.getNextMatch(prefix, searchNdx, bias)) < 0) {
                        return ndx;
                    }
                    Object item = model.getElementAt(ndx);
                    if (!(item instanceof VListItem) || ((VListItem)item).isEnabled()) {
                        return ndx;
                    }
                    if (last == ndx) {
                        return -1;
                    }
                    if (last < 0) {
                        last = ndx;
                    }
                    searchNdx = (ndx + 1) % max;
                }
            }
            catch (IllegalArgumentException iae) {
                return -1;
            }
        }
    }

    public static class VListCellRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        private int prefHeight = -1;

        public Component getListCellRendererComponent(JList list, Object val, int index, boolean isSel, boolean focus) {
            if (val instanceof VBox) {
                VBox vb = (VBox)val;
                vb.setEnabled(list.isEnabled());
                vb.setPreferredHeight(list.getFixedCellHeight());
                vb.setOpaque(true);
                return vb;
            }
            if (val instanceof Component) {
                return (Component)val;
            }
            super.getListCellRendererComponent((JList<?>)list, val, index, isSel, focus);
            return this.adjustsRendererComponent(list, val, index, isSel, focus);
        }

        protected Component adjustsRendererComponent(JList list, Object val, int index, boolean isSel, boolean focus) {
            this.setEnabled(list.isEnabled());
            this.setPreferredHeight(list.getFixedCellHeight());
            this.setOpaque(true);
            return this;
        }

        public void setPreferredHeight(int height) {
            this.prefHeight = height;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (d != null && this.prefHeight > 0) {
                d = new Dimension(d.width, this.prefHeight);
            }
            return d;
        }
    }

    public static interface VListSelectionListener {
        public void selectionChanged(VList var1);
    }

    public static interface CustomKeyBindingHandler {
        public boolean processKeyBinding(KeyStroke var1, KeyEvent var2, int var3, boolean var4);
    }
}

