/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JLabel;
import org.opengts.util.StringTools;

public class VLabel
extends JLabel {
    private Dimension preferredSize = null;
    private Dimension maximumSize = null;
    private Insets insets = null;

    public VLabel() {
        super("");
    }

    public VLabel(String text) {
        super("");
        this.setText(text);
    }

    @Override
    public void setHorizontalAlignment(int alignment) {
        super.setHorizontalAlignment(alignment);
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            super.setText("");
        } else if (StringTools.startsWithIgnoreCase((String)text.trim(), (String)"<html")) {
            super.setText(text);
        } else if (text.indexOf("\n") >= 0) {
            String htmlText = "<html><center>" + StringTools.htmlFilterText((Object)text) + "</center></html>";
            super.setText(htmlText);
        } else {
            super.setText(text);
        }
    }

    @Override
    public Insets getInsets(Insets insets) {
        if (this.insets != null) {
            if (insets != null) {
                insets.top = this.insets.top;
                insets.left = this.insets.left;
                insets.bottom = this.insets.bottom;
                insets.right = this.insets.right;
            } else {
                insets = (Insets)this.insets.clone();
            }
            return insets;
        }
        return super.getInsets(insets);
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        if (this.preferredSize == null) {
            return ps;
        }
        Dimension d = new Dimension(this.preferredSize);
        if (d.width < 0) {
            d.width = ps.width;
        }
        if (d.height < 0) {
            d.height = ps.height;
        }
        return d;
    }

    @Override
    public void setPreferredSize(Dimension ps) {
        this.preferredSize = ps;
    }

    public void setPreferredWidth(int w) {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(-1, -1);
        }
        this.preferredSize.width = w;
    }

    public void setPreferredHeight(int h) {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(-1, -1);
        }
        this.preferredSize.height = h;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension ps = super.getMaximumSize();
        if (this.maximumSize == null) {
            return ps;
        }
        Dimension d = new Dimension(this.maximumSize);
        if (d.width < 0) {
            d.width = ps.width;
        }
        if (d.height < 0) {
            d.height = ps.height;
        }
        return d;
    }

    @Override
    public void setMaximumSize(Dimension ps) {
        this.maximumSize = ps;
    }

    public void setMaximumWidth(int w) {
        if (this.maximumSize == null) {
            this.maximumSize = new Dimension(-1, -1);
        }
        this.maximumSize.width = w;
    }

    public void setMaximumHeight(int h) {
        if (this.maximumSize == null) {
            this.maximumSize = new Dimension(-1, -1);
        }
        this.maximumSize.height = h;
    }

    @Override
    public void setBackground(Color back) {
        super.setOpaque(true);
        super.setBackground(back);
    }

    public void setPlainFont() {
        Font font = this.getFont();
        this.setFont(font.deriveFont(0));
    }

    public void setBoldFont() {
        Font font = this.getFont();
        this.setFont(font.deriveFont(1));
    }

    public void setItalicFont() {
        Font font = this.getFont();
        this.setFont(font.deriveFont(2));
    }

    public int getFontSize() {
        Font font = this.getFont();
        return font.getSize();
    }

    public void setFontSize(int size) {
        Font font = this.getFont();
        this.setFont(font.deriveFont(size));
    }
}

