/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import java.io.File;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.opengts.opt.ui.VFileFilter;
import org.opengts.opt.ui.VOptionPane;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;

public class VFileChooser
extends JFileChooser {
    private boolean selectionMustExist = false;

    public VFileChooser(File dir) {
        super(dir);
        this.setNewFolderEnabled(false);
    }

    public VFileChooser(File dir, FileFilter filter) {
        this(dir);
        this.setFileFilter(filter);
    }

    public VFileChooser(File dir, FileFilter[] filter) {
        this(dir);
        this.setFileFilters(filter);
    }

    public VFileChooser(File dir, String desc, String[] extn) {
        this(dir);
        this.setFileFilter(new VFileFilter(desc, extn));
    }

    @Override
    public void updateUI() {
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        super.updateUI();
    }

    public void setNewFolderEnabled(boolean enable) {
        Action nfa;
        FileChooserUI ui = super.getUI();
        if (ui instanceof BasicFileChooserUI && (nfa = ((BasicFileChooserUI)ui).getNewFolderAction()) != null) {
            nfa.setEnabled(enable);
        }
    }

    public void setFileFilters(FileFilter[] filter) {
        if (filter != null && filter.length > 0) {
            for (int i = 0; i < filter.length; ++i) {
                super.addChoosableFileFilter(filter[i]);
            }
            this.setFileFilter(filter[0]);
        }
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        super.setFileFilter(filter);
    }

    @Override
    public FileFilter getFileFilter() {
        return super.getFileFilter();
    }

    @Override
    public int getDialogType() {
        return super.getDialogType();
    }

    @Override
    public void setDialogType(int type) {
        super.setDialogType(type);
    }

    public boolean getSelectionMustExist() {
        switch (this.getDialogType()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return this.selectionMustExist;
    }

    public void setSelectionMustExist(boolean mustExist) {
        this.selectionMustExist = mustExist;
        this.setDialogType(mustExist ? 0 : 1);
    }

    private File _resolveFile(File selFile, FileFilter filter) {
        if (filter == null) {
            filter = this.getFileFilter();
        }
        if (filter.accept(selFile)) {
            return selFile;
        }
        if (filter instanceof VFileFilter) {
            VFileFilter vff = (VFileFilter)filter;
            int ecnt = vff.getExtensionCount();
            if (ecnt != 0) {
                if (ecnt == 1) {
                    String path = selFile.getPath();
                    String extn = vff.getExtension(0);
                    selFile = new File(path + "." + extn);
                } else {
                    String path = selFile.getPath();
                    String extn = vff.getExtension(0);
                    selFile = new File(path + "." + extn);
                }
            }
            return selFile;
        }
        return selFile;
    }

    @Override
    public void approveSelection() {
        if (this.getSelectionMustExist()) {
            FileFilter filter = this.getFileFilter();
            if (this.isMultiSelectionEnabled()) {
                File[] fileList = this.getSelectedFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    File file = this._resolveFile(fileList[i], filter);
                    if (file.exists()) continue;
                    VOptionPane.showErrorDialog(this, "A selected file does not exist\nPlease make sure all selected files exist", "File does not exist");
                    return;
                }
            } else {
                File file = this._resolveFile(this.getSelectedFile(), filter);
                if (!file.exists()) {
                    VOptionPane.showErrorDialog(this, "The selected file does not exist\nPlease make sure the selected/entered files exists", "File does not exist");
                    return;
                }
            }
        }
        super.approveSelection();
    }

    @Override
    public void cancelSelection() {
        super.cancelSelection();
    }

    @Override
    public boolean accept(File f) {
        return super.accept(f);
    }

    @Override
    public int showDialog(Component parent, String title) {
        return super.showDialog(parent, title);
    }

    public File showChooser(Component parent, String title, boolean mustExist) {
        this.setSelectionMustExist(mustExist);
        int rtn = this.showDialog(parent, title);
        if (rtn == 0) {
            return this._resolveFile(this.getSelectedFile(), null);
        }
        return null;
    }

    @Override
    public File[] getSelectedFiles() {
        return super.getSelectedFiles();
    }

    @Override
    public void setSelectedFiles(File[] files) {
        super.setSelectedFiles(files);
    }

    @Override
    public File getSelectedFile() {
        return super.getSelectedFile();
    }

    @Override
    public void setSelectedFile(File file) {
        super.setSelectedFile(file);
    }

    @Override
    public void setCurrentDirectory(File dir) {
        super.setCurrentDirectory(dir);
    }

    @Override
    public File getCurrentDirectory() {
        return super.getCurrentDirectory();
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        FileFilter[] ff = new VFileFilter[]{new VFileFilter("Text files", new String[]{"txt"}), new VFileFilter("Java files", new String[]{"java"}), new VFileFilter("C files", new String[]{"c", "h", "cpp", "cc", "hh"})};
        VFileChooser fc = new VFileChooser(new File("."), ff);
        File file = fc.showChooser(null, "Purge", true);
        Print.sysPrintln((String)("You chose: " + file), (Object[])new Object[0]);
        file = fc.showChooser(null, "Test", false);
        Print.sysPrintln((String)("You chose: " + file), (Object[])new Object[0]);
    }
}

