/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.ComboPopup;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class VComboBox
extends VBox
implements PopupMenuListener {
    public static final Color READONLY_BACKGROUND_COLOR = new Color(220, 220, 220);
    public static final Color READONLY_EDITABLE_BACKGROUND_COLOR = new Color(235, 235, 235);
    private VJComboBox comboBox = this.createComboBox();
    private JPanel comboFiller = null;
    private HashMap<String, Object> propertyMap = null;

    public VComboBox(String title, String label, boolean bordered) {
        super(title, label, bordered);
        this.comboBox.setModel((ComboBoxModel)new VDefaultComboBoxModel());
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                int type = ie.getStateChange();
                if (type == 1) {
                    VComboBox.this.setDirty();
                }
            }
        });
        this.comboBox.addPopupMenuListener(this);
        super.setComponentListeners(this.comboBox);
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.0, 0, 1);
        this.add((Component)this.comboBox, this.getDefaultGBC());
    }

    public VComboBox(String[] items) {
        this(null, null, false);
        this.setModel(items);
    }

    public VComboBox(Object[] items) {
        this(null, null, false);
        this.setModel(items);
    }

    public VComboBox(List items) {
        this(null, null, false);
        this.setModel(items);
    }

    public VComboBox(Map items) {
        this(null, null, false);
        this.setModel(items);
    }

    protected VJComboBox createComboBox() {
        VJComboBox vcb = new VJComboBox();
        return vcb;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
    }

    public boolean isPopupVisible() {
        return this.comboBox.isPopupVisible();
    }

    public void setEditable(boolean editable) {
        this.comboBox.setEditable(editable);
    }

    public boolean isEditable() {
        return this.comboBox.isEditable();
    }

    public void clearModel() {
        this.comboBox.setModel((ComboBoxModel)new VDefaultComboBoxModel());
    }

    public void setModel(String[] items) {
        String selItem = this.getSelectedText();
        this.comboBox.setModel((ComboBoxModel)new VDefaultComboBoxModel(items));
        this.propertyMap = null;
        if (this.containsItem(selItem)) {
            this.setSelectedText(selItem);
        } else if (this.isEditable()) {
            this.setSelectedText(selItem);
        }
    }

    public void setModel(Object[] items) {
        this.setModel(ListTools.toList((Object[])items));
    }

    public void setModel(List items) {
        super.setFireActionEnabled(false);
        String selItem = this.getSelectedText();
        this.comboBox.setModel((ComboBoxModel)new VDefaultComboBoxModel());
        if (items != null) {
            this.propertyMap = null;
            for (Object item : items) {
                if (item instanceof Object[] && ((Object[])item).length >= 2) {
                    Object key = ((Object[])item)[0];
                    if (key == null) continue;
                    this.addItem(key.toString(), ((Object[])item)[1]);
                    continue;
                }
                this.addItem(item);
            }
        }
        if (this.containsItem(selItem)) {
            this.setSelectedText(selItem);
        } else if (this.isEditable() && selItem != null) {
            this.setSelectedText(selItem);
        }
        super.setFireActionEnabled(true);
    }

    public void setModel(Map items) {
        super.setFireActionEnabled(false);
        String selItem = this.getSelectedText();
        this.comboBox.setModel((ComboBoxModel)new VDefaultComboBoxModel());
        this.propertyMap = null;
        for (Object key : items.keySet()) {
            Object val = items.get(key);
            this.addItem(key.toString(), val);
        }
        if (this.containsItem(selItem)) {
            this.setSelectedText(selItem);
        } else if (this.isEditable() && selItem != null) {
            this.setSelectedText(selItem);
        }
        super.setFireActionEnabled(true);
    }

    public void setModel(Object[][] items) {
        super.setFireActionEnabled(false);
        String selItem = this.getSelectedText();
        this.comboBox.setModel((ComboBoxModel)new VDefaultComboBoxModel());
        this.propertyMap = null;
        for (int i = 0; i < items.length; ++i) {
            Object val;
            Object key = items[i].length > 0 ? items[i][0] : null;
            Object object = val = items[i].length > 1 ? items[i][1] : null;
            if (key == null || val == null) continue;
            this.addItem(key.toString(), val);
        }
        if (this.containsItem(selItem)) {
            this.setSelectedText(selItem);
        } else if (this.isEditable() && selItem != null) {
            this.setSelectedText(selItem);
        }
        super.setFireActionEnabled(true);
    }

    public DefaultComboBoxModel getModel() {
        return (DefaultComboBoxModel)this.comboBox.getModel();
    }

    public void addItem(Object[] item) {
        if (item != null) {
            for (int i = 0; i < item.length; ++i) {
                this.addItem(item[i]);
            }
        }
    }

    public void addItem(Object item) {
        if (item instanceof Component) {
            this.getModel().addElement(item);
        } else {
            String key = item.toString();
            Object val = item instanceof String ? null : item;
            this.addItem(key, val);
        }
    }

    public void addItem(String item, Object property) {
        if (!this.containsItem(item)) {
            if (StringTools.isBlank((String)item)) {
                Print.logStackTrace((String)"Adding an empty String!");
            }
            this.getModel().addElement(item);
            this.setItemProperty(item, property);
        } else {
            Print.logError((String)("Item already exists: " + item), (Object[])new Object[0]);
        }
    }

    public void addItem(String item, int property) {
        this.addItem(item, new Integer(property));
    }

    public List<Object> getItemList() {
        Vector<Object> list = new Vector<Object>();
        DefaultComboBoxModel model = this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            list.add(model.getElementAt(i));
        }
        return list;
    }

    public void setItemProperty(String item, Object property) {
        if (property != null || this.propertyMap != null) {
            if (this.propertyMap == null) {
                this.propertyMap = new HashMap();
            }
            if (property != null) {
                this.propertyMap.put(item, property);
            } else {
                this.propertyMap.remove(item);
            }
        }
    }

    public Object getItemProperty(Object item) {
        if (this.propertyMap != null) {
            Object prop = this.propertyMap.get(item);
            return prop != null ? prop : item;
        }
        return item;
    }

    public String getPropertyItem(Object findProp) {
        if (findProp == null) {
            return null;
        }
        return this.getPropertyItem(findProp, findProp.toString());
    }

    public String getPropertyItem(Object findProp, String dft) {
        if (findProp == null) {
            return null;
        }
        if (this.propertyMap != null) {
            for (String item : this.propertyMap.keySet()) {
                Object prop = this.propertyMap.get(item);
                if (findProp != prop && !findProp.equals(prop)) continue;
                return item.toString();
            }
            return dft;
        }
        return dft;
    }

    public boolean containsItem(Object item) {
        if (item != null) {
            return this.getModel().getIndexOf(item.toString().trim()) >= 0;
        }
        return false;
    }

    public void setSelectedItem(Object item) {
        this.setSelectedText(item != null ? item.toString().trim() : null);
    }

    public void setSelectedText(String item) {
        if (!StringTools.isBlank((String)item)) {
            Object itemProp = null;
            String realItem = this.getPropertyItem(item, null);
            if (realItem != null) {
                itemProp = item;
                item = realItem.toString();
            } else {
                itemProp = this.getItemProperty(item);
            }
            String selItem = this.getSelectedText();
            if (!item.equals(selItem)) {
                DefaultComboBoxModel model = this.getModel();
                if (model.getIndexOf(item) < 0) {
                    model.addElement(item);
                }
                this.comboBox.setSelectedItem(item, true);
            }
        } else {
            String selItem = this.getSelectedText();
            if (selItem != null) {
                this.comboBox.setSelectedItem(null, true);
            }
        }
    }

    public void setSelectedProperty(Object newProp) {
        if (newProp != null) {
            Object selProp = this.getSelectedProperty();
            if (!newProp.equals(selProp)) {
                this.setSelectedItem(this.getPropertyItem(newProp));
            }
        } else {
            Object selProp = this.getSelectedProperty();
            if (selProp != null) {
                this.setSelectedItem(null);
            }
        }
    }

    public void setSelectedProperty(int prop) {
        this.setSelectedProperty(new Integer(prop));
    }

    @Override
    public void setValue(Object prop) {
        this.setSelectedProperty(prop);
    }

    public void setValue(int prop) {
        this.setSelectedProperty(new Integer(prop));
    }

    public Object getSelectedItem() {
        return this.comboBox.getSelectedItem();
    }

    public String getSelectedText() {
        Object sel = this.getSelectedItem();
        return sel != null ? sel.toString() : null;
    }

    public Object getSelectedProperty() {
        return this.getItemProperty(this.getSelectedText());
    }

    @Override
    public Object getValue() {
        Object prop = this.getSelectedProperty();
        return prop != null ? prop : null;
    }

    public String getStringValue(String dft) {
        Object prop = this.getSelectedProperty();
        return prop != null ? prop.toString() : dft;
    }

    public int getIntValue(int dft) {
        Object prop = this.getSelectedProperty();
        return StringTools.parseInt((Object)prop, (int)dft);
    }

    public int getSelectedIndex() {
        return this.comboBox.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.comboBox.setSelectedIndex(index);
    }

    @Override
    public void readOnlyStateChanged(boolean readOnly) {
        boolean R = readOnly || this._isReadOnly();
        boolean E = this.isEnabled();
        this.comboBox.setEnabled(!R && E);
        this.comboBox.setForeground(E ? Color.black : Color.darkGray);
        if (this.isEditable()) {
            ComboBoxEditor editor = this.comboBox.getEditor();
            Component comp = editor.getEditorComponent();
            if (!R && E) {
                comp.setBackground(Color.white);
            } else {
                comp.setBackground(READONLY_EDITABLE_BACKGROUND_COLOR);
            }
        }
    }

    @Override
    public void enabledStateChanged(boolean enabled) {
        if (this.comboBox != null) {
            boolean R = this.isReadOnly();
            boolean E = enabled && this._isEnabled();
            this.comboBox.setEnabled(E && !R);
            this.comboBox.setForeground(E ? Color.black : Color.darkGray);
            if (this.isEditable()) {
                ComboBoxEditor editor = this.comboBox.getEditor();
                Component comp = editor.getEditorComponent();
                if (E && !R) {
                    comp.setBackground(Color.white);
                } else {
                    comp.setBackground(READONLY_EDITABLE_BACKGROUND_COLOR);
                }
            }
        }
    }

    public void addButton(VButton btn) {
        this.setGBCX(0.0, -1, 0);
        btn.setPreferredHeight(this.comboBox.getPreferredSize().height);
        this.add((Component)btn, this.getDefaultGBC());
    }

    @Override
    public void setMaximumSize(Dimension size) {
        super.setMaximumSize(size);
        this.addFiller();
    }

    public VComboBox addFiller() {
        if (this.comboFiller == null) {
            this.comboFiller = new JPanel();
            this.comboFiller.setOpaque(false);
            this.setGBCX(0.5, -1, 1);
            this.setGBCY(0.0, 0, 1);
            this.add((Component)this.comboFiller, this.getDefaultGBC());
            GridBagLayout gbl = this.getContainerLayout();
            GridBagConstraints gbc = gbl.getConstraints(this.comboBox);
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.anchor = 17;
            gbl.setConstraints(this.comboBox, gbc);
        }
        return this;
    }

    public static class VDefaultComboBoxModel
    extends DefaultComboBoxModel {
        public VDefaultComboBoxModel() {
        }

        public VDefaultComboBoxModel(Object[] items) {
            super(items != null ? items : new Object[]{});
        }
    }

    protected class VJComboBoxRenderer
    extends BasicComboBoxRenderer {
        @Override
        public void setForeground(Color color) {
            if (VComboBox.this != null && VComboBox.this.isEnabled()) {
                color = Color.black;
            }
            super.setForeground(color);
        }

        @Override
        public void setBackground(Color color) {
            if (VComboBox.this != null && VComboBox.this.isEnabled() && VComboBox.this.isReadOnly()) {
                color = READONLY_BACKGROUND_COLOR;
            }
            super.setBackground(color);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Component) {
                return (Component)value;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    protected class VJComboBox
    extends JComboBox {
        private int doFireAction = 0;

        public VJComboBox() {
            this.setRenderer(new VJComboBoxRenderer());
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = new Dimension(super.getPreferredSize());
            d.height -= 6;
            return d;
        }

        @Override
        protected void fireActionEvent() {
            if (this.doFireAction == 0) {
                super.fireActionEvent();
            }
        }

        public void setModel(ComboBoxModel model) {
            super.setModel(model);
        }

        @Override
        public void setSelectedIndex(int ndx) {
            super.setSelectedIndex(ndx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelectedIndex(int ndx, boolean disableFireAction) {
            try {
                if (disableFireAction) {
                    ++this.doFireAction;
                }
                this.setSelectedIndex(ndx);
            }
            finally {
                if (disableFireAction) {
                    --this.doFireAction;
                }
            }
        }

        @Override
        public void setSelectedItem(Object obj) {
            if (!(obj instanceof Component)) {
                super.setSelectedItem(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelectedItem(Object obj, boolean disableFireAction) {
            try {
                if (disableFireAction) {
                    ++this.doFireAction;
                }
                this.setSelectedItem(obj);
            }
            finally {
                if (disableFireAction) {
                    --this.doFireAction;
                }
            }
        }

        public JList getJList() {
            Accessible a = this.getUI().getAccessibleChild(this, 0);
            if (a != null && a instanceof ComboPopup) {
                JList<Object> list = ((ComboPopup)((Object)a)).getList();
                return list;
            }
            return null;
        }
    }
}

