/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.opengts.opt.ui.VBox;
import org.opengts.util.StringTools;

public class VCheckBox
extends VBox {
    private JCheckBox checkBox = this.createCheckBox();

    public VCheckBox() {
        this(null, null, false);
    }

    public VCheckBox(String label) {
        this(null, null, false);
        this.setLabel(label, true);
    }

    public VCheckBox(String label, boolean onLeft) {
        this(null, null, false);
        this.setLabel(label, onLeft);
    }

    public VCheckBox(String title, String label, boolean bordered) {
        super(title, label, bordered);
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VCheckBox.this.setDirty();
            }
        });
        super.setComponentListeners(this.checkBox);
        this.setGBCX(0.5, 0, 1, 0, 0);
        this.setGBCY(0.0, 0, 1, 0, 0);
        this.add((Component)this.checkBox, this.getDefaultGBC());
    }

    protected JCheckBox createCheckBox() {
        return new VPrivateCheckBox();
    }

    @Override
    protected int getLabelAnchor() {
        return 17;
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public void setSelected(boolean sel) {
        this.checkBox.setSelected(sel);
    }

    @Override
    public Object getValue() {
        return new Boolean(this.isSelected());
    }

    @Override
    public void setValue(Object val) {
        if (val == null) {
            this.setSelected(false);
        } else if (val instanceof Boolean) {
            this.setSelected((Boolean)val);
        } else if (val instanceof Number) {
            this.setSelected(((Number)val).intValue() != 0);
        } else {
            this.setSelected(StringTools.parseBoolean((String)val.toString(), (boolean)false));
        }
    }

    @Override
    protected void readOnlyStateChanged(boolean readOnly) {
        boolean R = readOnly || this._isReadOnly();
        this.checkBox.setEnabled(!R);
    }

    @Override
    protected void enabledStateChanged(boolean enabled) {
        if (this.checkBox != null && !this._isReadOnly()) {
            boolean E = enabled && this._isEnabled();
            this.checkBox.setEnabled(E);
        }
    }

    protected class VPrivateCheckBox
    extends JCheckBox {
        public VPrivateCheckBox() {
            this.setMargin(new Insets(0, 0, 0, 0));
        }
    }
}

