/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import org.opengts.util.OrderedMap;

public class VButtonGroup
extends ButtonGroup {
    private OrderedMap<ButtonModel, Object> modelMap = new OrderedMap();

    @Override
    public void add(AbstractButton ab) {
        if (ab != null) {
            super.add(ab);
            this.modelMap.put((Object)ab.getModel(), (Object)ab);
        }
    }

    public void add(ToggleButtonProvider rbp) {
        JToggleButton rb;
        if (rbp != null && (rb = rbp.getToggleButton()) != null) {
            super.add(rb);
            this.modelMap.put((Object)rb.getModel(), (Object)rbp);
        }
    }

    @Override
    public void remove(AbstractButton ab) {
        if (ab != null) {
            super.remove(ab);
            this.modelMap.remove((Object)ab.getModel());
        }
    }

    public void remove(ToggleButtonProvider rbp) {
        JToggleButton rb;
        if (rbp != null && (rb = rbp.getToggleButton()) != null) {
            super.remove(rb);
            this.modelMap.remove((Object)rb.getModel());
        }
    }

    @Override
    public Enumeration<AbstractButton> getElements() {
        return super.getElements();
    }

    public Object getSelectedObject() {
        ButtonModel bm = this.getSelection();
        return bm != null ? this.modelMap.get((Object)bm) : null;
    }

    public Object getObject(int ndx) {
        return this.modelMap.getValue(ndx);
    }

    public void setSelectedIndex(int index) {
        ButtonModel bm = (ButtonModel)this.modelMap.getKey(index);
        if (bm != null) {
            this.setSelected(bm, true);
        }
    }

    public int getSelectedIndex() {
        ButtonModel bm = this.getSelection();
        return bm != null ? this.modelMap.indexOfKey((Object)bm) : -1;
    }

    public static interface ToggleButtonProvider {
        public JToggleButton getToggleButton();
    }
}

