/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.opengts.opt.ui.ActionTarget;
import org.opengts.opt.ui.VBox;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class VButton
extends VBox
implements ActionListener {
    public static final int ALT_MASK = 8;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int SHIFT_MASK = 1;
    public static final int ALL_MASK = 15;
    private static final int LED_WIDTH = 13;
    private static final int LED_HEIGHT = 13;
    private static final Color LED_COLOR_RED = Color.red.darker();
    private static final Color LED_COLOR_GREEN = Color.green.darker();
    private static final Color LED_COLOR_YELLOW = Color.yellow.darker();
    private VJButton btnView = null;
    private JPanel btnFiller = null;

    public VButton(String text) {
        this(text, (Icon)null, null, null);
    }

    public VButton(ActionTarget at) {
        this(at.getTitle(), at.getListener(), at.getCommand());
    }

    public VButton(String text, ActionListener al) {
        this(text, (Icon)null, al, text);
    }

    public VButton(String text, ActionListener al, String actionCmd) {
        this(text, (Icon)null, al, actionCmd);
    }

    public VButton(Icon icon, ActionListener al, String actionCmd) {
        this(null, icon, al, actionCmd);
    }

    public VButton(String text, Icon icon, ActionListener al) {
        this(text, icon, al, text);
    }

    public VButton(String text, Icon icon, ActionListener al, String actionCmd) {
        super(null, null, false);
        this.btnView = new VJButton(text, icon, null, actionCmd);
        if (al != null) {
            this.addActionListener(al);
        }
        super.setComponentListeners(this.btnView);
        this.setGBCX(0.5, 0, 1, 0, 0);
        this.setGBCY(0.5, 0, 1, 0, 0);
        this.add((Component)this.btnView, this.getDefaultGBC());
    }

    public VButton(Color ledColor) {
        this(null, ledColor, null, null);
    }

    public VButton(String text, Color ledColor) {
        this(text, ledColor, null, null);
    }

    public VButton(Color ledColor, ActionListener al, String actionCmd) {
        this(null, ledColor, al, actionCmd);
    }

    public VButton(String text, Color ledColor, ActionListener al, String actionCmd) {
        super(null, text, false);
        this.btnView = new VJButton(null, null, null, actionCmd);
        this.btnView.setLedColor(ledColor, false);
        if (al != null) {
            this.addActionListener(al);
        }
        super.setComponentListeners(this.btnView);
        this.setGBCX(0.0, 0, 1, 0, 0);
        this.setGBCY(0.0, 0, 1, 0, 0);
        this.add((Component)this.btnView, this.getDefaultGBC());
    }

    public JButton getJButton() {
        return this.btnView;
    }

    @Override
    public Border getBorder() {
        return super.getBorder();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(null);
    }

    public void setButtonBorder(Border border) {
        JButton jbtn = this.getJButton();
        if (jbtn != null) {
            jbtn.setBorder(border);
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
    }

    public int getMnemonic() {
        JButton jbtn = this.getJButton();
        return jbtn.getMnemonic();
    }

    public void setMnemonic(int mnemonic) {
        JButton jbtn = this.getJButton();
        jbtn.setMnemonic(mnemonic);
    }

    public Icon getIcon() {
        JButton jbtn = this.getJButton();
        return jbtn != null ? jbtn.getIcon() : null;
    }

    public void setIcon(Icon icon) {
        JButton jbtn = this.getJButton();
        if (jbtn != null) {
            jbtn.setIcon(icon);
        }
    }

    public void setBackgroundIcon(Icon icon) {
        this.setBackgroundIcon(icon, false);
    }

    public void setBackgroundIcon(Icon icon, boolean drawBorder) {
        JButton btn = this.getJButton();
        if (btn instanceof VJButton) {
            ((VJButton)btn).setBackgroundIcon(icon, drawBorder);
        }
    }

    public void setLedColor(Color color) {
        this.setLedColor(color, false);
    }

    public void setLedColor(Color color, boolean drawBorder) {
        JButton btn = this.getJButton();
        if (btn instanceof VJButton) {
            ((VJButton)btn).setLedColor(color, drawBorder);
        }
    }

    @Override
    public void setText(String text) {
        this.btnView.setText(text);
    }

    @Override
    public String getText() {
        return this.btnView.getText();
    }

    public void setHorizontalAlignment(int align) {
        this.btnView.setHorizontalAlignment(align);
    }

    public void setHorizontalTextPosition(int textPos) {
        this.btnView.setHorizontalTextPosition(textPos);
    }

    @Override
    public void setToolTipText(String text) {
        JButton jbtn = this.getJButton();
        if (jbtn != null) {
            jbtn.setToolTipText(text);
        }
    }

    @Override
    public void setActionCommand(String cmd) {
        super.setActionCommand(cmd);
        this.getJButton().setActionCommand(cmd);
    }

    public void setDeBounceTime(int timeMillis) {
        this.btnView.setDeBounceTime(timeMillis);
    }

    public int getDeBounceTime() {
        return this.btnView.getDeBounceTime();
    }

    protected void startDeBounce() {
        this.btnView.startDeBounce();
    }

    public void setMargin(Insets insets) {
        this.btnView.setMargin(insets);
    }

    public Insets getMargin() {
        return this.btnView.getMargin();
    }

    public void setActionCommand(String cmd, int mask) {
        this.btnView.setActionCommand(cmd, mask);
    }

    @Override
    public String getActionCommand() {
        return this.btnView.getActionCommand();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JButton btn = this.getJButton();
        if (btn instanceof VJButton) {
            ((VJButton)btn).actionPerformed(ae);
        } else {
            Print.logError((String)("Button is not a 'VJButton': " + StringTools.className((Object)btn)), (Object[])new Object[0]);
        }
    }

    public static boolean setActionEnabled(AbstractButton item, String ac, boolean enable) {
        boolean found = false;
        if (ac.equals(item.getActionCommand())) {
            item.setEnabled(enable);
            found = true;
        }
        if (item instanceof JMenu) {
            Component[] mc = ((JMenu)item).getMenuComponents();
            for (int i = 0; i < mc.length; ++i) {
                if (!(mc[i] instanceof AbstractButton) || !VButton.setActionEnabled((AbstractButton)mc[i], ac, enable)) continue;
                found = true;
            }
        }
        return found;
    }

    @Override
    protected void readOnlyStateChanged(boolean readOnly) {
        boolean R = readOnly || this._isReadOnly();
        boolean E = this.isEnabled();
        this.btnView.setEnabled(!R && E);
    }

    @Override
    protected void enabledStateChanged(boolean enabled) {
        if (this.btnView != null) {
            boolean R = this.isReadOnly();
            boolean E = enabled && this._isEnabled();
            this.btnView.setEnabled(E && !R);
        }
    }

    public void addFiller() {
        if (this.btnFiller == null) {
            this.btnFiller = new JPanel();
            this.btnFiller.setOpaque(false);
            this.setGBCX(0.5, -1, 1);
            this.setGBCY(0.0, 0, 1);
            this.add((Component)this.btnFiller, this.getDefaultGBC());
            GridBagLayout gbl = this.getContainerLayout();
            GridBagConstraints gbc = gbl.getConstraints(this.btnView);
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.anchor = 17;
            gbl.setConstraints(this.btnView, gbc);
        }
    }

    protected static class VButtonModel
    extends DefaultButtonModel {
        private HashMap<Integer, String> modActionCmds = null;

        @Override
        public String getActionCommand() {
            if (this.modActionCmds != null) {
                Integer key;
                String actionCmd;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                int modifiers = 0;
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiers() & 0xF;
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers() & 0xF;
                }
                if (modifiers != 0 && (actionCmd = this.modActionCmds.get(key = new Integer(modifiers))) != null) {
                    return actionCmd;
                }
            }
            return super.getActionCommand();
        }

        public void setActionCommand(String cmd, int mask) {
            if ((mask &= 0xF) != 0) {
                if (this.modActionCmds == null) {
                    this.modActionCmds = new HashMap();
                }
                this.modActionCmds.put(new Integer(mask), cmd != null ? cmd : "");
            } else {
                super.setActionCommand(cmd);
            }
        }
    }

    public static class VJButton
    extends JButton {
        private int deBounceTime = -1;
        private boolean deBounceActive = false;
        private boolean deBounceEnable = true;
        private ActionListener deBounceTask = null;
        private Icon backgroundIcon = null;
        private Color ledColor = null;
        private Dimension prefSize = null;

        public VJButton(String text, ActionListener al, String actionCmd) {
            this(text, null, al, actionCmd);
        }

        public VJButton(Icon icon, ActionListener al, String actionCmd) {
            this(null, icon, al, actionCmd);
        }

        public VJButton(String text, Icon icon, ActionListener al, String actionCmd) {
            super(text);
            this.setActionCommand(actionCmd != null ? actionCmd : text);
            if (icon != null) {
                this.setIcon(icon);
            }
            if (al != null) {
                this.addActionListener(al);
            }
        }

        @Override
        public void setText(String text) {
            if (text == null) {
                super.setText("");
            } else if (text.indexOf("\n") >= 0) {
                String htmlText = "<html><center>" + StringTools.htmlFilterText((Object)text) + "</center></html>";
                super.setText(htmlText);
            } else {
                super.setText(text);
            }
        }

        @Override
        public void setEnabled(boolean flag) {
            if (this.deBounceActive) {
                this.deBounceEnable = flag;
            } else {
                super.setEnabled(flag);
            }
        }

        public void setActionCommand(String cmd, int mask) {
            ButtonModel model = this.getModel();
            if (model instanceof VButtonModel) {
                ((VButtonModel)model).setActionCommand(cmd, mask);
            } else {
                Print.logStackTrace((String)"getModel() is not an instance of VButtonModel");
            }
        }

        @Override
        protected void fireActionPerformed(ActionEvent ae) {
            super.fireActionPerformed(ae);
            if (this.deBounceTime > 0) {
                this.startDeBounce();
            }
        }

        public void actionPerformed(ActionEvent ae) {
            this.doClick();
        }

        public void setDeBounceTime(int timeMillis) {
            this.deBounceTime = timeMillis;
        }

        public int getDeBounceTime() {
            return this.deBounceTime;
        }

        protected void startDeBounce() {
            if (this.deBounceTime > 0 && !this.deBounceActive) {
                this.deBounceEnable = this.isEnabled();
                this.setEnabled(false);
                this.deBounceActive = true;
                if (this.deBounceTask == null) {
                    this.deBounceTask = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            VJButton.this.deBounceActive = false;
                            VJButton.this.setEnabled(VJButton.this.deBounceEnable);
                        }
                    };
                }
                Timer debounce = new Timer(this.deBounceTime, this.deBounceTask);
                debounce.setRepeats(false);
                debounce.start();
            }
        }

        @Override
        public void setModel(ButtonModel newModel) {
            super.setModel(new VButtonModel());
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.prefSize != null) {
                return this.prefSize;
            }
            return super.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            if (this.prefSize != null) {
                return this.prefSize;
            }
            return super.getMinimumSize();
        }

        public void setLedColor(Color color, boolean drawBorder) {
            if (color != null) {
                this.ledColor = color;
                this.prefSize = new Dimension(14, 14);
                this.setContentAreaFilled(false);
                this.setBorderPainted(drawBorder);
            } else {
                this.ledColor = null;
                this.prefSize = null;
            }
        }

        public void setBackgroundIcon(Icon icon, boolean drawBorder) {
            if (icon != null) {
                this.backgroundIcon = icon;
                this.prefSize = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                this.setContentAreaFilled(false);
                this.setBorderPainted(drawBorder);
            } else {
                this.backgroundIcon = null;
                this.prefSize = null;
            }
            this.invalidate();
            this.validate();
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.backgroundIcon != null) {
                this.backgroundIcon.paintIcon(this, g, 0, 0);
            } else if (this.ledColor != null) {
                Color oldColor = g.getColor();
                g.setColor(this.ledColor);
                g.translate(1, 1);
                g.fillOval(0, 0, 13, 13);
                g.translate(-1, -1);
                g.setColor(oldColor);
            }
            super.paintComponent(g);
        }
    }
}

