/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opengts.opt.ui.ActionTarget;
import org.opengts.opt.ui.VDialog;
import org.opengts.opt.ui.VFrame;
import org.opengts.opt.ui.VTextField;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class VBox
extends JPanel {
    public static final int FONT_SIZE = 11;
    public static final Font FONT_DIALOG_PLAIN = VBox.FONT_DIALOG_PLAIN(11);
    public static final Font FONT_SERIF_PLAIN = VBox.FONT_SERIF_PLAIN(11);
    public static final Font FONT_SANSERIF_PLAIN = VBox.FONT_SANSERIF_PLAIN(11);
    public static final Font FONT_MONOSPACED_PLAIN = VBox.FONT_MONOSPACED_PLAIN(11);
    public static final Font FONT_DIALOG_ITALIC = VBox.FONT_DIALOG_ITALIC(11);
    public static final Font FONT_SERIF_ITALIC = VBox.FONT_SERIF_ITALIC(11);
    public static final Font FONT_SANSERIF_ITALIC = VBox.FONT_SANSERIF_ITALIC(11);
    public static final Font FONT_MONOSPACED_ITALIC = VBox.FONT_MONOSPACED_ITALIC(11);
    public static final Font FONT_DIALOG_BOLD = VBox.FONT_DIALOG_BOLD(11);
    public static final Font FONT_SERIF_BOLD = VBox.FONT_SERIF_BOLD(11);
    public static final Font FONT_SANSERIF_BOLD = VBox.FONT_SANSERIF_BOLD(11);
    public static final int LABEL_MARGIN = 4;
    public static final int LABEL_RIGHT = 4;
    public static final int LABEL_LEFT = 2;
    private static final int X_TITLE = 0;
    private static final int Y_TITLE = 0;
    private static final int X_LABEL_LEFT = 0;
    private static final int X_CONTAINER = 1;
    private static final int X_LABEL_RIGHT = 2;
    private static final int X_STATUS = 0;
    public static final int RELATIVE = -1;
    public static final Color TITLE_ENABLED_COLOR = Color.black;
    public static final Color TITLE_DISABLED_COLOR = Color.gray;
    public static final Color BORDER_ENABLED_COLOR = Color.gray;
    public static final Color BORDER_DISABLED_COLOR = Color.lightGray;
    public static final Color LABEL_ENABLED_COLOR = Color.black;
    public static final Color LABEL_DISABLED_COLOR = Color.gray;
    private Color titleEnabledColor = TITLE_ENABLED_COLOR;
    private Color titleDisabledColor = TITLE_DISABLED_COLOR;
    private Color borderEnabledColor = BORDER_ENABLED_COLOR;
    private Color borderDisabledColor = BORDER_DISABLED_COLOR;
    private Color labelEnabledColor = LABEL_ENABLED_COLOR;
    private Color labelDisabledColor = LABEL_DISABLED_COLOR;
    private Object titleField = null;
    private JLabel labelField = null;
    private JPanel container = null;
    private JPanel statusArea = null;
    private MarginBorder marginBorder = null;
    private Dimension preferredSize = null;
    private Dimension minimumSize = null;
    private Dimension maximumSize = null;
    private int labelX = 0;
    private int containerX = 1;
    private int containerY = 0;
    private GridBagConstraints defaultGBC = null;
    private Stack<GridBagConstraints> gbcStack = null;
    private String actionCmd = null;
    private Vector<ActionListener> actionListeners = null;
    private FocusListener compFocusListener = null;
    private ActionListener compActionListener = null;
    private Map<String, Object> attributeMap = null;
    private int fireActionEnabled = 0;
    private boolean isDirty = false;
    private boolean isReadOnly = false;
    private boolean traceReadOnlyChange = false;
    private boolean isEnabled = true;
    private HierarchyListener hierarchyListener = null;
    private Container lastHierarchyParent = null;
    private int addToBox = 0;
    private static final String PROP_focusLostEventsOk = "focusLostEventsOk";

    public static final Font FONT_DIALOG_PLAIN(int p) {
        return new Font("Dialog", 0, p);
    }

    public static final Font FONT_SERIF_PLAIN(int p) {
        return new Font("Serif", 0, p);
    }

    public static final Font FONT_SANSERIF_PLAIN(int p) {
        return new Font("SanSerif", 0, p);
    }

    public static final Font FONT_MONOSPACED_PLAIN(int p) {
        return new Font("Monospaced", 0, p);
    }

    public static final Font FONT_DIALOG_ITALIC(int p) {
        return new Font("Dialog", 2, p);
    }

    public static final Font FONT_SERIF_ITALIC(int p) {
        return new Font("Serif", 2, p);
    }

    public static final Font FONT_SANSERIF_ITALIC(int p) {
        return new Font("SanSerif", 2, p);
    }

    public static final Font FONT_MONOSPACED_ITALIC(int p) {
        return new Font("Monospaced", 2, p);
    }

    public static final Font FONT_DIALOG_BOLD(int p) {
        return new Font("Dialog", 1, p);
    }

    public static final Font FONT_SERIF_BOLD(int p) {
        return new Font("Serif", 1, p);
    }

    public static final Font FONT_SANSERIF_BOLD(int p) {
        return new Font("SanSerif", 1, p);
    }

    public static void initFonts() {
        Font dialogPlain = FONT_DIALOG_PLAIN;
        Font serifPlain = FONT_SERIF_PLAIN;
        Font sanSerifPlain = FONT_SANSERIF_PLAIN;
        Font monoPlain = FONT_MONOSPACED_PLAIN;
        UIManager.getDefaults().put("Button.font", dialogPlain);
        UIManager.getDefaults().put("ComboBox.font", dialogPlain);
        UIManager.getDefaults().put("OptionPane.font", dialogPlain);
        UIManager.getDefaults().put("RadioButton.font", dialogPlain);
        UIManager.getDefaults().put("List.font", dialogPlain);
        UIManager.getDefaults().put("Label.font", dialogPlain);
        UIManager.getDefaults().put("MenuBar.font", dialogPlain);
        UIManager.getDefaults().put("ToolBar.font", dialogPlain);
        UIManager.getDefaults().put("TitledBorder.font", dialogPlain);
        UIManager.getDefaults().put("TextArea.font", dialogPlain);
        UIManager.getDefaults().put("TextField.font", dialogPlain);
        UIManager.getDefaults().put("FormattedTextField.font", dialogPlain);
        UIManager.getDefaults().put("PasswordField.font", dialogPlain);
        UIManager.getDefaults().put("Table.font", dialogPlain);
        UIManager.getDefaults().put("TableHeader.font", dialogPlain);
    }

    public VBox() {
        this(null, null, false);
    }

    public VBox(String title, String label, boolean bordered) {
        super(new VBoxLayout());
        GridBagConstraints gbc = VBox.NewGBC();
        this.marginBorder = new MarginBorder();
        if (bordered) {
            VBoxLineBorder lb = new VBoxLineBorder(this.borderEnabledColor);
            TitledBorder tb = new TitledBorder(lb, title != null ? title : "");
            this.setBorder(new CompoundBorder(tb, this.marginBorder));
            this.titleField = tb;
            this.containerY = 0;
        } else {
            this.setBorder(this.marginBorder);
            if (title != null) {
                JLabel labelTitle = new JLabel(title);
                VBox.SetGBCX(gbc, 0.5, 0, 2);
                VBox.SetGBCY(gbc, 0.0, 0, 1);
                this._add(labelTitle, gbc);
                this.titleField = labelTitle;
                this.containerY = 1;
            }
        }
        this.containerX = 1;
        BoxContainer panel = new BoxContainer();
        VBox.SetGBCX(gbc, 0.5, this.containerX, 1, 0, 0);
        VBox.SetGBCY(gbc, 0.5, this.containerY, 1, 0, 0);
        this._add(panel, gbc);
        this.container = panel;
        this.setLabel(label);
        this.setEnabled(true);
    }

    protected void resetContainerWeight(double wx, double wy) {
        VBoxLayout gbl = (VBoxLayout)this.getLayout();
        GridBagConstraints gbc = (GridBagConstraints)gbl.getConstraints(this.container).clone();
        VBox.SetGBCX(gbc, wx);
        VBox.SetGBCY(gbc, wy);
        gbl.setConstraints(this.container, gbc);
    }

    protected void setParentListenerEnabled(boolean enable) {
        if (enable) {
            if (this.hierarchyListener == null) {
                this.hierarchyListener = new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent he) {
                        if (he.getID() == 1400) {
                            if ((he.getChangeFlags() & 1L) != 0L) {
                                Container oldParent = VBox.this.lastHierarchyParent;
                                Container newParent = VBox.this.getParent();
                                VBox.this.lastHierarchyParent = newParent;
                                VBox.this.parentChanged(oldParent, newParent);
                            }
                        } else {
                            Print.logWarn((String)("Unexpected HierarchyEvent: " + he.getID()), (Object[])new Object[0]);
                        }
                    }
                };
                this.lastHierarchyParent = this.getParent();
                this.addHierarchyListener(this.hierarchyListener);
            }
        } else if (this.hierarchyListener != null) {
            this.removeHierarchyListener(this.hierarchyListener);
            this.hierarchyListener = null;
            this.lastHierarchyParent = null;
        }
    }

    protected void parentChanged(Container oldParent, Container newParent) {
    }

    private Map<String, Object> getAttrMap() {
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap<String, Object>();
        }
        return this.attributeMap;
    }

    public void setAttribute(String key, Object val) {
        if (key != null) {
            if (val != null) {
                this.getAttrMap().put(key, val);
            } else {
                this.getAttrMap().remove(key);
            }
        }
    }

    public Object getAttribute(String key) {
        return this.getAttribute(key, null);
    }

    public Object getAttribute(String key, Object dftValue) {
        if (key != null) {
            Object obj = this.getAttrMap().get(key);
            if (obj != null) {
                return obj;
            }
            for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof VBox) {
                    return ((VBox)parent).getAttribute(key, dftValue);
                }
                if (parent instanceof VFrame) {
                    return ((VFrame)parent).getAttribute(key, dftValue);
                }
                if (!(parent instanceof VDialog)) continue;
                return ((VDialog)parent).getAttribute(key, dftValue);
            }
        }
        return dftValue;
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.marginBorder.setBorderInsets(top, left, bottom, right);
    }

    public void setInsets(Insets insets) {
        this.marginBorder.setBorderInsets(insets);
    }

    public JPanel getContainerArea() {
        return this.container;
    }

    public GridBagLayout getContainerLayout() {
        return (GridBagLayout)this.container.getLayout();
    }

    @Override
    public boolean isPreferredSizeSet() {
        return this.preferredSize != null || super.isPreferredSizeSet();
    }

    private Dimension _getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension(-1, -1);
        }
        return this.preferredSize;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            if (this.preferredSize.width >= 0 && this.preferredSize.height >= 0) {
                return this.preferredSize;
            }
            Dimension size = super.getPreferredSize();
            Dimension ps = new Dimension(this.preferredSize);
            if (ps.width < 0) {
                ps.width = size.width;
            }
            if (ps.height < 0) {
                ps.height = size.height;
            }
            return ps;
        }
        return super.getPreferredSize();
    }

    @Override
    public void setPreferredSize(Dimension ps) {
        super.setPreferredSize(ps);
        this.setPreferredWidth(ps != null ? ps.width : -1);
        this.setPreferredHeight(ps != null ? ps.height : -1);
    }

    public void setPreferredWidth(int w) {
        this._getPreferredSize().width = w;
        if (w < this.getMinimumSize().width) {
            this.setMinimumWidth(w);
        }
    }

    public void setPreferredHeight(int h) {
        this._getPreferredSize().height = h;
        if (h < this.getMinimumSize().height) {
            this.setMinimumHeight(h);
        }
    }

    @Override
    public boolean isMinimumSizeSet() {
        return this.minimumSize != null || super.isMinimumSizeSet();
    }

    private Dimension _getMinimumSize() {
        if (this.minimumSize == null) {
            this.minimumSize = new Dimension(-1, -1);
        }
        return this.minimumSize;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension minSize = super.getMinimumSize();
        if (this.minimumSize != null) {
            Dimension ms = new Dimension(this.minimumSize);
            if (ms.width < 0) {
                ms.width = minSize.width;
            }
            if (ms.height < 0) {
                ms.height = minSize.height;
            }
            minSize = ms;
        }
        Dimension prefSize = this.getPreferredSize();
        if (prefSize.height < minSize.height) {
            this.setMinimumHeight(prefSize.height);
            minSize.height = prefSize.height;
        }
        if (prefSize.width < minSize.width) {
            this.setMinimumWidth(prefSize.width);
            minSize.width = prefSize.width;
        }
        return minSize;
    }

    @Override
    public void setMinimumSize(Dimension ms) {
        this.minimumSize = ms;
    }

    public void setMinimumWidth(int w) {
        if (this.minimumSize == null) {
            this.minimumSize = new Dimension(-1, -1);
        }
        this.minimumSize.width = w;
    }

    public void setMinimumHeight(int h) {
        if (this.minimumSize == null) {
            this.minimumSize = new Dimension(-1, -1);
        }
        this.minimumSize.height = h;
    }

    @Override
    public boolean isMaximumSizeSet() {
        return this.maximumSize != null || super.isMaximumSizeSet();
    }

    private Dimension _getMaximumSize() {
        if (this.maximumSize == null) {
            this.maximumSize = new Dimension(-1, -1);
        }
        return this.maximumSize;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension maxSize = super.getMaximumSize();
        if (this.maximumSize != null) {
            Dimension ms = new Dimension(this.maximumSize);
            if (ms.width < 0) {
                ms.width = maxSize.width;
            }
            if (ms.height < 0) {
                ms.height = maxSize.height;
            }
            maxSize = ms;
        }
        Dimension prefSize = this.getPreferredSize();
        if (prefSize.height > maxSize.height) {
            this.setMaximumHeight(prefSize.height);
            maxSize.height = prefSize.height;
        }
        if (prefSize.width > maxSize.width) {
            this.setMaximumWidth(prefSize.width);
            maxSize.width = prefSize.width;
        }
        return maxSize;
    }

    @Override
    public void setMaximumSize(Dimension ms) {
        this.maximumSize = ms;
    }

    public void setMaximumSize(int w, int h) {
        this.setMaximumWidth(w);
        this.setMaximumHeight(h);
    }

    public void setMaximumWidth(int w) {
        if (this.maximumSize == null) {
            this.maximumSize = new Dimension(-1, -1);
        }
        this.maximumSize.width = w;
    }

    public void setMaximumHeight(int h) {
        if (this.maximumSize == null) {
            this.maximumSize = new Dimension(-1, -1);
        }
        this.maximumSize.height = h;
    }

    protected int getLabelAnchor() {
        return 18;
    }

    protected int getLabelPosition() {
        return 2;
    }

    public void setLabel(String text) {
        this.setLabel(text, 4);
    }

    public void setLabel(String text, boolean onLeft) {
        this.setLabel(text, 4, onLeft);
    }

    public void setLabel(String text, int margin) {
        this.setLabel(text, margin, this.getLabelPosition() == 2);
    }

    public void setLabel(String text, int margin, boolean onLeft) {
        if (text != null) {
            if (this.labelField == null) {
                this.labelField = new JLabel("label");
                this.labelField.setOpaque(false);
                GridBagConstraints gbc = VBox.NewGBC();
                if (onLeft) {
                    this.labelField.setHorizontalAlignment(4);
                    gbc.anchor = this.getLabelAnchor();
                    this.labelX = 0;
                    VBox.SetGBCX(gbc, 0.0, this.labelX, 1, 0, margin);
                    VBox.SetGBCY(gbc, 0.0, this.containerY, 1, 0, 0);
                } else {
                    this.labelField.setHorizontalAlignment(2);
                    gbc.anchor = 18;
                    this.labelX = 2;
                    VBox.SetGBCX(gbc, 0.5, this.labelX, 1, margin, 0);
                    VBox.SetGBCY(gbc, 0.0, this.containerY, 1, 0, 0);
                    this.resetContainerWeight(0.0, 0.5);
                }
                this._add(this.labelField, gbc);
            } else {
                this.labelField.setVisible(true);
            }
            this.labelField.setText(text);
        } else if (this.labelField != null) {
            this.labelField.setVisible(false);
        }
    }

    public String getLabel() {
        return this.labelField != null ? this.labelField.getText() : null;
    }

    public void setLabelColors(Color enabled, Color disabled) {
        if (enabled != null) {
            this.labelEnabledColor = enabled;
        }
        if (disabled != null) {
            this.labelDisabledColor = disabled;
        }
    }

    public JPanel getStatusArea() {
        if (this.statusArea == null) {
            this.statusArea = new JPanel(new VBoxLayout());
            this.statusArea.setOpaque(false);
            GridBagConstraints gbc = VBox.NewGBC();
            VBox.SetGBCX(gbc, 0.5, 0, 2, 0, 0);
            VBox.SetGBCY(gbc, 0.0, this.containerY + 1, 1, 5, 0);
            this._add(this.statusArea, gbc);
        }
        return this.statusArea;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        return super.getToolTipText();
    }

    @Override
    public String getToolTipText(MouseEvent me) {
        return super.getToolTipText(me);
    }

    private void _add(Component comp, GridBagConstraints gbc) {
        ++this.addToBox;
        this.add(comp, gbc);
        --this.addToBox;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp != null) {
            if (this instanceof VTextField && StringTools.className((Object)comp).equals("javax.swing.JPanel")) {
                Print.logStackTrace((String)"Adding JPanel");
            }
            if (this.addToBox == 0 && this.container != null) {
                this.container.add(comp, constraints, index);
            } else {
                super.addImpl(comp, constraints, index);
            }
        } else {
            Print.logStackTrace((String)"Component is 'null'!");
        }
    }

    public void setTitle(String title) {
        String t;
        String string = t = title != null ? title : "";
        if (this.titleField instanceof JLabel) {
            ((JLabel)this.titleField).setText(t);
        } else if (this.titleField instanceof TitledBorder) {
            ((TitledBorder)this.titleField).setTitle(t);
            this.repaint();
        }
    }

    public String getTitle() {
        if (this.titleField instanceof JLabel) {
            return ((JLabel)this.titleField).getText();
        }
        if (this.titleField instanceof TitledBorder) {
            return ((TitledBorder)this.titleField).getTitle();
        }
        return "";
    }

    public void setTitleColor(Color titleColor) {
        if (this.titleField instanceof JLabel) {
            ((JLabel)this.titleField).setForeground(titleColor);
        } else if (this.titleField instanceof TitledBorder) {
            ((TitledBorder)this.titleField).setTitleColor(titleColor);
        }
    }

    public void setTitleColors(Color enabled, Color disabled) {
        if (enabled != null) {
            this.titleEnabledColor = enabled;
        }
        if (disabled != null) {
            this.titleDisabledColor = disabled;
        }
    }

    public void setBorderColors(Color enabled, Color disabled) {
        if (enabled != null) {
            this.borderEnabledColor = enabled;
        }
        if (disabled != null) {
            this.borderDisabledColor = disabled;
        }
    }

    public void setText(String text) {
        this.setValue(text);
    }

    public String getText() {
        Object val = this.getValue();
        return val != null ? val.toString() : "";
    }

    public void setValue(Object obj) {
    }

    public Object getValue() {
        return null;
    }

    public void selectItemAt(Point p) {
    }

    public void refresh() {
    }

    private static void _fireReadOnlyStateChanged(Component comp, boolean readOnly) {
        if (comp instanceof VBox) {
            if (((VBox)comp).getTraceReadOnlyStateChange()) {
                Print.logStackTrace((String)("ReadOnly state changed [" + StringTools.className((Object)comp) + "] ==> " + readOnly));
            }
            ((VBox)comp).readOnlyStateChanged(readOnly);
        }
        if (comp instanceof Container) {
            Component[] c = ((Container)comp).getComponents();
            for (int i = 0; i < c.length; ++i) {
                VBox._fireReadOnlyStateChanged(c[i], readOnly);
            }
        }
    }

    protected void readOnlyStateChanged(boolean readOnly) {
    }

    public void setReadOnly(boolean flag) {
        if (this.isReadOnly != flag) {
            this.isReadOnly = flag;
            VBox._fireReadOnlyStateChanged(this, this.isReadOnly);
        }
    }

    public boolean _isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isReadOnly() {
        if (this._isReadOnly()) {
            return true;
        }
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof VBox)) continue;
            return ((VBox)parent).isReadOnly();
        }
        return false;
    }

    public void setTraceReadOnlyStateChange(boolean trace) {
        this.traceReadOnlyChange = trace;
    }

    public boolean getTraceReadOnlyStateChange() {
        return this.traceReadOnlyChange;
    }

    private static void _fireEnabledStateChanged(Component comp, boolean enabled) {
        if (comp instanceof VBox) {
            ((VBox)comp).enabledStateChanged(enabled);
        }
        if (comp instanceof Container) {
            Component[] c = ((Container)comp).getComponents();
            for (int i = 0; i < c.length; ++i) {
                VBox._fireEnabledStateChanged(c[i], enabled);
            }
        }
    }

    protected void enabledStateChanged(boolean enabled) {
    }

    @Override
    public void setEnabled(boolean flag) {
        Color labelColor;
        this.isEnabled = flag;
        Color titleColor = this.isEnabled ? this.titleEnabledColor : this.titleDisabledColor;
        Color borderColor = this.isEnabled ? this.borderEnabledColor : this.borderDisabledColor;
        Color color = labelColor = this.isEnabled ? this.labelEnabledColor : this.labelDisabledColor;
        if (this.titleField instanceof JLabel) {
            ((JLabel)this.titleField).setForeground(titleColor);
        } else if (this.titleField instanceof TitledBorder) {
            TitledBorder tb = (TitledBorder)this.titleField;
            tb.setTitleColor(titleColor);
            Border b = tb.getBorder();
            if (b instanceof VBoxLineBorder) {
                ((VBoxLineBorder)b).setLineColor(borderColor);
            }
        }
        if (this.labelField != null) {
            this.labelField.setForeground(labelColor);
        }
        VBox._fireEnabledStateChanged(this, this.isEnabled);
    }

    protected boolean _isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isEnabled() {
        if (!this._isEnabled()) {
            return false;
        }
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof VBox)) continue;
            return ((VBox)parent).isEnabled();
        }
        return true;
    }

    private static boolean _isDirty(Component comp) {
        if (comp instanceof VBox && ((VBox)comp).isDirty) {
            return true;
        }
        if (comp instanceof Container) {
            Component[] c = ((Container)comp).getComponents();
            for (int i = 0; i < c.length; ++i) {
                if (!VBox._isDirty(c[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDirty() {
        return VBox._isDirty(this);
    }

    private static void _clearDirty(Component comp) {
        if (comp instanceof VBox && ((VBox)comp).isDirty) {
            ((VBox)comp).isDirty = false;
        }
        if (comp instanceof Container) {
            Component[] c = ((Container)comp).getComponents();
            for (int i = 0; i < c.length; ++i) {
                VBox._clearDirty(c[i]);
            }
        }
    }

    public void clearDirty() {
        VBox._clearDirty(this);
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public void setActionCommand(String cmd) {
        this.actionCmd = cmd;
    }

    public String getActionCommand() {
        return this.actionCmd;
    }

    protected List<ActionListener> getActionListeners() {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        return this.actionListeners;
    }

    public void addActionListener(ActionListener al) {
        this.addActionListener(al, true);
    }

    public void addActionListener(ActionListener al, boolean focusLostOk) {
        if (al != null) {
            ActionTarget at = new ActionTarget(al);
            at.setAttribute(PROP_focusLostEventsOk, focusLostOk ? "true" : null);
            this.getActionListeners().add(at);
        }
    }

    public void removeActionListener(ActionListener al) {
        if (al != null) {
            Iterator<ActionListener> i = this.getActionListeners().iterator();
            while (i.hasNext()) {
                ActionTarget at = (ActionTarget)i.next();
                if (!at.getListener().equals(al)) continue;
                i.remove();
            }
        }
    }

    protected void setFireActionEnabled(boolean enable) {
        if (enable) {
            if (this.fireActionEnabled > 0) {
                --this.fireActionEnabled;
            }
        } else {
            ++this.fireActionEnabled;
        }
    }

    protected void resetFireActionEnabled() {
        this.fireActionEnabled = 0;
    }

    protected boolean isFireActionEnabled() {
        return this.fireActionEnabled <= 0;
    }

    protected ActionListener createFireActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VBox.this.fireAction();
            }
        };
    }

    protected void fireAction() {
        this.fireAction(null, false);
    }

    protected void fireAction(String cmd) {
        this.fireAction(cmd, false);
    }

    protected void fireAction(String cmd, boolean isFocusLostEvent) {
        if (this.isFireActionEnabled()) {
            this.fireActionEvent(this.createActionEvent(this, cmd, isFocusLostEvent));
        }
    }

    protected void fireActionEvent(ActionEvent ae) {
        if (ae == null) {
            ae = this.createActionEvent(this, null, false);
        }
        List<ActionListener> list = this.getActionListeners();
        for (ActionListener at : list) {
            if (ae instanceof FocusActionEvent && (!(at instanceof ActionTarget) || !((ActionTarget)at).hasAttribute(PROP_focusLostEventsOk))) continue;
            at.actionPerformed(ae);
        }
    }

    protected ActionEvent createActionEvent(Object src, String cmd, boolean isFocusLost) {
        Object s = src != null ? src : this;
        String c = cmd != null ? cmd : this.getActionCommand();
        return isFocusLost ? new FocusActionEvent(src, c) : new ActionEvent(src, 1001, c);
    }

    protected void setComponentListeners(Component comp) {
        boolean needsFocusListener = false;
        if (this.compActionListener == null) {
            this.compActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    VBox.this.fireAction(null, false);
                }
            };
        }
        if (comp instanceof JTextField) {
            ((JTextField)comp).addActionListener(this.compActionListener);
            needsFocusListener = true;
        } else if (comp instanceof JTextArea) {
            needsFocusListener = true;
        } else if (comp instanceof AbstractButton) {
            ((AbstractButton)comp).addActionListener(this.compActionListener);
            needsFocusListener = false;
        } else if (comp instanceof JComboBox) {
            ((JComboBox)comp).addActionListener(this.compActionListener);
            needsFocusListener = false;
        } else if (comp instanceof JList) {
            needsFocusListener = false;
        } else if (comp instanceof JTable) {
            ListSelectionModel selModel = ((JTable)comp).getSelectionModel();
            selModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent lse) {
                    if (!lse.getValueIsAdjusting()) {
                        VBox.this.fireAction(null, false);
                    }
                }
            });
            needsFocusListener = false;
        } else if (comp instanceof JSpinner) {
            JSpinner spinner = (JSpinner)comp;
            spinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    VBox.this.fireAction(null, false);
                }
            });
            needsFocusListener = false;
        }
        if (needsFocusListener) {
            if (this.compFocusListener == null) {
                this.compFocusListener = new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent fe) {
                        if (fe.getSource() instanceof JFormattedTextField) {
                            // empty if block
                        }
                        VBox.this.fireAction(null, true);
                    }
                };
            }
            comp.addFocusListener(this.compFocusListener);
        }
    }

    public void setDefaultGBC(GridBagConstraints gbc) {
        this.defaultGBC = gbc;
    }

    public GridBagConstraints getDefaultGBC() {
        if (this.defaultGBC == null) {
            this.defaultGBC = VBox.NewGBC();
            VBox.SetGBCX(this.defaultGBC, 0.0, 0, 1);
            VBox.SetGBCY(this.defaultGBC, 0.0, 0, 1);
        }
        return this.defaultGBC;
    }

    public GridBagConstraints pushGBC() {
        if (this.gbcStack == null) {
            this.gbcStack = new Stack();
        }
        GridBagConstraints gbc = this.getDefaultGBC();
        this.gbcStack.push((GridBagConstraints)gbc.clone());
        return gbc;
    }

    public GridBagConstraints popGBC() {
        if (this.gbcStack != null && !this.gbcStack.empty()) {
            this.setDefaultGBC(this.gbcStack.pop());
        }
        return this.getDefaultGBC();
    }

    public void setGBCX(double weight) {
        VBox.SetGBCX(this.getDefaultGBC(), weight);
    }

    public void setGBCX(int left, int right) {
        VBox.SetGBCX(this.getDefaultGBC(), left, right);
    }

    public void setGBCX(double weight, int grid, int size) {
        VBox.SetGBCX(this.getDefaultGBC(), weight, grid, size);
    }

    public void setGBCX(double weight, int grid, int size, int left, int right) {
        VBox.SetGBCX(this.getDefaultGBC(), weight, grid, size, left, right);
    }

    public void setGBCY(double weight) {
        VBox.SetGBCY(this.getDefaultGBC(), weight);
    }

    public void setGBCY(int top, int bottom) {
        VBox.SetGBCY(this.getDefaultGBC(), top, bottom);
    }

    public void setGBCY(double weight, int grid, int size) {
        VBox.SetGBCY(this.getDefaultGBC(), weight, grid, size);
    }

    public void setGBCY(double weight, int grid, int size, int top, int bottom) {
        VBox.SetGBCY(this.getDefaultGBC(), weight, grid, size, top, bottom);
    }

    public static GridBagConstraints NewGBC() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 0, 0);
        VBox.SetGBCX(gbc, 0.0, 0, 1);
        VBox.SetGBCY(gbc, 0.0, 0, 1);
        return gbc;
    }

    public static GridBagConstraints CloneGBC(GridBagConstraints gbc) {
        if (gbc == null) {
            return VBox.NewGBC();
        }
        GridBagConstraints ngbc = (GridBagConstraints)gbc.clone();
        return ngbc;
    }

    public static GridBagConstraints CloneGBC(GridBagConstraints gbc, int anchor) {
        if (gbc == null) {
            return VBox.NewGBC();
        }
        GridBagConstraints ngbc = (GridBagConstraints)gbc.clone();
        ngbc.anchor = anchor;
        if (anchor == 10) {
            if (ngbc.fill == 0) {
                if (ngbc.weightx > 0.0 && ngbc.weighty > 0.0) {
                    Print.logInfo((String)"Center: set fill to BOTH", (Object[])new Object[0]);
                    ngbc.fill = 1;
                } else if (ngbc.weightx > 0.0) {
                    Print.logInfo((String)"Center: set fill to HORIZONTAL", (Object[])new Object[0]);
                    ngbc.fill = 2;
                } else if (ngbc.weighty > 0.0) {
                    Print.logInfo((String)"Center: set fill to VERTICAL", (Object[])new Object[0]);
                    ngbc.fill = 3;
                }
            } else {
                Print.logInfo((String)("Center: fill already defined - " + ngbc.fill), (Object[])new Object[0]);
            }
        }
        return ngbc;
    }

    public static GridBagConstraints CloneGBC(GridBagConstraints gbc, int anchor, int fill) {
        if (gbc == null) {
            return VBox.NewGBC();
        }
        GridBagConstraints ngbc = (GridBagConstraints)gbc.clone();
        ngbc.anchor = anchor;
        ngbc.fill = fill;
        return ngbc;
    }

    public static void SetGBCX(GridBagConstraints gbc, double weight) {
        gbc.weightx = weight;
        if (gbc.weightx > 0.0) {
            if (gbc.fill == 0) {
                gbc.fill = 2;
            } else if (gbc.fill == 3) {
                gbc.fill = 1;
            }
        } else if (gbc.fill == 2) {
            gbc.fill = 0;
        } else if (gbc.fill == 1) {
            gbc.fill = 3;
        }
    }

    public static void SetGBCX(GridBagConstraints gbc, int left, int right) {
        if (left >= 0) {
            gbc.insets.left = left;
        }
        if (right >= 0) {
            gbc.insets.right = right;
        }
    }

    public static void SetGBCX(GridBagConstraints gbc, double weight, int grid, int size) {
        VBox.SetGBCX(gbc, weight, grid, size, -1, -1);
    }

    public static void SetGBCX(GridBagConstraints gbc, double weight, int grid, int size, int left, int right) {
        VBox.SetGBCX(gbc, weight);
        VBox.SetGBCX(gbc, left, right);
        gbc.gridx = grid;
        gbc.gridwidth = size;
    }

    public static void SetGBCY(GridBagConstraints gbc, double weight) {
        gbc.weighty = weight;
        if (gbc.weighty > 0.0) {
            if (gbc.fill == 0) {
                gbc.fill = 3;
            } else if (gbc.fill == 2) {
                gbc.fill = 1;
            }
        } else if (gbc.fill == 3) {
            gbc.fill = 0;
        } else if (gbc.fill == 1) {
            gbc.fill = 2;
        }
    }

    public static void SetGBCY(GridBagConstraints gbc, int top, int bottom) {
        if (top >= 0) {
            gbc.insets.top = top;
        }
        if (bottom >= 0) {
            gbc.insets.bottom = bottom;
        }
    }

    public static void SetGBCY(GridBagConstraints gbc, double weight, int grid, int size) {
        VBox.SetGBCY(gbc, weight, grid, size, -1, -1);
    }

    public static void SetGBCY(GridBagConstraints gbc, double weight, int grid, int size, int top, int bottom) {
        VBox.SetGBCY(gbc, weight);
        VBox.SetGBCY(gbc, top, bottom);
        gbc.gridy = grid;
        gbc.gridheight = size;
    }

    public Component getAncestorOfClass(Class cls, Component c) {
        if (cls != null) {
            Component p;
            for (p = c; p != null && !cls.isInstance(p); p = p.getParent()) {
            }
            return p;
        }
        return null;
    }

    public static void printComponentHeirarchy(String msg, Component c) {
        Print.logInfo((String)msg, (Object[])new Object[0]);
        VBox._printComponentHeirarchy(c, 1);
    }

    private static void _printComponentHeirarchy(Component c, int level) {
        StringBuffer sb = new StringBuffer(StringTools.replicateString((String)"  ", (int)level));
        sb.append(StringTools.className((Object)c));
        Print.logInfo((String)sb.toString(), (Object[])new Object[0]);
        if (c instanceof Container) {
            Component[] cl = ((Container)c).getComponents();
            for (int i = 0; i < cl.length; ++i) {
                VBox._printComponentHeirarchy(cl[i], level + 1);
            }
        }
    }

    public static class VBoxLineBorder
    extends LineBorder {
        public VBoxLineBorder(Color color) {
            super(color);
        }

        public VBoxLineBorder(Color color, int thickness) {
            super(color, thickness);
        }

        public VBoxLineBorder(Color color, int thickness, boolean roundedCorners) {
            super(color, thickness, roundedCorners);
        }

        public void setLineColor(Color color) {
            this.lineColor = color;
        }

        @Override
        public Color getLineColor() {
            return super.getLineColor();
        }

        public void setRoundedCorners(boolean rc) {
            this.roundedCorners = rc;
        }

        @Override
        public boolean getRoundedCorners() {
            return super.getRoundedCorners();
        }
    }

    public static class MarginBorder
    extends EmptyBorder {
        public MarginBorder() {
            super(new Insets(0, 0, 0, 0));
        }

        public void setBorderInsets(int top, int left, int bottom, int right) {
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.left = left;
        }

        public void setBorderInsets(Insets insets) {
            this.setBorderInsets(insets.top, insets.left, insets.bottom, insets.right);
        }
    }

    protected class BoxContainer
    extends JPanel {
        public BoxContainer() {
            super(new VBoxLayout());
            this.setOpaque(false);
        }
    }

    protected static class VBoxLayout
    extends GridBagLayout {
        public void printPreferredLayout(Component c) {
            if (c instanceof Container) {
                Container p = (Container)c;
                Dimension d = super.preferredLayoutSize(p);
                int[][] lod = super.getLayoutDimensions();
                int[] rowHeight = lod[0];
                int[] colWidth = lod[1];
                int total = 0;
                for (int r = 0; r < rowHeight.length; ++r) {
                    total += rowHeight[r];
                    Print.logInfo((String)(r + "] " + rowHeight[r]), (Object[])new Object[0]);
                }
                Print.logInfo((String)("Total = " + total), (Object[])new Object[0]);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = super.preferredLayoutSize(parent);
            return d;
        }
    }

    protected static class FocusActionEvent
    extends ActionEvent {
        public FocusActionEvent(Object src, String cmd) {
            super(src, 1001, cmd);
        }
    }
}

