/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;
import javax.swing.JComponent;
import org.opengts.opt.ui.VBox;

public class VBarMeter
extends VBox {
    public static final int TICK_NONE = 0;
    public static final int TICK_RIGHT = 1;
    public static final int TICK_LEFT = 2;
    public static final Color COLOR_GREEN = new Color(0, 129, 0);
    public static final Color COLOR_YELLOW = new Color(255, 255, 0);
    public static final Color COLOR_RED = new Color(255, 8, 8);
    public static final Color COLOR_BACKGROUND = new Color(197, 194, 197);
    public static final Color COLOR_VALUE = Color.gray;
    public static final Color COLOR_NO_VALUE = new Color(220, 220, 220);
    private VMeterComponent meterView = null;
    private String vertTitle = null;
    private String[] labels = new String[0];
    private Color rangeGreen = COLOR_GREEN;
    private Color rangeYellow = COLOR_YELLOW;
    private Color rangeRed = COLOR_RED;
    private ColorRange[] colorRange = null;
    private int meterWidth = 23;
    private int lineWidth = 3;
    private int tickWidth = 2;
    private int tickPos = 1;
    private Font titleFont = VBox.FONT_DIALOG_BOLD(17);
    private Font labelFont = VBox.FONT_DIALOG_BOLD(14);
    private double value = 0.0;
    private Color valueColor = COLOR_VALUE;
    private Color noValueColor = COLOR_NO_VALUE;
    private double scaleLow = 0.0;
    private double scaleHigh = 100.0;
    private ScaleFtn scaleFtn = null;

    public VBarMeter() {
        this(null, null, false);
    }

    public VBarMeter(String title, String label, boolean bordered) {
        super(title, label, bordered);
        this.setBackground(COLOR_BACKGROUND);
        this.meterView = this.createComponent();
        super.setComponentListeners(this.meterView);
        this.setGBCX(0.5, 0, 1, 0, 0);
        this.setGBCY(0.5, 0, 1, 0, 0);
        this.add((Component)this.meterView, this.getDefaultGBC());
    }

    protected VMeterComponent createComponent() {
        return new VMeterComponent();
    }

    public double getMeterValue() {
        return this.value;
    }

    public void setMeterValue(double value) {
        this.value = value;
        this.repaint();
    }

    public void setValue(double value) {
        this.setMeterValue(value);
    }

    public void setValueColors(Color value, Color noValue) {
        this.valueColor = value != null ? value : COLOR_VALUE;
        this.noValueColor = noValue != null ? noValue : COLOR_NO_VALUE;
    }

    public void setScale(double low, double high, ScaleFtn scaleFtn) {
        this.scaleLow = low;
        this.scaleHigh = high;
        this.scaleFtn = scaleFtn;
    }

    public void setScale(double low, double high) {
        this.setScale(low, high, null);
    }

    public double scaleValue(double value) {
        double v = 0.0;
        v = this.scaleFtn != null ? this.scaleFtn.scale(value) : (value - this.scaleLow) / (this.scaleHigh - this.scaleLow);
        if (v < 0.0) {
            return 0.0;
        }
        if (v > 1.0) {
            return 1.0;
        }
        return v;
    }

    protected double getScaledValue() {
        return this.scaleValue(this.value);
    }

    public int getMeterWidth() {
        return this.meterWidth;
    }

    public void setMeterWidth(int width) {
        this.meterWidth = width > 5 ? width : 5;
    }

    public void setRangeColors(Color G, Color Y, Color R) {
        this.rangeGreen = G != null ? G : COLOR_GREEN;
        this.rangeYellow = Y != null ? Y : COLOR_YELLOW;
        this.rangeRed = R != null ? R : COLOR_RED;
    }

    protected ColorRange[] getColorRange() {
        if (this.colorRange == null) {
            this.colorRange = new ColorRange[]{new ColorRange(0.0, Color.black)};
        }
        return this.colorRange;
    }

    public void setScaledColorRange(double G, double Y, double R) {
        Vector<ColorRange> v = new Vector<ColorRange>();
        if (G >= 0.0 && G < 1.0) {
            v.add(new ColorRange(G, this.rangeGreen));
        }
        if (Y >= 0.0 && Y < 1.0) {
            v.add(new ColorRange(Y, this.rangeYellow));
        }
        if (R >= 0.0 && R < 1.0) {
            v.add(new ColorRange(R, this.rangeRed));
        }
        this.colorRange = v.toArray(new ColorRange[v.size()]);
        for (int i = 0; i < this.colorRange.length; ++i) {
            for (int j = i + 1; j < this.colorRange.length; ++j) {
                if (!(this.colorRange[j].getPercent() < this.colorRange[i].getPercent())) continue;
                ColorRange cr = this.colorRange[i];
                this.colorRange[i] = this.colorRange[j];
                this.colorRange[j] = cr;
            }
        }
    }

    public void setColorRange(double G, double Y, double R) {
        this.setScaledColorRange(this.scaleValue(G), this.scaleValue(Y), this.scaleValue(R));
    }

    protected boolean hasTitle() {
        return this.vertTitle != null && !this.vertTitle.equals("");
    }

    protected int getTitleWidth() {
        if (this.hasTitle()) {
            return this.titleFont.getSize() + 2;
        }
        return 0;
    }

    @Override
    public void setTitle(String title) {
        this.vertTitle = title;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    protected boolean hasLabels() {
        if (this.labels == null || this.labels.length == 0) {
            return false;
        }
        for (int i = 0; i < this.labels.length; ++i) {
            if (this.labels[i] == null || this.labels[i].equals("")) continue;
            return true;
        }
        return false;
    }

    protected int getLabelWidth() {
        if (this.labels == null || this.labels.length == 0) {
            return 0;
        }
        FontMetrics fm = super.getFontMetrics(this.labelFont);
        int w = 0;
        for (int i = 0; i < this.labels.length; ++i) {
            int lw;
            if (this.labels[i] == null || this.labels[i].equals("") || (lw = fm.stringWidth(this.labels[i])) <= w) continue;
            w = lw;
        }
        return w > 0 ? w + 4 : 0;
    }

    public void setLabels(String[] labels) {
        this.labels = labels != null ? labels : new String[]{};
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public int getLabelCount() {
        return this.labels != null ? this.labels.length : 0;
    }

    public void setTickPosition(int tickPos) {
        this.tickPos = tickPos;
    }

    public int getTickPosition() {
        return this.tickPos;
    }

    public void setTickWidth(int width) {
        this.tickWidth = width > 0 ? width : 1;
    }

    public int getTickWidth() {
        return this.tickWidth;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width > 0 ? width : 1;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        int w = this.meterWidth + this.lineWidth + this.getTitleWidth() + this.getLabelWidth();
        int h = -1;
        return new Dimension(w, h);
    }

    public class VMeterComponent
    extends JComponent {
        protected void paintMeter(Graphics g, int x, int y) {
            FontMetrics fm = g.getFontMetrics();
            int h = this.getHeight();
            int marginTop = 0;
            int marginBottom = 0;
            int marginLeft = VBarMeter.this.getTitleWidth();
            int marginRight = VBarMeter.this.getLabelWidth();
            ColorRange[] cr = VBarMeter.this.getColorRange();
            int meterX = x + marginLeft;
            int meterY = y + marginTop;
            int meterHeight = h - meterY - VBarMeter.this.lineWidth - marginBottom;
            int titleX = meterX - 5;
            int titleY = meterY + meterHeight;
            int tickLength = (int)Math.round((double)VBarMeter.this.meterWidth * 0.4);
            int majorTickCount = VBarMeter.this.getLabelCount();
            int totalTickCount = (majorTickCount - 1) * 5;
            g.translate(meterX, meterY);
            g.setColor(VBarMeter.this.noValueColor);
            g.fillRect(0, 0, VBarMeter.this.meterWidth, meterHeight);
            double plotValue = VBarMeter.this.getScaledValue();
            if (plotValue > 0.0) {
                int valueWidth = VBarMeter.this.meterWidth;
                int valueHeight = (int)Math.round(plotValue * (double)meterHeight);
                g.setColor(VBarMeter.this.valueColor);
                g.fillRect(VBarMeter.this.lineWidth, meterHeight - valueHeight, valueWidth, valueHeight);
            }
            g.setColor(cr[0].getColor());
            g.fillRect(0, meterHeight, VBarMeter.this.meterWidth + VBarMeter.this.lineWidth, VBarMeter.this.lineWidth);
            g.setColor(cr[cr.length - 1].getColor());
            g.fillRect(0, 0, VBarMeter.this.meterWidth, VBarMeter.this.lineWidth);
            int lastY = meterHeight + VBarMeter.this.lineWidth;
            for (int r = 0; r < cr.length; ++r) {
                g.setColor(cr[r].getColor());
                double pct = r < cr.length - 1 ? cr[r + 1].getPercent() : 1.0;
                int segY = meterHeight - (int)Math.round(pct * (double)meterHeight);
                int segH = lastY - segY;
                g.fillRect(0, segY, VBarMeter.this.lineWidth, segH);
                g.fillRect(VBarMeter.this.meterWidth, segY, VBarMeter.this.lineWidth, segH);
                lastY = segY;
            }
            int tickPos = VBarMeter.this.getTickPosition();
            boolean hasTicks = tickPos != 0;
            int r = 0;
            g.setFont(VBarMeter.this.labelFont);
            Color tickColor = Color.black;
            for (int i = 0; i <= totalTickCount; ++i) {
                int X;
                double pct = (double)i / (double)totalTickCount;
                while (r < cr.length && pct > cr[r].getPercent()) {
                    tickColor = cr[r++].getColor();
                }
                int Y = meterHeight - (int)Math.round(pct * (double)meterHeight);
                if (i % 5 == 0) {
                    int ndx;
                    X = VBarMeter.this.lineWidth;
                    if (hasTicks && i > 0 && i < totalTickCount) {
                        g.setColor(tickColor);
                        g.fillRect(X, Y, VBarMeter.this.meterWidth - VBarMeter.this.lineWidth, VBarMeter.this.tickWidth);
                    }
                    if ((ndx = i / 5) >= VBarMeter.this.labels.length || VBarMeter.this.labels[ndx] == null || VBarMeter.this.labels[ndx].equals("")) continue;
                    int lblWid = fm.stringWidth(VBarMeter.this.labels[ndx]);
                    int XX = VBarMeter.this.meterWidth + (marginRight - lblWid) / 2;
                    int YY = Y + 5;
                    if (ndx == 0) {
                        YY -= 4;
                    } else if (ndx == VBarMeter.this.labels.length - 1) {
                        YY += 6;
                    }
                    g.setColor(Color.black);
                    g.drawString(VBarMeter.this.labels[ndx], XX, YY);
                    continue;
                }
                if (!hasTicks) continue;
                X = tickPos == 1 ? VBarMeter.this.meterWidth - tickLength : VBarMeter.this.lineWidth;
                g.setColor(tickColor);
                g.fillRect(X, Y, tickLength, VBarMeter.this.tickWidth);
            }
            g.translate(-meterX, -meterY);
            if (VBarMeter.this.hasTitle() && g instanceof Graphics2D) {
                g.setFont(VBarMeter.this.titleFont);
                g.setColor(Color.black);
                Graphics2D g2 = (Graphics2D)g;
                g2.translate(titleX, titleY);
                g2.rotate(-1.5707963267948966);
                g2.drawString(VBarMeter.this.vertTitle, 0, 0);
                g2.rotate(1.5707963267948966);
                g2.translate(-titleX, -titleY);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color oldColor = g.getColor();
            g.setColor(VBarMeter.this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintMeter(g, 0, 0);
            g.setColor(oldColor);
        }
    }

    public static class ColorRange {
        private double percent = 0.0;
        private Color color = Color.black;

        public ColorRange(double pct, Color color) {
            this.percent = pct;
            this.color = color;
        }

        public double getPercent() {
            return this.percent;
        }

        public Color getColor() {
            return this.color;
        }

        public String toString() {
            return this.percent + ":" + this.color;
        }
    }

    public static interface ScaleFtn {
        public double scale(double var1);
    }
}

