/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.taip;

import java.net.InetAddress;
import java.util.List;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DataTransport;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.dbtypes.DTIPAddrList;
import org.opengts.servers.taip.Main;
import org.opengts.servers.taip.TrackServer;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static String[] UNIQUEID_PREFIX = null;
    public static double MINIMUM_SPEED_KPH = 3.0;
    public static boolean ESTIMATE_ODOMETER = true;
    public static boolean SIMEVENT_GEOZONES = true;
    public static double MINIMUM_MOVED_METERS = 0.0;
    public static int ACK_RESPONSE_PORT = 0;
    private String ipAddress = null;
    private int clientPort = 0;
    private Device device = null;
    private DataTransport dataXPort = null;
    private long sessionStartTime = 0L;
    private int eventTotalCount = 0;

    @Override
    public int getResponsePort() {
        return ACK_RESPONSE_PORT;
    }

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.sessionStartTime = DateTime.getCurrentTimeSec();
        this.ipAddress = inetAddr != null ? inetAddr.getHostAddress() : null;
        this.clientPort = this.getSessionInfo().getRemotePort();
        this.eventTotalCount = 0;
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        return -1;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        if (pktBytes == null) {
            Print.logError("Packet is null", new Object[0]);
        } else if (pktBytes.length < 2) {
            Print.logError("Unexpected packet length: " + pktBytes.length, new Object[0]);
        } else {
            String s = StringTools.toStringValue(pktBytes).trim();
            Print.logInfo("Recv: " + s, new Object[0]);
            Print.logInfo("Hex: 0x" + StringTools.toHexString(pktBytes), new Object[0]);
            this.parseInsertRecord(s);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseInsertRecord(String s) {
        List<Device.GeozoneTransition> zone;
        if (StringTools.isBlank(s)) {
            Print.logError("String is null/blank", new Object[0]);
            return false;
        }
        if (s.length() < 5) {
            Print.logError("String is invalid length", new Object[0]);
            return false;
        }
        if (!s.startsWith(">")) {
            Print.logError("String does not start with '>'", new Object[0]);
            return false;
        }
        int se = s.endsWith("<") ? s.length() - 1 : s.length();
        String[] T = StringTools.split(s = s.substring(1, se), ';');
        if (!T[0].startsWith("RPV")) {
            Print.logWarn("Only 'RPV' record types are currently supported", new Object[0]);
            return false;
        }
        if (T[0].length() < 33) {
            Print.logError("Invalid 'RPV' data length", new Object[0]);
            return false;
        }
        String mobileID = null;
        for (int i = 1; i < T.length; ++i) {
            if (!T[i].startsWith("ID=")) continue;
            mobileID = T[i].substring(3);
            break;
        }
        int statusCode = 61472;
        int gpsTOD = StringTools.parseInt(T[0].substring(3, 8), 0);
        double latitude = (double)StringTools.parseLong(T[0].substring(8, 16), 0L) / 100000.0;
        double longitude = (double)StringTools.parseLong(T[0].substring(16, 25), 0L) / 100000.0;
        double speedKPH = StringTools.parseDouble(T[0].substring(25, 28), 0.0) * 1.609344;
        double headingDeg = StringTools.parseDouble(T[0].substring(28, 31), 0.0);
        String srcStr = T[0].substring(31, 32);
        String ageStr = T[0].substring(32, 33);
        double altitudeM = 0.0;
        double odomKM = 0.0;
        long gpioInput = 0L;
        long fixtime = new DateTime(DateTime.getGMTTimeZone()).getDayStart() + (long)gpsTOD;
        if (fixtime - DateTime.MinuteSeconds(15L) > DateTime.getCurrentTimeSec()) {
            fixtime -= DateTime.DaySeconds(1L);
        }
        boolean validGPS = true;
        if (!GeoPoint.isValid(latitude, longitude)) {
            Print.logWarn("Invalid lat/lon: " + latitude + "/" + longitude, new Object[0]);
            validGPS = false;
            latitude = 0.0;
            longitude = 0.0;
            speedKPH = 0.0;
            headingDeg = 0.0;
        }
        GeoPoint geoPoint = new GeoPoint(latitude, longitude);
        if (speedKPH < MINIMUM_SPEED_KPH) {
            speedKPH = 0.0;
            headingDeg = 0.0;
        } else if (headingDeg < 0.0) {
            headingDeg = 0.0;
        }
        Print.logInfo("MobileID  : " + mobileID, new Object[0]);
        Print.logInfo("Timestamp : " + new DateTime(fixtime), new Object[0]);
        Print.logInfo("GeoPoint  : " + geoPoint, new Object[0]);
        Print.logInfo("Speed km/h: " + speedKPH + " [" + headingDeg + "]", new Object[0]);
        if (StringTools.isBlank(mobileID)) {
            Print.logError("Missing MobileID", new Object[0]);
            return false;
        }
        String accountID = "";
        String deviceID = "";
        String uniqueID = "";
        Device device = DCServerConfig.loadDeviceUniqueID(Main.getServerConfig(), mobileID);
        if (device == null) {
            return false;
        }
        accountID = device.getAccountID();
        deviceID = device.getDeviceID();
        uniqueID = device.getUniqueID();
        Print.logInfo("UniqueID  : " + uniqueID, new Object[0]);
        Print.logInfo("DeviceID  : " + accountID + "/" + deviceID, new Object[0]);
        DataTransport dataXPort = device.getDataTransport();
        if (this.ipAddress != null && !dataXPort.isValidIPAddress(this.ipAddress)) {
            DTIPAddrList validIPAddr = dataXPort.getIpAddressValid();
            Print.logError("Invalid IP Address from device: " + this.ipAddress + " [expecting " + validIPAddr + "]", new Object[0]);
            return false;
        }
        dataXPort.setIpAddressCurrent(this.ipAddress);
        dataXPort.setRemotePortCurrent(this.clientPort);
        dataXPort.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
        if (!dataXPort.getDeviceCode().equalsIgnoreCase("taip")) {
            dataXPort.setDeviceCode("taip");
        }
        if (!validGPS && statusCode == 61472) {
            Print.logWarn("Ignoring event with invalid latitude/longitude", new Object[0]);
            return false;
        }
        odomKM = odomKM <= 0.0 ? (ESTIMATE_ODOMETER && validGPS ? device.getNextOdometerKM(geoPoint) : device.getLastOdometerKM()) : device.adjustOdometerKM(odomKM);
        Print.logInfo("OdometerKM: " + odomKM, new Object[0]);
        if (SIMEVENT_GEOZONES && validGPS && (zone = device.checkGeozoneTransitions(fixtime, geoPoint)) != null) {
            for (Device.GeozoneTransition z : zone) {
                this.insertEventRecord(device, z.getTimestamp(), z.getStatusCode(), z.getGeozone(), geoPoint, gpioInput, speedKPH, headingDeg, altitudeM, odomKM);
                Print.logInfo("Geozone    : " + z, new Object[0]);
                if (z.getStatusCode() != statusCode) continue;
                Print.logDebug("StatusCode already inserted: 0x" + StatusCodes.GetHex(statusCode), new Object[0]);
                statusCode = -1;
            }
        }
        if (statusCode != 0) {
            if (statusCode != 61472 || !validGPS) {
                this.insertEventRecord(device, fixtime, statusCode, null, geoPoint, gpioInput, speedKPH, headingDeg, altitudeM, odomKM);
            } else if (!device.isNearLastValidLocation(geoPoint, MINIMUM_MOVED_METERS)) {
                if (statusCode == 61472 && speedKPH > 0.0) {
                    statusCode = 61714;
                }
                this.insertEventRecord(device, fixtime, statusCode, null, geoPoint, gpioInput, speedKPH, headingDeg, altitudeM, odomKM);
            }
        }
        try {
            device.updateChangedEventFields();
        }
        catch (DBException dbe) {
            Print.logException("Unable to update Device: " + accountID + "/" + deviceID, dbe);
        }
        return true;
    }

    private EventData createEventRecord(Device device, long fixtime, int statusCode, GeoPoint geoPoint, long gpioInput, double speedKPH, double heading, double altitude, double odomKM) {
        String accountID = device != null ? device.getAccountID() : "";
        String deviceID = device != null ? device.getDeviceID() : "";
        EventData.Key evKey = new EventData.Key(accountID, deviceID, fixtime, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        evdb.setGeoPoint(geoPoint);
        evdb.setInputMask(gpioInput);
        evdb.setHeading(heading);
        evdb.setSpeedKPH(speedKPH);
        evdb.setAltitude(altitude);
        evdb.setOdometerKM(odomKM);
        return evdb;
    }

    private void insertEventRecord(Device device, long fixtime, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpioInput, double speedKPH, double heading, double altitude, double odomKM) {
        EventData evdb = this.createEventRecord(device, fixtime, statusCode, geoPoint, gpioInput, speedKPH, heading, altitude, odomKM);
        Print.logInfo("Event     : [0x" + StringTools.toHexString(statusCode, 16) + "] " + StatusCodes.GetDescription(statusCode, null), new Object[0]);
        if (device != null) {
            device.insertEventData(evdb);
        }
        ++this.eventTotalCount;
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig();
        if (dcsc != null) {
            UNIQUEID_PREFIX = dcsc.getUniquePrefix();
            MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
            ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
            SIMEVENT_GEOZONES = dcsc.getSimulateGeozones(SIMEVENT_GEOZONES);
            MINIMUM_MOVED_METERS = dcsc.getMinimumMovedMeters(MINIMUM_MOVED_METERS);
            ACK_RESPONSE_PORT = dcsc.getAckResponsePort(ACK_RESPONSE_PORT);
        }
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, false);
        TrackClientPacketHandler.configInit();
        TrackServer.configInit();
        TrackClientPacketHandler tcph = new TrackClientPacketHandler();
        String[] r = new String[]{">RPV21305+3958635-1414085300000012;ID=0011<", ">RPV15714+3739438-1420384601512612;ID=1234;*7F<"};
        for (int i = 0; i < r.length; ++i) {
            tcph.getHandlePacket(r[i].getBytes());
        }
    }
}

