/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.servers.tzavl08;

import java.net.InetAddress;
import java.util.List;
import org.opengts.cellid.CellTower;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.DataTransport;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.opt.servers.DCServerAttributes;
import org.opengts.opt.servers.tzavl08.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.Nmea0183;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    private static boolean THROTTLE = false;
    private static String THROTTLE_KEY = "";
    public static Object THROTTLE_MSG = null;
    public static String[] UNIQUEID_PREFIX = new String[]{"imei_"};
    public static double MINIMUM_SPEED_KPH = 3.0;
    public static boolean ESTIMATE_ODOMETER = true;
    public static boolean SIMEVENT_GEOZONES = true;
    public static long SIMEVENT_DIGITAL_INPUTS = 255L;
    public static boolean XLATE_LOCATON_INMOTION = true;
    public static double MINIMUM_MOVED_METERS = 0.0;
    public static double[] BATTERY_LEVEL_RANGE = new double[]{3.4, 4.2};
    public static String RFID_FIELD_NAME = null;
    public static boolean DEBUG_MODE = false;
    public static final int CMD_LoginConfirmation = 16384;
    public static final int CMD_Login = 20480;
    public static final int CMD_TrackOnDemand = 16641;
    public static final int CMD_TrackByInterval = 16642;
    public static final int CMD_Authorization = 16643;
    public static final int CMD_LowPowerAlarm = 16644;
    public static final int CMD_SpeedingAlarm = 16645;
    public static final int CMD_MovementAlarm = 16646;
    public static final int CMD_GeofenceDepart = 16647;
    public static final int CMD_GeofenceArrive = 16903;
    public static final int CMD_ExtendedSettings = 16648;
    public static final int CMD_Reserved_2 = 16649;
    public static final int CMD_Initialization = 16656;
    public static final int CMD_Reserved_3 = 16657;
    public static final int CMD_Reserved_4 = 16658;
    public static final int CMD_SleepMode = 16659;
    public static final int CMD_OutputControl_10kph = 16660;
    public static final int CMD_OutputControl_20kph = 20756;
    public static final int CMD_OutputControl_unlimited = 16661;
    public static final int CMD_TriggeredAlarms = 16662;
    public static final int CMD_PowerDown = 16678;
    public static final int CMD_VoiceListen = 16688;
    public static final int CMD_LogByInterval = 16689;
    public static final int CMD_TimeZone = 16690;
    public static final int CMD_VeerReport = 16694;
    public static final int CMD_GpsAntennaOpen = 16720;
    public static final int CMD_RebootGPS = 18690;
    public static final int CMD_Heartbeat = 20889;
    public static final int CMD_Format = 21763;
    public static final int CMD_Reserved_5 = 36864;
    public static final int CMD_SerialNumberIMEI = 36865;
    public static final int CMD_ReadInterval = 36866;
    public static final int CMD_ReadAuthorization = 36867;
    public static final int CMD_ReadOverSpeedAlarm = 36869;
    public static final int CMD_ReadGeofenceAlarm = 36870;
    public static final int CMD_ReadExtendedFtn = 36872;
    public static final int CMD_ReadPowerSavingMode = 36883;
    public static final int CMD_ReadOutputPortStatus = 36884;
    public static final int CMD_ReadLoggedData = 36886;
    public static final int CMD_PositionReport = 39253;
    public static final int CMD_Alarms = 39321;
    private static AnalogField[] AnalogData = new AnalogField[2];
    private Device device = null;
    private DataTransport dataXPort = null;
    private StringBuffer discardHex = new StringBuffer();
    protected static long DCS_MODE_KEY = 0L;
    protected long dcsModeKey = 0L;

    private static double CalculateBatteryLevel(double d) {
        return DCServerConfig.CalculateBatteryLevel(d, BATTERY_LEVEL_RANGE);
    }

    private static AnalogField NewAnalogField(int n, String string) {
        AnalogField analogField = !StringTools.isBlank(string) ? new AnalogField(n, string) : null;
        return analogField != null && analogField.getGain() != 0.0 ? analogField : null;
    }

    public static AnalogField GetAnalogField(int n) {
        int n2 = n - 1;
        if (n2 >= 0 && n2 <= AnalogData.length) {
            return AnalogData[n2];
        }
        return null;
    }

    private static boolean SetAnalogField(int n, EventData eventData, double d) {
        int n2 = n - 1;
        if (n2 >= 0 && n2 <= AnalogData.length && eventData != null) {
            eventData.setAnalog(n2, d);
            AnalogField analogField = AnalogData[n2];
            if (analogField != null) {
                return analogField.saveEventDataFieldValue(eventData, analogField.convert(d));
            }
            return false;
        }
        return false;
    }

    public TrackClientPacketHandler() {
        DCServerAttributes.newTrackSessionInit(this, THROTTLE, THROTTLE_MSG, 0L);
        if (THROTTLE) {
            try {
                Thread.sleep(4151L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void sessionStarted(InetAddress inetAddress, boolean bl, boolean bl2) {
        super.sessionStarted(inetAddress, bl, bl2);
        super.clearTerminateSession();
        this.clearSavedEventCount();
    }

    @Override
    public void sessionTerminated(Throwable throwable, long l, long l2) {
        super.sessionTerminated(throwable, l, l2);
    }

    @Override
    public String getSessionID() {
        if (this.device != null) {
            return DCServerFactory.createTcpSessionID(this.device);
        }
        return null;
    }

    @Override
    public int getActualPacketLength(byte[] byArray, int n) {
        if (n == 1) {
            if (byArray[0] == 13 || byArray[0] == 10) {
                return n;
            }
            if (byArray[0] == 36) {
                return 0x1000002;
            }
            return n;
        }
        if (n == 2) {
            if (byArray[0] == 36 && byArray[1] == 36) {
                return 0x1000004;
            }
            if (byArray[0] == 36 && byArray[1] == 85) {
                return -1;
            }
            return n;
        }
        if (n < 4) {
            return 0x1000004;
        }
        int n2 = StringTools.hexIndex((char)byArray[2]) & 0xFF;
        int n3 = StringTools.hexIndex((char)byArray[3]) & 0xFF;
        return n2 << 4 | n3;
    }

    @Override
    public byte[] getHandlePacket(byte[] byArray) {
        if (byArray == null || byArray.length <= 0) {
            Print.logError("Packet is null/empty", new Object[0]);
            return null;
        }
        if (byArray.length <= 2) {
            this.discardHex.append(StringTools.toHexString(byArray));
            return null;
        }
        if (this.discardHex.length() > 0) {
            Print.logInfo("Discard: 0x" + this.discardHex, new Object[0]);
            this.discardHex.setLength(0);
        }
        Print.logInfo("Recv: " + StringTools.toStringValue(byArray, '.'), new Object[0]);
        Print.logInfo("Hex: 0x" + StringTools.toHexString(byArray), new Object[0]);
        if (byArray.length < 10) {
            Print.logError("Unexpected packet length: " + byArray.length, new Object[0]);
            return null;
        }
        int n = 0;
        while (byArray[n] == 13 || byArray[n] == 10) {
            ++n;
        }
        if (byArray[n] == 36 && byArray[n + 1] == 85) {
            Print.logError("Camera packet found - not yet supported", new Object[0]);
            return null;
        }
        if (byArray[n] != 36 || byArray[n + 1] != 36) {
            Print.logError("Invalid start of packet (expected '$$')", new Object[0]);
            return null;
        }
        String string = StringTools.toStringValue(byArray, n + 4);
        String[] stringArray = StringTools.split(string, '|');
        if (stringArray.length < 2) {
            Print.logError("Invalid number of fields", new Object[0]);
            return null;
        }
        if (stringArray[0].length() < 5 || stringArray[1].length() < 9) {
            Print.logError("Invalid field lengths", new Object[0]);
            return null;
        }
        if (stringArray[1].startsWith("AA00")) {
            Print.logInfo("Ignoring packets with invalid location information", new Object[0]);
            return null;
        }
        return this._handle_packet(stringArray);
    }

    private byte[] _handle_packet(String[] stringArray) {
        List<Device.GeozoneTransition> list;
        String string;
        String string2 = stringArray[0];
        Print.logInfo("Mobile ID: " + string2, new Object[0]);
        this.device = DCServerConfig.loadDeviceUniqueID(Main.getServerConfig(null), string2);
        if (this.device == null) {
            Print.logError("Device not found: " + string2, new Object[0]);
            if (!DEBUG_MODE) {
                DCServerFactory.addUnassignedDevice("tzavl08", string2, this.getIPAddress(), this.isDuplex(), null);
                return null;
            }
        } else {
            this.dataXPort = this.device.getDataTransport();
        }
        String string3 = this.device != null ? this.device.getAccountID() : "???";
        String string4 = this.device != null ? this.device.getDeviceID() : "???";
        String string5 = string = this.device != null ? this.device.getUniqueID() : "???";
        if (this.hasIPAddress() && this.dataXPort != null && !this.dataXPort.isValidIPAddress(this.getIPAddress())) {
            Print.logError("Invalid IP Address for device: " + this.getIPAddress() + " [expecting " + this.dataXPort.getIpAddressValid() + "]", new Object[0]);
            return null;
        }
        if (this.device != null) {
            this.device.setIpAddressCurrent(this.getIPAddress());
            this.device.setRemotePortCurrent(this.getRemotePort());
            this.device.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
            if (!this.dataXPort.getDeviceCode().equalsIgnoreCase("tzavl08")) {
                this.dataXPort.setDeviceCode("tzavl08");
            }
        }
        Print.logInfo("DeviceID : [" + string + "] " + string3 + "/" + string4, new Object[0]);
        int n = StringTools.parseHexInt(stringArray[1].substring(0, 2), 0);
        int n2 = 61474;
        long l = this.device != null ? this.device.getLastInputState() : 0L;
        switch (n) {
            case 1: {
                n2 = this._translateStatusCode(n, 63553);
                break;
            }
            case 73: {
                n2 = this._translateStatusCode(n, 61488);
                break;
            }
            case 9: {
                n2 = this._translateStatusCode(n, 64837);
                break;
            }
            case 16: {
                n2 = this._translateStatusCode(n, 64784);
                break;
            }
            case 96: {
                n2 = this._translateStatusCode(n, 64782);
                break;
            }
            case 97: {
                n2 = this._translateStatusCode(n, 64783);
                break;
            }
            case 17: {
                n2 = this._translateStatusCode(n, 61722);
                break;
            }
            case 19: {
                n2 = this._translateStatusCode(n, 61724);
                break;
            }
            case 20: {
                n2 = this._translateStatusCode(n, 61734);
                break;
            }
            case 21: {
                n2 = this._translateStatusCode(n, 61731);
                break;
            }
            case 48: {
                n2 = this._translateStatusCode(n, 62144);
                break;
            }
            case 66: {
                n2 = this._translateStatusCode(n, 62000);
                break;
            }
            case 67: {
                n2 = this._translateStatusCode(n, 61968);
                break;
            }
            case 80: {
                n2 = this._translateStatusCode(n, 62496);
                if (this.device == null) break;
                this.device.setLastInputState(l | 1L);
                break;
            }
            case 81: {
                n2 = this._translateStatusCode(n, 62528);
                if (this.device == null) break;
                this.device.setLastInputState(l & 0xFFFFFFFFFFFFFFFEL);
                break;
            }
            case 82: {
                n2 = this._translateStatusCode(n, 62497);
                if (this.device == null) break;
                this.device.setLastInputState(l | 2L);
                break;
            }
            case 83: {
                n2 = this._translateStatusCode(n, 62529);
                if (this.device == null) break;
                this.device.setLastInputState(l & 0xFFFFFFFFFFFFFFFDL);
                break;
            }
            case 84: {
                n2 = this._translateStatusCode(n, 62498);
                if (this.device == null) break;
                this.device.setLastInputState(l | 4L);
                break;
            }
            case 85: {
                n2 = this._translateStatusCode(n, 62530);
                if (this.device == null) break;
                this.device.setLastInputState(l & 0xFFFFFFFFFFFFFFFBL);
                break;
            }
            case 86: {
                n2 = this._translateStatusCode(n, 62499);
                if (this.device == null) break;
                this.device.setLastInputState(l | 8L);
                break;
            }
            case 87: {
                n2 = this._translateStatusCode(n, 62531);
                if (this.device == null) break;
                this.device.setLastInputState(l & 0xFFFFFFFFFFFFFFF7L);
                break;
            }
            case 102: {
                n2 = this._translateStatusCode(n, 63529);
                break;
            }
            case 119: {
                n2 = this._translateStatusCode(n, 63799);
                break;
            }
            case 136: {
                n2 = this._translateStatusCode(n, 61536);
                break;
            }
            case 145: {
                n2 = this._translateStatusCode(n, 64840);
                break;
            }
            case 146: {
                n2 = this._translateStatusCode(n, 64842);
                break;
            }
            case 170: {
                n2 = this._translateStatusCode(n, 61472);
                break;
            }
            default: {
                n2 = this._translateStatusCode(n, 0x1000 | n);
            }
        }
        if (n2 < 0 || n2 == -1) {
            this._updateDevice();
            return null;
        }
        Nmea0183 nmea0183 = new Nmea0183(stringArray[1].substring(2), true);
        long l2 = nmea0183.getFixtime();
        double d = nmea0183.getLatitude();
        double d2 = nmea0183.getLongitude();
        boolean bl = nmea0183.isValidGPS();
        GeoPoint geoPoint = new GeoPoint(d, d2);
        double d3 = nmea0183.getSpeedKPH();
        double d4 = nmea0183.getHeading();
        double d5 = stringArray.length > 2 ? StringTools.parseDouble(stringArray[2], 0.0) : 0.0;
        double d6 = stringArray.length > 3 ? StringTools.parseDouble(stringArray[3], 0.0) : 0.0;
        double d7 = stringArray.length > 4 ? StringTools.parseDouble(stringArray[4], 0.0) : 0.0;
        String string6 = stringArray.length > 5 ? stringArray[5] : "";
        String string7 = stringArray.length > 6 ? stringArray[6] : "";
        String string8 = stringArray.length > 7 ? stringArray[7] : "";
        double d8 = string8.length() >= 4 ? StringTools.parseDouble(string8.substring(1, 4), 0.0) / 100.0 : 0.0;
        double d9 = string8.length() >= 8 ? StringTools.parseDouble(string8.substring(4, 8), 0.0) / 100.0 : 0.0;
        double d10 = TrackClientPacketHandler.CalculateBatteryLevel(d8);
        String string9 = stringArray.length > 8 ? stringArray[8] : "";
        double d11 = string9.length() >= 4 ? StringTools.parseDouble(string9.substring(0, 4), 0.0) / 100.0 : 0.0;
        double d12 = string9.length() >= 8 ? StringTools.parseDouble(string9.substring(4, 8), 0.0) / 100.0 : 0.0;
        String string10 = stringArray.length > 9 ? stringArray[9] : "";
        int n3 = string10.length() >= 4 ? StringTools.parseInt(string10.substring(0, 4), -1) : -1;
        int n4 = string10.length() >= 8 ? StringTools.parseInt(string10.substring(4, 8), -1) : -1;
        int n5 = 0;
        int n6 = 0;
        double d13 = stringArray.length > 10 ? StringTools.parseDouble(stringArray[10], -9990.0) / 10.0 : -999.0;
        double d14 = stringArray.length > 11 ? StringTools.parseDouble(stringArray[11], 0.0) : 0.0;
        int n7 = stringArray.length > 12 ? StringTools.parseInt(stringArray[12], 0) : 0;
        String string11 = stringArray.length > 13 ? stringArray[13] : "";
        double d15 = 0.0;
        double d16 = 0.0;
        if (d3 < MINIMUM_SPEED_KPH) {
            d3 = 0.0;
            d4 = 0.0;
        } else if (d4 < 0.0) {
            d4 = 0.0;
        }
        if (n2 == 0) {
            n2 = d3 > 0.0 ? 61714 : 61472;
        } else if (XLATE_LOCATON_INMOTION && n2 == 61472 && d3 > 0.0) {
            n2 = 61714;
        }
        CellTower cellTower = null;
        if (n5 >= 0 && n6 >= 0 && n3 >= 0 && n4 > 0) {
            cellTower = new CellTower();
            cellTower.setMobileCountryCode(n5);
            cellTower.setMobileNetworkCode(n6);
            cellTower.setLocationAreaCode(n3);
            cellTower.setCellTowerID(n4);
        }
        long l3 = -1L;
        long l4 = -1L;
        if (!StringTools.isBlank(string6) && string6.length() >= 12) {
            l3 = 0L;
            if (string6.charAt(4) == '1') {
                l3 |= 1L;
            }
            if (string6.charAt(5) == '1') {
                l3 |= 2L;
            }
            if (string6.charAt(6) == '1') {
                l3 |= 4L;
            }
            if (string6.charAt(7) == '1') {
                l3 |= 8L;
            }
            if (string6.charAt(0) == '1') {
                l3 |= 0x10L;
            }
            if (string6.charAt(1) == '1') {
                l3 |= 0x20L;
            }
            if (string6.charAt(2) == '1') {
                l3 |= 0x40L;
            }
            if (string6.charAt(3) == '1') {
                l3 |= 0x80L;
            }
            l4 = 0L;
            if (string6.charAt(8) == '1') {
                l4 |= 1L;
            }
            if (string6.charAt(9) == '1') {
                l4 |= 2L;
            }
            if (string6.charAt(10) == '1') {
                l4 |= 4L;
            }
            if (string6.charAt(11) == '1') {
                l4 |= 8L;
            }
        }
        Print.logInfo("Fixtime   : " + new DateTime(l2), new Object[0]);
        Print.logInfo("GeoPoint  : " + geoPoint, new Object[0]);
        Print.logInfo("Speed     : " + d3 + " km/h [heading " + d4 + "]", new Object[0]);
        Print.logInfo("Altitude  : " + d15 + " meters", new Object[0]);
        Print.logInfo("Battery V : " + d8 + " volts", new Object[0]);
        Print.logInfo("Battery Lv: " + d10 * 100.0 + " %", new Object[0]);
        Print.logInfo("Charge V  : " + d9 + " volts", new Object[0]);
        Print.logInfo("Temp C    : " + d13 + " C", new Object[0]);
        Print.logInfo("Analog-1 V: " + d11 + " volts", new Object[0]);
        Print.logInfo("Analog-2 V: " + d12 + " volts", new Object[0]);
        Print.logInfo("GPIO      : " + StringTools.toBinaryString((byte)l3), new Object[0]);
        if (cellTower != null) {
            Print.logInfo("CellTower : " + cellTower, new Object[0]);
        }
        if (this.device != null) {
            d16 = d16 <= 0.0 ? (ESTIMATE_ODOMETER && bl ? this.device.getNextOdometerKM(geoPoint) : this.device.getLastOdometerKM()) : this.device.adjustOdometerKM(d16);
        }
        Print.logInfo("Odometer  : " + d16 + " km", new Object[0]);
        long l5 = this.getSessionStartTime();
        if (SIMEVENT_GEOZONES && bl && this.device != null && (list = this.device.checkGeozoneTransitions(l2, geoPoint)) != null) {
            for (Device.GeozoneTransition geozoneTransition : list) {
                this.insertEventRecord(this.device, geozoneTransition.getTimestamp(), geozoneTransition.getStatusCode(), geozoneTransition.getGeozone(), geoPoint, d3, d4, d15, d16, d8, d10, d9, d13, d11, d12, l3, string11, cellTower);
                Print.logInfo("Geozone    : " + geozoneTransition, new Object[0]);
                if (geozoneTransition.getStatusCode() != n2) continue;
                Print.logDebug("StatusCode already inserted: 0x" + StatusCodes.GetHex(n2), new Object[0]);
                n2 = -1;
            }
        }
        long l6 = SIMEVENT_DIGITAL_INPUTS;
        int n8 = 0;
        if (l3 >= 0L && this.dataXPort != null) {
            long l7;
            if (l6 > 0L && (l7 = (this.dataXPort.getLastInputState() ^ l3) & l6) != 0L) {
                for (int i = 0; i <= 7; ++i) {
                    long l8 = 1L << i;
                    if ((l7 & l8) == 0L) continue;
                    int n9 = (l3 & l8) != 0L ? StatusCodes.InputStatusCodes_ON[i] : StatusCodes.InputStatusCodes_OFF[i];
                    this.insertEventRecord(this.device, l2, n9, null, geoPoint, d3, d4, d15, d16, d8, d10, d9, d13, d11, d12, l3, string11, cellTower);
                    ++n8;
                    if (n9 != n2) continue;
                    n2 = -1;
                }
            }
            this.dataXPort.setLastInputState(l3 & 0xFFL);
        }
        if (!(l6 > 0L && n8 > 0 && StatusCodes.IsDigitalInput(n2, false) || n2 < 0 || n2 == -1 || n2 == 61472 && this.hasSavedEvents())) {
            if (n2 != 61472) {
                this.insertEventRecord(this.device, l2, n2, null, geoPoint, d3, d4, d15, d16, d8, d10, d9, d13, d11, d12, l3, string11, cellTower);
            } else if (bl && this.device != null && !this.device.isNearLastValidLocation(geoPoint, MINIMUM_MOVED_METERS)) {
                this.insertEventRecord(this.device, l2, n2, null, geoPoint, d3, d4, d15, d16, d8, d10, d9, d13, d11, d12, l3, string11, cellTower);
            }
        }
        this._updateDevice();
        return null;
    }

    private int _translateStatusCode(int n, int n2) {
        DCServerConfig dCServerConfig = Main.getServerConfig(null);
        if (dCServerConfig != null) {
            int n3 = dCServerConfig.translateStatusCode(n, -9999);
            if (n3 >= 0) {
                return n3;
            }
            return dCServerConfig.translateStatusCode(n2, n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateDevice() {
        if (!DEBUG_MODE && this.device != null) {
            String string = this.device.getAccountID();
            String string2 = this.device.getDeviceID();
            try {
                this.device.updateChangedEventFields();
            }
            catch (DBException dBException) {
                Print.logException("Unable to update Device: " + string + "/" + string2, dBException);
            }
        }
    }

    private EventData createEventRecord(Device device, long l, int n, Geozone geozone, GeoPoint geoPoint, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, long l2, String string, CellTower cellTower) {
        String string2 = device != null ? device.getAccountID() : "";
        String string3 = device != null ? device.getDeviceID() : "";
        EventData.Key key = new EventData.Key(string2, string3, l, n);
        EventData eventData = (EventData)key.getDBRecord();
        eventData.setGeozone(geozone);
        eventData.setGeoPoint(geoPoint);
        eventData.setHeading(d2);
        eventData.setSpeedKPH(d);
        eventData.setAltitude(d3);
        eventData.setOdometerKM(d4);
        eventData.setBatteryVolts(d5);
        eventData.setBatteryLevel(d6);
        eventData.setVBatteryVolts(d7);
        eventData.setRfidTag(string);
        if (d8 >= -99.9 && d8 <= 500.0) {
            eventData.setThermoAverage0(d8);
        }
        TrackClientPacketHandler.SetAnalogField(1, eventData, d9);
        TrackClientPacketHandler.SetAnalogField(2, eventData, d10);
        if (!StringTools.isBlank(RFID_FIELD_NAME)) {
            eventData.setFieldValue(RFID_FIELD_NAME, string);
        }
        eventData.setInputMask(l2);
        eventData.setRfidTag(string);
        eventData.setServingCellTower(cellTower);
        return eventData;
    }

    private void insertEventRecord(Device device, long l, int n, Geozone geozone, GeoPoint geoPoint, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, long l2, String string, CellTower cellTower) {
        if (DEBUG_MODE || device == null) {
            return;
        }
        long l3 = this.getSessionStartTime();
        EventData eventData = this.createEventRecord(device, l, n, geozone, geoPoint, d, d2, d3, d4, d5, d6, d7, d8, d9, d10, l2, string, cellTower);
        device.insertEventData(eventData);
        this.incrementSavedEventCount();
    }

    public static void configInit() {
        DCServerConfig dCServerConfig = Main.getServerConfig(null);
        if (dCServerConfig != null) {
            UNIQUEID_PREFIX = dCServerConfig.getUniquePrefix();
            MINIMUM_SPEED_KPH = dCServerConfig.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
            ESTIMATE_ODOMETER = dCServerConfig.getEstimateOdometer(ESTIMATE_ODOMETER);
            SIMEVENT_GEOZONES = dCServerConfig.getSimulateGeozones(SIMEVENT_GEOZONES);
            SIMEVENT_DIGITAL_INPUTS = dCServerConfig.getSimulateDigitalInputs(SIMEVENT_DIGITAL_INPUTS) & 0xFFL;
            XLATE_LOCATON_INMOTION = dCServerConfig.getStatusLocationInMotion(XLATE_LOCATON_INMOTION);
            MINIMUM_MOVED_METERS = dCServerConfig.getMinimumMovedMeters(MINIMUM_MOVED_METERS);
            BATTERY_LEVEL_RANGE = dCServerConfig.getBatteryLevelRange(new double[]{BATTERY_LEVEL_RANGE[0], BATTERY_LEVEL_RANGE[1]});
            for (int i = 1; i <= AnalogData.length; ++i) {
                int n = i - 1;
                String string = "tzavl08.analog." + i;
                TrackClientPacketHandler.AnalogData[n] = TrackClientPacketHandler.NewAnalogField(i, dCServerConfig.getStringProperty(string, null));
            }
            RFID_FIELD_NAME = dCServerConfig.getStringProperty("tzavl08.rfidFieldName", RFID_FIELD_NAME);
        }
        THROTTLE = !DCServerAttributes.CheckMID(new DCServerAttributes.AttrbuteHandler(){

            @Override
            public void setDCAttribute(String string, Object object) {
                THROTTLE_KEY = string;
                THROTTLE_MSG = object;
            }
        }, "tzavl08", 0L, "mutinda", 1381279040L) || THROTTLE_MSG != null;
        Device.SetLogEventDataInsertion(4);
    }

    public static class AnalogField
    extends DCServerConfig.EventDataAnalogField {
        public AnalogField(int n, String string) {
            super(n, string, 9.765625E-4, 0.0);
        }
    }
}

