/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.servers.tzavl08;

import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBAdmin;
import org.opengts.opt.servers.DCServerAttributes;
import org.opengts.opt.servers.tzavl08.AVL08CommandHandler;
import org.opengts.opt.servers.tzavl08.Constants;
import org.opengts.opt.servers.tzavl08.TrackClientPacketHandler;
import org.opengts.opt.servers.tzavl08.TrackServer;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Main {
    public static final String[] ARG_HELP = new String[]{"help", "h"};
    public static final String[] ARG_CMD_PORT = new String[]{"command", "cmd"};
    public static final String[] ARG_START = new String[]{"start"};
    private static DCServerConfig dcServerCfg = null;

    public static String DCServerFactory_LoadName() {
        return Main.getServerContextName();
    }

    public static String getServerName() {
        return "tzavl08";
    }

    public static String getServerContextName() {
        return RTConfig.getContextName(Main.getServerName());
    }

    public static DCServerConfig getServerConfig(Device device) {
        if (dcServerCfg == null) {
            dcServerCfg = DCServerFactory.getServerConfig(Main.getServerContextName(), true);
            DCServerConfig.startRemoteLogging(dcServerCfg);
        }
        return dcServerCfg;
    }

    private static void usage(String string) {
        String string2 = TrackServer.getTcpPortsString(Main.getServerConfig(null));
        String string3 = TrackServer.getUdpPortsString(Main.getServerConfig(null));
        if (string != null) {
            Print.logInfo(string, new Object[0]);
        }
        Print.logInfo("", new Object[0]);
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + Main.class.getName() + " {options}", new Object[0]);
        Print.logInfo("Options:", new Object[0]);
        Print.logInfo("  [-h[elp]]           Print this help", new Object[0]);
        Print.logInfo("  [-port=<p>[,<p>]]   Server TCP/UDP port(s) to listen", new Object[0]);
        Print.logInfo("  [-tcp=<p>[,<p>]]    Server TCP port(s) to listen on [dft=" + string2 + "]", new Object[0]);
        Print.logInfo("  [-udp=<p>[,<p>]]    Server UDP port(s) to listen on [dft=" + string3 + "]", new Object[0]);
        Print.logInfo("  -start              Start server on the specified port", new Object[0]);
        Print.logInfo("", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        if (!ListTools.isEmpty(stringArray) && stringArray[0].equalsIgnoreCase("Constants")) {
            stringArray2 = ListTools.toArray(stringArray, 1, stringArray.length - 1);
            Constants.main(stringArray2);
            System.exit(0);
        }
        DBConfig.cmdLineInit(stringArray, false);
        DBConfig.check_GTS_HOME();
        if ("time".equals(RTConfig.getString("xpire", ""))) {
            Print.logInfo("n/a", new Object[0]);
            System.exit(1);
        }
        stringArray2 = Main.getServerConfig(null);
        TrackClientPacketHandler.configInit();
        TrackServer.configInit();
        boolean bl = false;
        long l = DateTime.getCurrentTimeSec();
        bl = false;
        DCServerAttributes.beginPrintDCSHeader(Main.getServerConfig(null), Main.getServerContextName(), "TZone AVL-08", "0.2.3", "Copyright 2007-2013, GeoTelematic Solutions, Inc.", "mutinda", bl, 0L, 0L, 1381279040L, TrackClientPacketHandler.THROTTLE_MSG);
        Print.logInfo("Minimum Speed (km/h)  : " + TrackClientPacketHandler.MINIMUM_SPEED_KPH, new Object[0]);
        Print.logInfo("Estimate GPS Odometer : " + TrackClientPacketHandler.ESTIMATE_ODOMETER, new Object[0]);
        Print.logInfo("Simulate Arrive/Depart: " + TrackClientPacketHandler.SIMEVENT_GEOZONES, new Object[0]);
        Print.logInfo("Battery Level Range   : " + StringTools.join(TrackClientPacketHandler.BATTERY_LEVEL_RANGE, ","), new Object[0]);
        Print.logInfo("Analog #1             : " + TrackClientPacketHandler.GetAnalogField(1), new Object[0]);
        Print.logInfo("Analog #2             : " + TrackClientPacketHandler.GetAnalogField(2), new Object[0]);
        DCServerAttributes.endPrintDCSHeader();
        if (RTConfig.getBoolean(ARG_HELP, false)) {
            Main.usage("Help ...");
        }
        if (!DBAdmin.verifyTablesExist()) {
            Print.logFatal("MySQL database has not yet been properly initialized", new Object[0]);
            System.exit(1);
        }
        if (RTConfig.getBoolean(ARG_START, false)) {
            TrackServer.startTrackServer((DCServerConfig)stringArray2, TrackServer.class, AVL08CommandHandler.class, true);
        }
        Main.usage("Missing '-start' ...");
    }
}

