/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.servers.tzavl08;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.opengts.db.CommandPacketHandler;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Device;
import org.opengts.opt.servers.tzavl08.Main;
import org.opengts.opt.servers.tzavl08.TrackServer;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.ServerSocketThread;
import org.opengts.util.StringTools;

public class AVL08CommandHandler
extends CommandPacketHandler {
    @Override
    public String getServerName() {
        return "tzavl08";
    }

    public int getClientCommandPort_udp(int n) {
        DCServerConfig dCServerConfig = Main.getServerConfig(null);
        int n2 = dCServerConfig.getClientCommandPort_udp(0);
        return n2 > 0 ? n2 : n;
    }

    @Override
    public DCServerFactory.ResultCode handleCommand(Device device, String string, String string2, String[] stringArray) {
        DCServerConfig dCServerConfig;
        DCServerConfig.Command command;
        Print.logInfo("Recv Cmd: type=%s name=%s arg=%s", string, string2, StringTools.join(stringArray, ','));
        if (device == null) {
            return DCServerFactory.ResultCode.INVALID_DEVICE;
        }
        if (string.equalsIgnoreCase("ping")) {
            string = "config";
            string2 = "LocateNow";
        }
        if ((command = (dCServerConfig = Main.getServerConfig(null)).getCommand(string2)) == null) {
            Print.logWarn("Command not found: " + string2, new Object[0]);
            return DCServerFactory.ResultCode.INVALID_COMMAND;
        }
        String string3 = command.getCommandString(device, stringArray);
        DCServerConfig.CommandProtocol commandProtocol = command.getCommandProtocol(DCServerConfig.CommandProtocol.UDP);
        if (commandProtocol == null) {
            return DCServerFactory.ResultCode.INVALID_PROTO;
        }
        if (commandProtocol.equals(DCServerConfig.CommandProtocol.SMS)) {
            String string4 = StringTools.trim(string3);
            String string5 = command.getCommandProtocolHandler();
            DCServerFactory.ResultCode resultCode = DCServerFactory.SendSMSCommand(string5, device, string4);
            command.setDeviceCommandAttributes(resultCode, device, string4, true);
            return resultCode;
        }
        if (!string.equalsIgnoreCase("config")) {
            return DCServerFactory.ResultCode.INVALID_COMMAND;
        }
        if (commandProtocol.equals(DCServerConfig.CommandProtocol.UDP)) {
            Print.logDebug("UDP ConfigCmd [device=%s, cmd=%s]", device.getDeviceID(), string2);
            String string6 = StringTools.trim(string3);
            byte[] byArray = string6.getBytes();
            DCServerFactory.ResultCode resultCode = this.sendCommandPacket_udp(device, string, byArray);
            command.setDeviceCommandAttributes(resultCode, device, string6, true);
            return resultCode;
        }
        if (commandProtocol.equals(DCServerConfig.CommandProtocol.TCP)) {
            Print.logDebug("TCP ConfigCmd [device=%s, cmd=%s]", device.getDeviceID(), string2);
            String string7 = StringTools.trim(string3);
            byte[] byArray = string7.getBytes();
            DCServerFactory.ResultCode resultCode = this.sendCommandPacket_tcp(device, string, byArray);
            command.setDeviceCommandAttributes(resultCode, device, string7, true);
            return resultCode;
        }
        return DCServerFactory.ResultCode.INVALID_PROTO;
    }

    private DCServerFactory.ResultCode sendCommandPacket_udp(Device device, String string, byte[] byArray) {
        if (ListTools.isEmpty(byArray)) {
            Print.logError("Command packet is null/empty (%s)", string);
            return DCServerFactory.ResultCode.INVALID_ARG;
        }
        int n = device.getListenPortCurrent();
        String string2 = StringTools.trim(device.getIpAddressCurrent());
        int n2 = this.getClientCommandPort_udp(device.getRemotePortCurrent());
        long l = DateTime.getCurrentTimeSec() - device.getLastTotalConnectTime();
        if (StringTools.isBlank(string2) || string2.equals("0.0.0.0") || n2 <= 0) {
            Print.logError("Device host:port not known> %s:%d", string2, n2);
            return DCServerFactory.ResultCode.UNKNOWN_HOST;
        }
        Print.logInfo("Send '%s:%d' (age %dsec) [%s] 0x%s", string2, n2, l, string, StringTools.toStringValue(byArray, '.'));
        try {
            this.sendDatagramMessage(n, string2, n2, byArray);
            return DCServerFactory.ResultCode.SUCCESS;
        }
        catch (Throwable throwable) {
            Print.logException("UDP transmit failure", throwable);
            return DCServerFactory.ResultCode.TRANSMIT_FAIL;
        }
    }

    private void sendDatagramMessage(int n, String string, int n2, byte[] byArray) throws IOException {
        boolean bl = false;
        DatagramSocket datagramSocket = TrackServer.getInstance().getUdpDatagramSocket(n);
        if (datagramSocket == null) {
            Print.logWarn("Creating temporary DatagramSocket for transmission", new Object[0]);
            datagramSocket = ServerSocketThread.createDatagramSocket(0);
            bl = true;
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(string), n2);
        Print.logInfo("Sending Datagram (from %s:%d) to %s:%d> 0x%s", StringTools.trim(datagramSocket.getLocalAddress()), datagramSocket.getLocalPort(), string, n2, StringTools.toHexString(byArray));
        datagramSocket.send(datagramPacket);
        if (bl) {
            datagramSocket.close();
        }
    }

    private DCServerFactory.ResultCode sendCommandPacket_tcp(Device device, String string, byte[] byArray) {
        if (ListTools.isEmpty(byArray)) {
            Print.logError("Command packet is null/empty (%s)", string);
            return DCServerFactory.ResultCode.INVALID_ARG;
        }
        DCServerConfig dCServerConfig = Main.getServerConfig(null);
        String string2 = device.getAccountID() + "/" + device.getDeviceID();
        int n = device.getListenPortCurrent();
        long l = DateTime.getCurrentTimeSec() - device.getLastTotalConnectTime();
        ServerSocketThread serverSocketThread = TrackServer.getInstance().getServerSocketThread_tcp(n);
        if (serverSocketThread != null) {
            boolean bl = serverSocketThread.tcpWriteToSessionID(string2, byArray);
            if (bl) {
                return DCServerFactory.ResultCode.SUCCESS;
            }
            return DCServerFactory.ResultCode.NO_SESSION;
        }
        Print.logError("TCP commands not supported for this port: " + n, new Object[0]);
        return DCServerFactory.ResultCode.TRANSMIT_FAIL;
    }

    public static void main(String[] stringArray) {
        RTConfig.setCommandLineArgs(stringArray);
        AVL08CommandHandler aVL08CommandHandler = new AVL08CommandHandler();
    }
}

