/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rulewar.track.page;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.opengts.db.RuleFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.User;
import org.opengts.util.I18N;
import org.opengts.util.PixelDimension;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.tools.CommonServlet;
import org.opengts.war.tools.HTMLOutput;
import org.opengts.war.tools.JavaScriptTools;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.RequestProperties;
import org.opengts.war.tools.WebPage;
import org.opengts.war.tools.WebPageAdaptor;
import org.opengts.war.track.Constants;

public class AlertPanel
extends WebPageAdaptor
implements Constants {
    private static final String[] _ACL_LIST = null;
    private static final String DEFAULT_ALERT_RULE = "alert";
    public static final String PROP_ruleName = "ruleName";
    public static final String PROP_pollInterval = "pollInterval";
    public static final String PROP_alertText_on = "alertText.on";
    public static final String PROP_alertText_off = "alertText.off";
    public static final String PROP_actionText_on = "actionText.on";
    public static final String PROP_actionText_off = "actionText.off";
    public static final String PROP_actionSound_on = "actionSound.on";
    public static final String PROP_actionSound_off = "actionSound.off";
    public static final String PROP_alertPageName = "alertPageName";
    public static final String PROP_bindToParentWindow = "bindToParentWindow";

    public AlertPanel() {
        this.setBaseURI(RequestProperties.TRACK_BASE_URI());
        this.setPageName("alert.panel");
        this.setPageNavigation(new String[]{"login", "menu.top"});
        this.setLoginRequired(true);
    }

    public String getMenuName(RequestProperties reqState) {
        return "menu.admin";
    }

    public String getMenuDescription(RequestProperties reqState, String parentMenuName) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(AlertPanel.class);
        return super._getMenuDescription(reqState, i18n.getString("AlertPanel.editMenuDesc", "Monitor Alerts"));
    }

    public String getMenuHelp(RequestProperties reqState, String parentMenuName) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(AlertPanel.class);
        return super._getMenuHelp(reqState, i18n.getString("AlertPanel.editMenuHelp", "Monitor Alerts"));
    }

    public String getNavigationDescription(RequestProperties reqState) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(AlertPanel.class);
        return super._getNavigationDescription(reqState, i18n.getString("AlertPanel.navDesc", "Monitor Alerts"));
    }

    public String getNavigationTab(RequestProperties reqState) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(AlertPanel.class);
        return super._getNavigationTab(reqState, i18n.getString("AlertPanel.navTab", "Monitor Alerts"));
    }

    public String[] getChildAclList() {
        return _ACL_LIST;
    }

    public String getJspURI() {
        return super.getJspURI();
    }

    public String getTarget() {
        return "AlertPanel";
    }

    public PixelDimension getWindowDimension() {
        return new PixelDimension(411, 130);
    }

    private String filter(String s) {
        if (StringTools.isBlank((String)s)) {
            return "&nbsp;";
        }
        return s;
    }

    public void writePage(final RequestProperties reqState, String pageMsg) throws IOException {
        String devAlertTitle;
        String alertPageName;
        WebPage devAlertPage;
        boolean ruleExists;
        final HttpServletRequest request = reqState.getHttpServletRequest();
        PrivateLabel privLabel = reqState.getPrivateLabel();
        final I18N i18n = privLabel.getI18N(AlertPanel.class);
        Locale locale = reqState.getLocale();
        String[] devTitles = reqState.getDeviceTitles();
        Account currAcct = reqState.getCurrentAccount();
        User currUser = reqState.getCurrentUser();
        String pageName = this.getPageName();
        final String ruleName = this.getProperties().getString(PROP_ruleName, DEFAULT_ALERT_RULE);
        final int pollInterval = this.getProperties().getInt(PROP_pollInterval, 10);
        final boolean bindToParent = this.getProperties().getBoolean(PROP_bindToParentWindow, true);
        RuleFactory ruleFact = Device.getRuleFactory();
        if (StringTools.isBlank((String)ruleName)) {
            ruleExists = false;
        } else if (ruleName.startsWith("@")) {
            ruleExists = ruleName.equalsIgnoreCase("@devnotify");
        } else if (ruleFact == null) {
            ruleExists = false;
        } else {
            String ruleSel = ruleFact.getRuleSelector(currAcct, ruleName);
            boolean bl = ruleExists = !StringTools.isBlank((String)ruleSel);
        }
        if (!ruleExists) {
            Print.logWarn((String)("AlertPanel rule not yet defined: " + ruleName), (Object[])new Object[0]);
        }
        final String devAlertPageURL = (devAlertPage = privLabel.getWebPage(alertPageName = this.getProperties().getString(PROP_alertPageName, "dev.alerts"))) != null ? devAlertPage.encodePageURL(reqState) + "&" + "isAutoRefresh" + "=false" : "(Device Alerts)";
        String string = devAlertTitle = devAlertPage != null ? devAlertPage.getNavigationDescription(reqState) : "";
        if (devAlertPage == null) {
            Print.logInfo((String)"Page 'dev.alerts' not found", (Object[])new Object[0]);
        }
        final String alertOff = this.getProperties().getString(PROP_alertText_off, i18n.getString("AlertPanel.alertOff", "Alert Monitor"));
        final String alertOn = this.getProperties().getString(PROP_alertText_on, i18n.getString("AlertPanel.alertOn", "Alert Detected"));
        final String noAlerts = this.getProperties().getString(PROP_actionText_off, i18n.getString("AlertPanel.actionOff", "No Alert Dectected"));
        final String gotoAlerts = this.getProperties().getString(PROP_actionText_on, i18n.getString("AlertPanel.actionOn", "View {0}", (Object)devAlertTitle));
        final String soundURL_on = this.getProperties().getString(PROP_actionSound_on, "");
        final String soundURL_off = this.getProperties().getString(PROP_actionSound_off, "");
        final String updateSeconds = i18n.getString("AlertPanel.updateSeconds", "seconds to update");
        final String pleaseLogin = i18n.getString("AlertPanel.pleaseLogin", "Please Login");
        final String sessionExpire = i18n.getString("AlertPanel.sessionExpired", "Session Expired");
        final String openerClosed = i18n.getString("AlertPanel.openerClosed", "Parent Browser Window Closed");
        String noRuleDefined = i18n.getString("AlertPanel.ruleNotDefined", "Rule not defined: {0}", (Object)ruleName);
        String m = pageMsg;
        boolean error = false;
        HTMLOutput HTML_CSS = new HTMLOutput(){

            public void write(PrintWriter out) throws IOException {
                String cssDir = AlertPanel.this.getCssDirectory();
                WebPageAdaptor.writeCssLink((PrintWriter)out, (RequestProperties)reqState, (String)"AlertPanel.css", (String)cssDir);
            }
        };
        HTMLOutput HTML_JS = new HTMLOutput(){

            public void write(PrintWriter out) throws IOException {
                String ruleURL = RequestProperties.TRACK_BASE_URI() + "?" + "page" + "=" + "RULE_EVAL" + "&" + "rule" + "=" + ruleName;
                JavaScriptTools.writeStartJavaScript((PrintWriter)out);
                out.write("// AlertPanel vars\n");
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"RULE_NAME", (Object)ruleName);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"RULE_EVAL_URL", (Object)ruleURL);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"RuleRefreshInterval", (Object)pollInterval);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"RuleRefreshCount", (Object)0);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"RuleRefreshTimer", null);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"BIND_TO_PARENT", (Object)bindToParent);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_Refresh", (Object)i18n.getString("AlertPanel.refresh", "Refresh"));
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_Alert", (Object)i18n.getString("AlertPanel.alert", "Alert"));
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_Alert_Off", (Object)alertOff);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_Alert_On", (Object)alertOn);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_No_Alerts", (Object)noAlerts);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_Goto_Alerts", (Object)gotoAlerts);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_Seconds_To_Update", (Object)updateSeconds);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_Please_Login", (Object)pleaseLogin);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_Session_Expired", (Object)sessionExpire);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"TEXT_Opener_Closed", (Object)openerClosed);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"URL_Alert_Page", (Object)devAlertPageURL);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SOUND_URL_Off", (Object)soundURL_off);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SOUND_URL_On", (Object)soundURL_on);
                JavaScriptTools.writeJSVar((PrintWriter)out, (String)"SOUND_URL_On_LOOP", (Object)false);
                JavaScriptTools.writeEndJavaScript((PrintWriter)out);
                JavaScriptTools.writeJSInclude((PrintWriter)out, (String)JavaScriptTools.qualifyJSFileRef((String)"NotifyAlert.js"), (HttpServletRequest)request);
            }
        };
        HTMLOutput HTML_CONTENT = null;
        HTML_CONTENT = new HTMLOutput(CommonServlet.CSS_CONTENT_FRAME, m){

            public void write(PrintWriter out) throws IOException {
                String selectURL = AlertPanel.this.encodePageURL(reqState);
                String CSS_ALERT_TABLE = "alertTable";
                String CSS_ALERT_IMAGE_OFF = "alertImage_off";
                String CSS_ALERT_STATE_TEXT_OFF = "alertStateText_off";
                String CSS_ALERT_ACTION_TEXT_OFF = "alertActionText_off";
                String CSS_ALERT_POLL_INTERVAL = "alertPollInterval";
                String CSS_ALERT_RULE_NAME = "alertRuleName";
                String ID_ALERT_IMAGE = "alertImage";
                String ID_ALERT_STATE_TEXT = "alertStateText";
                String ID_ALERT_ACTION_TEXT = "alertActionText";
                String ID_ALERT_ACTION_SOUND = "alertActionSound";
                String ID_ALERT_POLL_INTERVAL = "alertPollInterval";
                out.println("<span id='" + ID_ALERT_ACTION_SOUND + "'></span>");
                out.println("<table class='" + CSS_ALERT_TABLE + "'>");
                out.println("<tr>");
                out.println("<td id='" + ID_ALERT_IMAGE + "' class='" + CSS_ALERT_IMAGE_OFF + "'>");
                out.println("&nbsp;");
                out.println("</td>");
                out.println("<td>");
                out.println("<table border='0' cellspacing='0' cellpadding='0' height='100%' width='100%' style='padding: 7px 5px 7px 0px;'>");
                out.println("<tr><td id='" + ID_ALERT_STATE_TEXT + "' class='" + CSS_ALERT_STATE_TEXT_OFF + "'>");
                out.println(alertOff + " <span class='" + CSS_ALERT_RULE_NAME + "'>(" + ruleName + ")</span>");
                out.println("</td></tr>");
                out.println("<tr><td id='" + ID_ALERT_ACTION_TEXT + "' class='" + CSS_ALERT_ACTION_TEXT_OFF + "'>");
                out.println(noAlerts);
                out.println("</td></tr>");
                out.println("<tr><td id='" + ID_ALERT_POLL_INTERVAL + "' class='" + CSS_ALERT_POLL_INTERVAL + "'>");
                out.println(pollInterval + " " + updateSeconds);
                out.println("</td></tr>");
                out.println("</table>");
                out.println("</td>");
                out.println("</tr>");
                out.println("</table>");
            }
        };
        String onloadAlert = error ? AlertPanel.JS_alert((boolean)true, (String)m) : null;
        String onload = "javascript:ruleAlertOnLoad();";
        CommonServlet.writePageFrame((RequestProperties)reqState, (String)onload, null, (HTMLOutput)HTML_CSS, (HTMLOutput)HTML_JS, null, (HTMLOutput)HTML_CONTENT);
    }
}

