/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rulewar.report.field;

import java.util.List;
import java.util.Vector;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.rule.tables.NotifyQueue;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class NotifyQueueReport
extends ReportData {
    private I18N i18n = null;
    private List<FieldData> rowData = null;

    public NotifyQueueReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        this.i18n = reqState.getPrivateLabel().getI18N(NotifyQueueReport.class);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        int deviceCount = this.getDeviceCount();
        if (deviceCount <= 0) {
            throw new ReportException("No Devices specified");
        }
    }

    public void postInitialize() {
    }

    public boolean isSingleDeviceOnly() {
        return true;
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    public ReportLayout getReportLayout() {
        return NotifyQueueReport.GetReportLayout();
    }

    public DBDataIterator getBodyDataIterator() {
        final Account account = this.getAccount();
        String accountID = this.getAccountID();
        final long startTime = this.getTimeStart();
        final long endTime = this.getTimeEnd();
        this.rowData = new Vector<FieldData>();
        String deviceID2 = "";
        ReportDeviceList devList = this.getReportDeviceList();
        for (String deviceID2 : devList) {
            Device device;
            block6: {
                try {
                    device = devList.getDevice(deviceID2);
                    if (device == null) {
                        Print.logError((String)("Returned DeviceList 'Device' is null: " + deviceID2), (Object[])new Object[0]);
                    }
                    break block6;
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error retrieving EventData count for Device: " + deviceID2), (Object[])new Object[0]);
                }
                continue;
            }
            final String _accountID = device.getAccountID();
            final String _deviceID = device.getDeviceID();
            DBRecordHandler<NotifyQueue> rcdHandler = new DBRecordHandler<NotifyQueue>(){

                public int handleDBRecord(NotifyQueue rcd) throws DBException {
                    if (!_accountID.equals(rcd.getAccountID())) {
                        Print.logWarn((String)("NotifyQueue record AccountID does not match Device: " + rcd.getAccountID()), (Object[])new Object[0]);
                        return 1;
                    }
                    if (!_deviceID.equals(rcd.getDeviceID())) {
                        Print.logWarn((String)("NotifyQueue record DeviceID does not match Device: " + rcd.getDeviceID()), (Object[])new Object[0]);
                        return 1;
                    }
                    if (startTime > 0L && rcd.getTimestamp() < startTime) {
                        Print.logWarn((String)("NotifyQueue record timestamp < start: " + rcd.getTimestamp()), (Object[])new Object[0]);
                        return 1;
                    }
                    if (endTime > 0L && rcd.getTimestamp() > endTime) {
                        Print.logWarn((String)("NotifyQueue record timestamp > end: " + rcd.getTimestamp()), (Object[])new Object[0]);
                        return 1;
                    }
                    FieldData fd = new FieldData();
                    fd.setAccount(account);
                    fd.setDevice(device);
                    fd.setLong("timestamp", rcd.getTimestamp());
                    fd.setInt("statusCode", rcd.getStatusCode());
                    fd.setString("ruleId", rcd.getRuleID());
                    fd.setString("messageId", rcd.getMessageID());
                    NotifyQueueReport.this.rowData.add(fd);
                    return 1;
                }
            };
            try {
                NotifyQueue.getRecordCallback((String)accountID, (String)deviceID2, (long)startTime, (long)endTime, (DBRecordHandler)rcdHandler);
            }
            catch (DBException dbe) {
                Print.logException((String)"Error", (Throwable)dbe);
            }
        }
        FieldData.sortByDeviceDescription(this.rowData);
        return new ReportData.ListDataIterator((ReportData)this, this.rowData);
    }

    public DBDataIterator getTotalsDataIterator() {
        return null;
    }
}

