/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rulewar.report.field;

import java.util.List;
import java.util.Vector;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.rule.tables.FuelRegister;
import org.opengts.util.Print;
import org.opengts.war.report.DBDataIterator;
import org.opengts.war.report.ReportData;
import org.opengts.war.report.ReportDeviceList;
import org.opengts.war.report.ReportEntry;
import org.opengts.war.report.ReportException;
import org.opengts.war.report.ReportLayout;
import org.opengts.war.report.field.FieldData;
import org.opengts.war.report.field.FieldLayout;
import org.opengts.war.tools.RequestProperties;

public class FuelRegisterReport
extends ReportData {
    private List<FieldData> rowData = null;

    public FuelRegisterReport(ReportEntry rptEntry, RequestProperties reqState, ReportDeviceList devList) throws ReportException {
        super(rptEntry, reqState, devList);
        if (this.getAccount() == null) {
            throw new ReportException("Account-ID not specified");
        }
        int deviceCount = this.getDeviceCount();
        if (deviceCount < 1) {
            throw new ReportException("At least 1 Device must be specified");
        }
    }

    public void postInitialize() {
    }

    public static ReportLayout GetReportLayout() {
        return FieldLayout.getReportLayout();
    }

    public ReportLayout getReportLayout() {
        return FuelRegisterReport.GetReportLayout();
    }

    public DBDataIterator getBodyDataIterator() {
        Account account = this.getAccount();
        String accountID = this.getAccountID();
        long startTime = this.getTimeStart();
        long endTime = this.getTimeEnd();
        this.rowData = new Vector<FieldData>();
        String deviceID2 = "";
        ReportDeviceList devList = this.getReportDeviceList();
        for (String deviceID2 : devList) {
            Device device;
            block6: {
                try {
                    device = devList.getDevice(deviceID2);
                    if (device == null) {
                        Print.logError((String)("Returned DeviceList 'Device' is null: " + deviceID2), (Object[])new Object[0]);
                    }
                    break block6;
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error retrieving EventData count for Device: " + deviceID2), (Object[])new Object[0]);
                }
                continue;
            }
            DBRecordHandler<FuelRegister> rcdHandler = new DBRecordHandler<FuelRegister>(){

                public int handleDBRecord(FuelRegister rcd) throws DBException {
                    FieldData fd = new FieldData();
                    fd.setDevice(device);
                    fd.setLong("timestamp", rcd.getTimestamp());
                    fd.setInt("statusCode", rcd.getStatusCode());
                    fd.setDouble("latitude", rcd.getLatitude());
                    fd.setDouble("longitude", rcd.getLongitude());
                    fd.setDouble("startFuelLevel", rcd.getLastFuelLevel());
                    fd.setDouble("stopFuelLevel", rcd.getFuelLevel());
                    fd.setDouble("fuelLevel", rcd.getFuelLevel());
                    fd.setDouble("deltaFuelLevel", rcd.getDeltaFuelLevel());
                    fd.setDouble("fuelTotal", rcd.getFuelTotal());
                    fd.setDouble("odometer", rcd.getOdometerKM());
                    fd.setString("subdivision", rcd.getEventSubdivision(true));
                    fd.setString("address", rcd.getEventAddress(true));
                    FuelRegisterReport.this.rowData.add(fd);
                    return 1;
                }
            };
            try {
                FuelRegister.getRecordCallback((String)accountID, (String)deviceID2, (long)startTime, (long)endTime, (DBRecordHandler)rcdHandler);
            }
            catch (DBException dbe) {
                Print.logException((String)"Error", (Throwable)dbe);
            }
        }
        FieldData.sortByDeviceDescription(this.rowData);
        return new ReportData.ListDataIterator((ReportData)this, this.rowData);
    }

    public DBDataIterator getTotalsDataIterator() {
        return null;
    }
}

