/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.astra;

import java.net.InetAddress;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.servers.astra.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.GeoPoint;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static String[] UNIQUEID_PREFIX = new String[]{"astra_", "imei_"};
    public static double MINIMUM_SPEED_KPH = 5.0;
    public static boolean ESTIMATE_ODOMETER = false;
    public static boolean SIMEVENT_GEOZONES = false;
    public static boolean XLATE_LOCATON_INMOTION = false;
    public static double MINIMUM_MOVED_METERS = 0.0;
    public static boolean DEBUG_MODE = false;
    private static final int[] laCrc16LookUpTable = new int[]{0, 49345, 49537, 320, 49921, 960, 640, 49729, 50689, 1728, 1920, 51009, 1280, 50625, 50305, 1088, 52225, 3264, 3456, 52545, 3840, 53185, 52865, 3648, 2560, 51905, 52097, 2880, 51457, 2496, 2176, 51265, 55297, 6336, 6528, 55617, 6912, 56257, 55937, 6720, 7680, 57025, 57217, 8000, 56577, 7616, 7296, 56385, 5120, 54465, 54657, 5440, 55041, 6080, 5760, 54849, 53761, 4800, 4992, 54081, 4352, 53697, 53377, 4160, 61441, 12480, 12672, 61761, 13056, 62401, 62081, 12864, 13824, 63169, 63361, 14144, 62721, 13760, 13440, 62529, 15360, 64705, 64897, 15680, 65281, 16320, 16000, 65089, 64001, 15040, 15232, 64321, 14592, 63937, 63617, 14400, 10240, 59585, 59777, 10560, 60161, 11200, 10880, 59969, 60929, 11968, 12160, 61249, 11520, 60865, 60545, 11328, 58369, 9408, 9600, 58689, 9984, 59329, 59009, 9792, 8704, 58049, 58241, 9024, 57601, 8640, 8320, 57409, 40961, 24768, 24960, 41281, 25344, 41921, 41601, 25152, 26112, 42689, 42881, 26432, 42241, 26048, 25728, 42049, 27648, 44225, 44417, 27968, 44801, 28608, 28288, 44609, 43521, 27328, 27520, 43841, 26880, 43457, 43137, 26688, 30720, 47297, 47489, 31040, 47873, 31680, 31360, 47681, 48641, 32448, 32640, 48961, 32000, 48577, 48257, 31808, 46081, 29888, 30080, 46401, 30464, 47041, 46721, 30272, 29184, 45761, 45953, 29504, 45313, 29120, 28800, 45121, 20480, 37057, 37249, 20800, 37633, 21440, 21120, 37441, 38401, 22208, 22400, 38721, 21760, 38337, 38017, 21568, 39937, 23744, 23936, 40257, 24320, 40897, 40577, 24128, 23040, 39617, 39809, 23360, 39169, 22976, 22656, 38977, 34817, 18624, 18816, 35137, 19200, 35777, 35457, 19008, 19968, 36545, 36737, 20288, 36097, 19904, 19584, 35905, 17408, 33985, 34177, 17728, 34561, 18368, 18048, 34369, 33281, 17088, 17280, 33601, 16640, 33217, 32897, 16448};
    private static byte PROTOCOL_K = (byte)75;
    private static byte PROTOCOL_M = (byte)77;
    private static int PROTOCOL_K_BASIC_LEN = 38;
    private static int PROTOCOL_K_START_STOP_LEN = 50;
    private static int PROTOCOL_M_BASIC_LEN = 41;
    private static int PROTOCOL_M_START_STOP_LEN = 53;
    private static int REASON_TIME_ELAPSED = 1;
    private static int REASON_DIST_TRAVELLED = 2;
    private static int REASON_POS_ON_DEMAND = 4;
    private static int REASON_GEO_FENCE = 8;
    private static int REASON_PANIC_SWITCH = 16;
    private static int REASON_EXT_INPUT = 32;
    private static int REASON_JOURNEY_START = 64;
    private static int REASON_JOURNEY_STOP = 128;
    private static int REASON_HEADING_CHANGE = 256;
    private static int REASON_LOW_BATTERY = 512;
    private static int REASON_EXT_POWER_EVENT = 1024;
    private static int REASON_IDLING_START = 2048;
    private static int REASON_IDLING_END = 4096;
    private static int REASON_IDLING_ONGOING = 8192;
    private static int REASON_POWER_ON = 16384;
    private static int REASON_SPEED_OVER_THRESHOLD = 32768;
    private static int REASON_TOWING_ALARM = 65536;
    private static int REASON_UNAUTHORISED_DRIVER = 131072;
    private static int REASON_COLLISION = 262144;
    private static int REASON_ACCEL_MAX = 524288;
    private static int REASON_CORNERING_MAX = 0x100000;
    private static int REASON_DECEL_MAX = 0x200000;
    private static int REASON_GPS_REACQUIRED = 0x400000;
    private static int REASON_CANBUS_EVENT = 0x800000;
    private static int STATUS_IGNITION_ON = 1;
    private static int STATUS_REPORTS_TO_FOLLOW = 16;
    private static int STATUS_EXTRA_DATA = 256;
    private static int GEOFENCE_ENTERED = 128;
    private String ipAddress = null;
    private int clientPort = 0;
    private Device device = null;
    private byte protocol = 0;
    private boolean addRawData = true;

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.ipAddress = inetAddr != null ? inetAddr.getHostAddress() : null;
        this.clientPort = this.getSessionInfo().getRemotePort();
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        int packetLength = 0;
        if (packet[0] == PROTOCOL_K || packet[0] == PROTOCOL_M) {
            this.protocol = packet[0];
            Payload p = new Payload(packet, 1, 2);
            packetLength = p.readUInt(2, 0, true);
            if (DEBUG_MODE) {
                Print.logInfo("Protocol: " + (char)this.protocol, new Object[0]);
            }
        }
        if (DEBUG_MODE) {
            Print.logInfo("Packet length: " + packetLength, new Object[0]);
        }
        return packetLength;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        if (pktBytes != null && pktBytes.length > 0) {
            byte[] rtn = null;
            if (DEBUG_MODE) {
                Print.logInfo("Recv[HEX]: " + StringTools.toHexString(pktBytes), new Object[0]);
            }
            if (this.protocol == PROTOCOL_K) {
                if (this.parseInsertRecord_K(pktBytes)) {
                    rtn = new byte[]{6};
                }
            } else if (this.protocol == PROTOCOL_M && this.parseInsertRecord_M(pktBytes)) {
                rtn = new byte[]{6};
            }
            return rtn;
        }
        Print.logInfo("Empty packet received ...", new Object[0]);
        return null;
    }

    private boolean parseInsertRecord_K(byte[] pktBytes) {
        int[] accelData = new int[6];
        boolean reportsToFollow = false;
        String rawData = "";
        Payload p = new Payload(pktBytes, pktBytes.length - 2, 2);
        int packetChecksum = p.readUInt(2, 0);
        int checksum = this.generateCheckSum(pktBytes, pktBytes.length);
        if (checksum != packetChecksum) {
            Print.logInfo("ERROR: Calculated checksum does not match packet checksum", new Object[0]);
            return false;
        }
        int index = 3;
        p = new Payload(pktBytes, index, 7);
        long tac = p.readULong(4, 0L, true);
        int msn = p.readUInt(3, 0, true);
        String imei = String.valueOf(tac) + String.valueOf(msn);
        Print.logInfo("IMEI: " + imei, new Object[0]);
        index += 7;
        this.device = DCServerFactory._loadDeviceByPrefixedModemID(UNIQUEID_PREFIX, imei);
        if (this.device == null) {
            return false;
        }
        do {
            double odometer;
            p = new Payload(pktBytes, index, PROTOCOL_K_BASIC_LEN);
            int sequenceNumber = p.readUInt(1, 0);
            int intLatitude = p.readInt(4, 0);
            int intLongitude = p.readInt(4, 0);
            double latitude = (double)intLatitude / 1000000.0;
            double longitude = (double)intLongitude / 1000000.0;
            GeoPoint geoPoint = new GeoPoint(latitude, longitude);
            long fixtime = p.readULong(4, 0L, true);
            fixtime += 315964800L;
            int intSpeed = p.readUInt(1, 0);
            double speed = (double)intSpeed * 2.0;
            int intHeading = p.readUInt(1, 0);
            double heading = (double)intHeading * 2.0;
            int repReason = p.readUInt(3, 0);
            int repStatus = p.readUInt(2, 0);
            int reportLen = (repStatus & STATUS_EXTRA_DATA) > 0 ? PROTOCOL_K_START_STOP_LEN : PROTOCOL_K_BASIC_LEN;
            int digitals = p.readUInt(1, 0);
            int intAdc1 = p.readUInt(1, 0);
            double adc1 = (double)intAdc1 * 20.0;
            adc1 /= 1000.0;
            int battLevel = p.readUInt(1, 0);
            int intExtPwr = p.readUInt(1, 0);
            double extPwr = (double)intExtPwr / 5.0;
            int maxSpeed = p.readUInt(1, 0);
            maxSpeed *= 2;
            for (int i = 0; i < 6; ++i) {
                accelData[i] = p.readUInt(1, 0);
            }
            int intJourneyDist = p.readUInt(2, 0);
            double journeyDist = (double)intJourneyDist / 10.0;
            int journeyIdleTime = p.readUInt(2, 0);
            int intAltitude = p.readUInt(1, 0);
            double altitude = (double)intAltitude * 20.0;
            int signalQuality = p.readUInt(1, 0);
            int geoFence = p.readUInt(1, 0);
            if ((repStatus & STATUS_EXTRA_DATA) > 0) {
                p = new Payload(pktBytes, index + 45, 3);
                int intOdometer = p.readUInt(3, 0);
                odometer = intOdometer;
            } else {
                odometer = 0.0;
            }
            if (DEBUG_MODE) {
                Print.logInfo("Seq Num: " + sequenceNumber, new Object[0]);
                Print.logInfo("GPS: " + geoPoint, new Object[0]);
                Print.logInfo("Time: " + fixtime, new Object[0]);
                Print.logInfo("Speed: " + speed, new Object[0]);
                Print.logInfo("Heading: " + heading, new Object[0]);
                Print.logInfo("Journey Dist: " + journeyDist, new Object[0]);
                Print.logInfo("Altitude: " + altitude, new Object[0]);
                Print.logInfo("Odometer: " + odometer, new Object[0]);
            }
            int statusCode = this.determineGTSStatusCode(repReason, repStatus, extPwr, geoFence);
            if (this.addRawData) {
                rawData = "R=" + StringTools.toHexString(repReason, 24) + ";S=" + StringTools.toHexString(repStatus, 16) + ";P=" + extPwr + "V" + ";B=" + battLevel + "%" + ";D=" + StringTools.toHexString(digitals, 8) + ";A1=" + adc1 + "V" + ";M=" + maxSpeed + "km/h" + ";X=" + accelData[0] + "," + accelData[1] + ";Y=" + accelData[2] + "," + accelData[3] + ";Z=" + accelData[4] + "," + accelData[5] + ";I=" + journeyIdleTime + "s" + ";Q=" + StringTools.toHexString(signalQuality, 8) + ";G=" + StringTools.toHexString(geoFence, 8);
            }
            this.insertEventRecord(this.device, fixtime, statusCode, geoPoint, speed, heading, altitude, journeyDist, odometer, rawData);
            if ((repStatus & STATUS_REPORTS_TO_FOLLOW) > 0) {
                reportsToFollow = true;
                index += reportLen;
                continue;
            }
            reportsToFollow = false;
        } while (reportsToFollow);
        return true;
    }

    private boolean parseInsertRecord_M(byte[] pktBytes) {
        int[] accelData = new int[6];
        boolean reportsToFollow = false;
        String rawData = "";
        Payload p = new Payload(pktBytes, pktBytes.length - 2, 2);
        int packetChecksum = p.readUInt(2, 0);
        int checksum = this.generateCheckSum(pktBytes, pktBytes.length);
        if (checksum != packetChecksum) {
            Print.logInfo("ERROR: Calculated checksum does not match packet checksum", new Object[0]);
            return false;
        }
        int index = 3;
        p = new Payload(pktBytes, index, 7);
        long tac = p.readULong(4, 0L, true);
        int msn = p.readUInt(3, 0, true);
        String imei = String.valueOf(tac) + String.valueOf(msn);
        Print.logInfo("IMEI: " + imei, new Object[0]);
        index += 7;
        this.device = DCServerFactory._loadDeviceByPrefixedModemID(UNIQUEID_PREFIX, imei);
        if (this.device == null) {
            return false;
        }
        do {
            double odometer;
            p = new Payload(pktBytes, index, PROTOCOL_M_BASIC_LEN);
            int sequenceNumber = p.readUInt(1, 0);
            int intLatitude = p.readInt(4, 0);
            int intLongitude = p.readInt(4, 0);
            double latitude = (double)intLatitude / 1000000.0;
            double longitude = (double)intLongitude / 1000000.0;
            GeoPoint geoPoint = new GeoPoint(latitude, longitude);
            long fixtime = p.readULong(4, 0L, true);
            fixtime += 315964800L;
            int intSpeed = p.readUInt(1, 0);
            double speed = (double)intSpeed * 2.0;
            int intHeading = p.readUInt(1, 0);
            double heading = (double)intHeading * 2.0;
            int repReason = p.readUInt(3, 0);
            int repStatus = p.readUInt(2, 0);
            int reportLen = (repStatus & STATUS_EXTRA_DATA) > 0 ? PROTOCOL_M_START_STOP_LEN : PROTOCOL_M_BASIC_LEN;
            int digitals = p.readUInt(3, 0, false);
            int intAdc1 = p.readUInt(1, 0);
            double adc1 = (double)intAdc1 * 20.0;
            adc1 /= 1000.0;
            int intAdc2 = p.readUInt(1, 0);
            double adc2 = (double)intAdc2 * 59.0;
            adc2 /= 1000.0;
            int battLevel = p.readUInt(1, 0);
            int intExtPwr = p.readUInt(1, 0);
            double extPwr = (double)intExtPwr / 5.0;
            int maxSpeed = p.readUInt(1, 0);
            maxSpeed *= 2;
            for (int i = 0; i < 6; ++i) {
                accelData[i] = p.readUInt(1, 0);
            }
            int intJourneyDist = p.readUInt(2, 0);
            double journeyDist = (double)intJourneyDist / 10.0;
            int journeyIdleTime = p.readUInt(2, 0);
            int intAltitude = p.readUInt(1, 0);
            double altitude = (double)intAltitude * 20.0;
            int signalQuality = p.readUInt(1, 0);
            int geoFence = p.readUInt(1, 0);
            if ((repStatus & STATUS_EXTRA_DATA) > 0) {
                p = new Payload(pktBytes, index + 48, 3);
                int intOdometer = p.readUInt(3, 0);
                odometer = intOdometer;
            } else {
                odometer = 0.0;
            }
            if (DEBUG_MODE) {
                Print.logInfo("Seq Num: " + sequenceNumber, new Object[0]);
                Print.logInfo("GPS: " + geoPoint, new Object[0]);
                Print.logInfo("Time: " + fixtime, new Object[0]);
                Print.logInfo("Speed: " + speed, new Object[0]);
                Print.logInfo("Heading: " + heading, new Object[0]);
                Print.logInfo("Journey Dist: " + journeyDist, new Object[0]);
                Print.logInfo("Altitude: " + altitude, new Object[0]);
                Print.logInfo("Odometer: " + odometer, new Object[0]);
            }
            int statusCode = this.determineGTSStatusCode(repReason, repStatus, extPwr, geoFence);
            if (this.addRawData) {
                rawData = "R=" + StringTools.toHexString(repReason, 24) + ";S=" + StringTools.toHexString(repStatus, 16) + ";P=" + extPwr + "V" + ";B=" + battLevel + "%" + ";D=" + StringTools.toHexString(digitals, 24) + ";A1=" + adc1 + "V" + ";A2=" + adc2 + "V" + ";M=" + maxSpeed + "km/h" + ";X=" + accelData[0] + "," + accelData[1] + ";Y=" + accelData[2] + "," + accelData[3] + ";Z=" + accelData[4] + "," + accelData[5] + ";I=" + journeyIdleTime + "s" + ";Q=" + StringTools.toHexString(signalQuality, 8) + ";G=" + StringTools.toHexString(geoFence, 8);
            }
            this.insertEventRecord(this.device, fixtime, statusCode, geoPoint, speed, heading, altitude, journeyDist, odometer, rawData);
            if ((repStatus & STATUS_REPORTS_TO_FOLLOW) > 0) {
                reportsToFollow = true;
                index += reportLen;
                continue;
            }
            reportsToFollow = false;
        } while (reportsToFollow);
        return true;
    }

    private int determineGTSStatusCode(int repReason, int repStatus, double extPwr, int geoFence) {
        int statusCode = 0;
        statusCode = (repReason & REASON_JOURNEY_START) > 0 ? 62465 : ((repReason & REASON_JOURNEY_STOP) > 0 ? 62467 : ((repReason & REASON_TIME_ELAPSED) > 0 ? ((repStatus & STATUS_IGNITION_ON) > 0 ? ((repReason & REASON_IDLING_ONGOING) > 0 ? 61720 : 61714) : 61716) : ((repReason & REASON_IDLING_START) > 0 ? 61718 : ((repReason & REASON_IDLING_END) > 0 ? 61713 : ((repReason & REASON_DIST_TRAVELLED) > 0 ? 61724 : ((repReason & REASON_HEADING_CHANGE) > 0 ? 61727 : ((repReason & REASON_SPEED_OVER_THRESHOLD) > 0 ? 61722 : ((repReason & REASON_PANIC_SWITCH) > 0 ? 63553 : ((repReason & REASON_EXT_POWER_EVENT) > 0 ? (extPwr > 7.0 ? 64793 : 64791) : ((repReason & REASON_EXT_INPUT) > 0 ? 62464 : ((repReason & REASON_LOW_BATTERY) > 0 ? 64784 : ((repReason & REASON_ACCEL_MAX) > 0 ? 63840 : ((repReason & REASON_DECEL_MAX) > 0 ? 63792 : ((repReason & REASON_CORNERING_MAX) > 0 ? 63799 : ((repReason & REASON_COLLISION) > 0 ? 63809 : ((repReason & REASON_TOWING_ALARM) > 0 ? 63601 : ((repReason & REASON_GEO_FENCE) > 0 ? ((geoFence & GEOFENCE_ENTERED) > 0 ? 61968 : 62000) : ((repReason & REASON_POWER_ON) > 0 ? 61456 : ((repReason & REASON_GPS_REACQUIRED) > 0 ? 61536 : ((repReason & REASON_POS_ON_DEMAND) > 0 ? 61504 : ((repReason & REASON_UNAUTHORISED_DRIVER) > 0 ? 63625 : 61508)))))))))))))))))))));
        return statusCode;
    }

    private int generateCheckSum(byte[] bytPacketDatam, int packetLen) {
        int llcrc = 65535;
        for (int lnPos = 0; lnPos < packetLen - 2; ++lnPos) {
            int llChar = (llcrc ^ bytPacketDatam[lnPos]) & 0xFF;
            llChar = laCrc16LookUpTable[llChar];
            llcrc = llcrc >> 8 ^ llChar;
        }
        return llcrc;
    }

    private EventData createEventRecord(Device device, long gpsTime, int statusCode, GeoPoint geoPoint, double speedKPH, double heading, double altitudeM, double distanceKM, double odomKM, String rawData) {
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        EventData.Key evKey = new EventData.Key(accountID, deviceID, gpsTime, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        evdb.setGeoPoint(geoPoint);
        evdb.setSpeedKPH(speedKPH);
        evdb.setHeading(heading);
        evdb.setAltitude(altitudeM);
        evdb.setDistanceKM(distanceKM);
        evdb.setOdometerKM(odomKM);
        evdb.setRawData(rawData);
        return evdb;
    }

    private void insertEventRecord(Device device, long gpsTime, int statusCode, GeoPoint geoPoint, double speedKPH, double heading, double altitudeM, double distanceKM, double odomKM, String rawData) {
        EventData evdb = this.createEventRecord(device, gpsTime, statusCode, geoPoint, speedKPH, heading, altitudeM, distanceKM, odomKM, rawData);
        Print.logInfo("Event: [0x" + StringTools.toHexString(statusCode, 16) + "] " + StatusCodes.GetDescription(statusCode, null), new Object[0]);
        if (!DEBUG_MODE) {
            device.insertEventData(evdb);
            this.incrementSavedEventCount();
        }
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig();
        if (dcsc != null) {
            UNIQUEID_PREFIX = dcsc.getUniquePrefix();
            MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
            ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
            SIMEVENT_GEOZONES = dcsc.getSimulateGeozones(SIMEVENT_GEOZONES);
            XLATE_LOCATON_INMOTION = dcsc.getStatusLocationInMotion(XLATE_LOCATON_INMOTION);
            MINIMUM_MOVED_METERS = dcsc.getMinimumMovedMeters(MINIMUM_MOVED_METERS);
        }
    }
}

