/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.servers.tzavl08;

import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBAdmin;
import org.opengts.opt.servers.DCServerAttributes;
import org.opengts.opt.servers.tzavl08.AVL08CommandHandler;
import org.opengts.opt.servers.tzavl08.Constants;
import org.opengts.opt.servers.tzavl08.TrackClientPacketHandler;
import org.opengts.opt.servers.tzavl08.TrackServer;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Main {
    public static final String[] ARG_HELP = new String[]{"help", "h"};
    public static final String[] ARG_CMD_PORT = new String[]{"command", "cmd"};
    public static final String[] ARG_START = new String[]{"start"};
    private static DCServerConfig dcServerCfg = null;

    public static String DCServerFactory_LoadName() {
        return Main.getServerContextName();
    }

    public static String getServerName() {
        return "tzavl08";
    }

    public static String getServerContextName() {
        return RTConfig.getContextName((String)Main.getServerName());
    }

    public static DCServerConfig getServerConfig(Device device) {
        if (dcServerCfg == null) {
            dcServerCfg = DCServerFactory.getServerConfig((String)Main.getServerContextName(), (boolean)true);
            DCServerConfig.startRemoteLogging((DCServerConfig)dcServerCfg);
        }
        return dcServerCfg;
    }

    private static void usage(String string) {
        String string2 = TrackServer.getTcpPortsString(Main.getServerConfig(null));
        String string3 = TrackServer.getUdpPortsString(Main.getServerConfig(null));
        if (string != null) {
            Print.logInfo((String)string, (Object[])new Object[0]);
        }
        Print.logInfo((String)"", (Object[])new Object[0]);
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + Main.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  [-h[elp]]           Print this help", (Object[])new Object[0]);
        Print.logInfo((String)"  [-port=<p>[,<p>]]   Server TCP/UDP port(s) to listen", (Object[])new Object[0]);
        Print.logInfo((String)("  [-tcp=<p>[,<p>]]    Server TCP port(s) to listen on [dft=" + string2 + "]"), (Object[])new Object[0]);
        Print.logInfo((String)("  [-udp=<p>[,<p>]]    Server UDP port(s) to listen on [dft=" + string3 + "]"), (Object[])new Object[0]);
        Print.logInfo((String)"  -start              Start server on the specified port", (Object[])new Object[0]);
        Print.logInfo((String)"", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        DCServerConfig dCServerConfig;
        if (!ListTools.isEmpty((Object[])stringArray) && stringArray[0].equalsIgnoreCase("Constants")) {
            dCServerConfig = (DCServerConfig)ListTools.toArray((Object[])stringArray, (int)1, (int)(stringArray.length - 1));
            Constants.main((String[])dCServerConfig);
            System.exit(0);
        }
        DBConfig.cmdLineInit((String[])stringArray, (boolean)false);
        DBConfig.check_GTS_HOME();
        if ("time".equals(RTConfig.getString((String)"xpire", (String)""))) {
            Print.logInfo((String)"n/a", (Object[])new Object[0]);
            System.exit(1);
        }
        dCServerConfig = Main.getServerConfig(null);
        TrackClientPacketHandler.configInit();
        TrackServer.configInit();
        boolean bl = false;
        long l = DateTime.getCurrentTimeSec();
        bl = false;
        DCServerAttributes.beginPrintDCSHeader(Main.getServerConfig(null), Main.getServerContextName(), "TZone AVL-08", "0.2.3", "Copyright 2007-2013, GeoTelematic Solutions, Inc.", "mutinda", bl, 0L, 0L, 1381279040L, TrackClientPacketHandler.THROTTLE_MSG);
        Print.logInfo((String)("Minimum Speed (km/h)  : " + TrackClientPacketHandler.MINIMUM_SPEED_KPH), (Object[])new Object[0]);
        Print.logInfo((String)("Estimate GPS Odometer : " + TrackClientPacketHandler.ESTIMATE_ODOMETER), (Object[])new Object[0]);
        Print.logInfo((String)("Simulate Arrive/Depart: " + TrackClientPacketHandler.SIMEVENT_GEOZONES), (Object[])new Object[0]);
        Print.logInfo((String)("Battery Level Range   : " + StringTools.join((double[])TrackClientPacketHandler.BATTERY_LEVEL_RANGE, (String)",")), (Object[])new Object[0]);
        Print.logInfo((String)("Analog #1             : " + (Object)((Object)TrackClientPacketHandler.GetAnalogField(1))), (Object[])new Object[0]);
        Print.logInfo((String)("Analog #2             : " + (Object)((Object)TrackClientPacketHandler.GetAnalogField(2))), (Object[])new Object[0]);
        DCServerAttributes.endPrintDCSHeader();
        if (RTConfig.getBoolean((String[])ARG_HELP, (boolean)false)) {
            Main.usage("Help ...");
        }
        if (!DBAdmin.verifyTablesExist()) {
            Print.logFatal((String)"MySQL database has not yet been properly initialized", (Object[])new Object[0]);
            System.exit(1);
        }
        if (RTConfig.getBoolean((String[])ARG_START, (boolean)false)) {
            TrackServer.startTrackServer(dCServerConfig, TrackServer.class, AVL08CommandHandler.class, true);
        }
        Main.usage("Missing '-start' ...");
    }
}

