/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.servers.tzavl08;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.opengts.db.CommandPacketHandler;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Device;
import org.opengts.opt.servers.tzavl08.Main;
import org.opengts.opt.servers.tzavl08.TrackServer;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.ServerSocketThread;
import org.opengts.util.StringTools;

public class AVL08CommandHandler
extends CommandPacketHandler {
    public String getServerName() {
        return "tzavl08";
    }

    public int getClientCommandPort_udp(int n) {
        DCServerConfig dCServerConfig = Main.getServerConfig(null);
        int n2 = dCServerConfig.getClientCommandPort_udp(0);
        return n2 > 0 ? n2 : n;
    }

    public DCServerFactory.ResultCode handleCommand(Device device, String string, String string2, String[] stringArray) {
        DCServerConfig dCServerConfig;
        DCServerConfig.Command command;
        Print.logInfo((String)"Recv Cmd: type=%s name=%s arg=%s", (Object[])new Object[]{string, string2, StringTools.join((String[])stringArray, (char)',')});
        if (device == null) {
            return DCServerFactory.ResultCode.INVALID_DEVICE;
        }
        if (string.equalsIgnoreCase("ping")) {
            string = "config";
            string2 = "LocateNow";
        }
        if ((command = (dCServerConfig = Main.getServerConfig(null)).getCommand(string2)) == null) {
            Print.logWarn((String)("Command not found: " + string2), (Object[])new Object[0]);
            return DCServerFactory.ResultCode.INVALID_COMMAND;
        }
        String string3 = command.getCommandString(device, stringArray);
        DCServerConfig.CommandProtocol commandProtocol = command.getCommandProtocol(DCServerConfig.CommandProtocol.UDP);
        if (commandProtocol == null) {
            return DCServerFactory.ResultCode.INVALID_PROTO;
        }
        if (commandProtocol.equals((Object)DCServerConfig.CommandProtocol.SMS)) {
            String string4 = StringTools.trim((String)string3);
            String string5 = command.getCommandProtocolHandler();
            DCServerFactory.ResultCode resultCode = DCServerFactory.SendSMSCommand((String)string5, (Device)device, (String)string4);
            command.setDeviceCommandAttributes(resultCode, device, string4, true);
            return resultCode;
        }
        if (!string.equalsIgnoreCase("config")) {
            return DCServerFactory.ResultCode.INVALID_COMMAND;
        }
        if (commandProtocol.equals((Object)DCServerConfig.CommandProtocol.UDP)) {
            Print.logDebug((String)"UDP ConfigCmd [device=%s, cmd=%s]", (Object[])new Object[]{device.getDeviceID(), string2});
            String string6 = StringTools.trim((String)string3);
            byte[] byArray = string6.getBytes();
            DCServerFactory.ResultCode resultCode = this.sendCommandPacket_udp(device, string, byArray);
            command.setDeviceCommandAttributes(resultCode, device, string6, true);
            return resultCode;
        }
        if (commandProtocol.equals((Object)DCServerConfig.CommandProtocol.TCP)) {
            Print.logDebug((String)"TCP ConfigCmd [device=%s, cmd=%s]", (Object[])new Object[]{device.getDeviceID(), string2});
            String string7 = StringTools.trim((String)string3);
            byte[] byArray = string7.getBytes();
            DCServerFactory.ResultCode resultCode = this.sendCommandPacket_tcp(device, string, byArray);
            command.setDeviceCommandAttributes(resultCode, device, string7, true);
            return resultCode;
        }
        return DCServerFactory.ResultCode.INVALID_PROTO;
    }

    private DCServerFactory.ResultCode sendCommandPacket_udp(Device device, String string, byte[] byArray) {
        if (ListTools.isEmpty((byte[])byArray)) {
            Print.logError((String)"Command packet is null/empty (%s)", (Object[])new Object[]{string});
            return DCServerFactory.ResultCode.INVALID_ARG;
        }
        int n = device.getListenPortCurrent();
        String string2 = StringTools.trim((Object)device.getIpAddressCurrent());
        int n2 = this.getClientCommandPort_udp(device.getRemotePortCurrent());
        long l = DateTime.getCurrentTimeSec() - device.getLastTotalConnectTime();
        if (StringTools.isBlank((String)string2) || string2.equals("0.0.0.0") || n2 <= 0) {
            Print.logError((String)"Device host:port not known> %s:%d", (Object[])new Object[]{string2, n2});
            return DCServerFactory.ResultCode.UNKNOWN_HOST;
        }
        Print.logInfo((String)"Send '%s:%d' (age %dsec) [%s] 0x%s", (Object[])new Object[]{string2, n2, l, string, StringTools.toStringValue((byte[])byArray, (char)'.')});
        try {
            this.sendDatagramMessage(n, string2, n2, byArray);
            return DCServerFactory.ResultCode.SUCCESS;
        }
        catch (Throwable throwable) {
            Print.logException((String)"UDP transmit failure", (Throwable)throwable);
            return DCServerFactory.ResultCode.TRANSMIT_FAIL;
        }
    }

    private void sendDatagramMessage(int n, String string, int n2, byte[] byArray) throws IOException {
        boolean bl = false;
        DatagramSocket datagramSocket = TrackServer.getInstance().getUdpDatagramSocket(n);
        if (datagramSocket == null) {
            Print.logWarn((String)"Creating temporary DatagramSocket for transmission", (Object[])new Object[0]);
            datagramSocket = ServerSocketThread.createDatagramSocket((int)0);
            bl = true;
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(string), n2);
        Print.logInfo((String)"Sending Datagram (from %s:%d) to %s:%d> 0x%s", (Object[])new Object[]{StringTools.trim((Object)datagramSocket.getLocalAddress()), datagramSocket.getLocalPort(), string, n2, StringTools.toHexString((byte[])byArray)});
        datagramSocket.send(datagramPacket);
        if (bl) {
            datagramSocket.close();
        }
    }

    private DCServerFactory.ResultCode sendCommandPacket_tcp(Device device, String string, byte[] byArray) {
        if (ListTools.isEmpty((byte[])byArray)) {
            Print.logError((String)"Command packet is null/empty (%s)", (Object[])new Object[]{string});
            return DCServerFactory.ResultCode.INVALID_ARG;
        }
        DCServerConfig dCServerConfig = Main.getServerConfig(null);
        String string2 = device.getAccountID() + "/" + device.getDeviceID();
        int n = device.getListenPortCurrent();
        long l = DateTime.getCurrentTimeSec() - device.getLastTotalConnectTime();
        ServerSocketThread serverSocketThread = TrackServer.getInstance().getServerSocketThread_tcp(n);
        if (serverSocketThread != null) {
            boolean bl = serverSocketThread.tcpWriteToSessionID(string2, byArray);
            if (bl) {
                return DCServerFactory.ResultCode.SUCCESS;
            }
            return DCServerFactory.ResultCode.NO_SESSION;
        }
        Print.logError((String)("TCP commands not supported for this port: " + n), (Object[])new Object[0]);
        return DCServerFactory.ResultCode.TRANSMIT_FAIL;
    }

    public static void main(String[] stringArray) {
        RTConfig.setCommandLineArgs((String[])stringArray);
        AVL08CommandHandler aVL08CommandHandler = new AVL08CommandHandler();
    }
}

