/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.servers;

import java.net.BindException;
import java.net.DatagramSocket;
import org.opengts.Version;
import org.opengts.db.CommandPacketHandler;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.RuleFactory;
import org.opengts.db.tables.Device;
import org.opengts.util.ClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OrderedMap;
import org.opengts.util.PosixSignalHandler;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.ServerSocketThread;
import org.opengts.util.StringTools;

public abstract class TrackServerAdapter {
    public static boolean TEST_MODE = false;
    public static final long TIMEOUT_TCP_IDLE = 10000L;
    public static final long TIMEOUT_TCP_PACKET = 4000L;
    public static final long TIMEOUT_TCP_SESSION = 15000L;
    public static final long TIMEOUT_UDP_IDLE = 1000L;
    public static final long TIMEOUT_UDP_PACKET = 1000L;
    public static final long TIMEOUT_UDP_SESSION = 2000L;
    public static final int LINGER_ON_CLOSE_SEC = 3;
    public static final String SEP_DASH = "--------------------------------------------------------------------------";
    public static final String SEP_EQUAL = "==========================================================================";
    public static final String SEP_STAR = "**************************************************************************";
    public static final String SEP = "--------------------------------------------------------------------------";
    private static int lastPrintIncludeStackFrameState = -1;
    public static final long SHUTDOWN_TIMEOUT = 4000L;
    public static final String[] SHUTDOWN_SIGNALS = new String[]{"SIGTERM"};
    private static TrackServerAdapter trackServerInstance = null;
    private DCServerConfig dcsConfig = null;
    private OrderedMap<Integer, ServerSocketThread> tcpThread = null;
    private OrderedMap<Integer, ServerSocketThread> udpThread = null;
    private OrderedMap<Integer, DatagramSocket> udpSocket = null;
    private ServerSocketThread cmdThread = null;

    public static void Log(String string, int n, String string2) {
        int n2 = n < 20 ? 20 : n;
        String string3 = StringTools.leftAlign((String)string, (int)n2);
        Print.logInfo((String)(string3 + ": " + string2), (Object[])new Object[0]);
    }

    public static void PrintHeaderLogs(DCServerConfig dCServerConfig, int n) {
        if (dCServerConfig != null) {
            String string = TrackServerAdapter.getUniqueIDPrefixString(dCServerConfig);
            if (!StringTools.isBlank((String)string)) {
                TrackServerAdapter.Log("Unique-ID Prefix(s)", n, TrackServerAdapter.getUniqueIDPrefixString(dCServerConfig));
            }
            if (!RTConfig.isWebApp()) {
                TrackServerAdapter.Log("TCP Timeouts [ms]", n, "Idle=" + TrackServerAdapter.getTcpIdleTimeoutMS(dCServerConfig) + ", Packet=" + TrackServerAdapter.getTcpPacketTimeoutMS(dCServerConfig) + ", Session=" + TrackServerAdapter.getTcpSessionTimeoutMS(dCServerConfig));
                TrackServerAdapter.Log("UDP Timeouts [ms]", n, "Idle=" + TrackServerAdapter.getUdpIdleTimeoutMS(dCServerConfig) + ", Packet=" + TrackServerAdapter.getUdpPacketTimeoutMS(dCServerConfig) + ", Session=" + TrackServerAdapter.getUdpSessionTimeoutMS(dCServerConfig));
            }
        }
    }

    public static boolean beginPrintDCSHeader(DCServerConfig dCServerConfig, String string, String string2, String string3) {
        lastPrintIncludeStackFrameState = Print.setIncludeStackFrame((int)0);
        long l = 1381279040L;
        String string4 = "Copyright 2007-2013, GeoTelematic Solutions, Inc.";
        String string5 = StringTools.trim((String)RTConfig.getString((String)"ServiceAccount.ID", (String)""));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3);
        stringBuffer.append(", ");
        stringBuffer.append(l).append(" [").append(new DateTime(l).toString()).append("] S");
        String string6 = "n/a";
        RuleFactory ruleFactory = Device.getRuleFactory();
        if (ruleFactory != null) {
            string6 = ruleFactory.getVersion() + " (" + ruleFactory.getName() + ")";
        }
        int n = 20;
        Print.logInfo((String)"--------------------------------------------------------------------------", (Object[])new Object[0]);
        Print.logInfo((String)("[" + string + "] " + string2), (Object[])new Object[0]);
        Print.logInfo((String)string4, (Object[])new Object[0]);
        TrackServerAdapter.Log("Service ID", n, string5);
        TrackServerAdapter.Log("GTS Version", n, Version.getVersion());
        TrackServerAdapter.Log("DCS Version", n, stringBuffer.toString());
        TrackServerAdapter.Log("Rule Version", n, string6);
        TrackServerAdapter.Log("Jar File", n, RTConfig.getString((String)"%mainJar", (String)"?"));
        TrackServerAdapter.Log("GTS_HOME", n, StringTools.trim((Object)DBConfig.get_GTS_HOME()));
        TrackServerAdapter.PrintHeaderLogs(dCServerConfig, n);
        Print.logInfo((String)"--------------------------------------------------------------------------", (Object[])new Object[0]);
        return true;
    }

    public static void endPrintDCSHeader() {
        Print.logInfo((String)"--------------------------------------------------------------------------", (Object[])new Object[0]);
        Print.setIncludeStackFrame((int)lastPrintIncludeStackFrameState);
    }

    public static String[] getShutdownSignals(DCServerConfig dCServerConfig) {
        return SHUTDOWN_SIGNALS;
    }

    public String[] getShutdownSignals() {
        return TrackServerAdapter.getShutdownSignals(this.dcsConfig);
    }

    public static long getShutdownTimeoutMS(DCServerConfig dCServerConfig) {
        return 4000L;
    }

    public long getShutdownTimeoutMS() {
        return TrackServerAdapter.getShutdownTimeoutMS(this.dcsConfig);
    }

    public Class<? extends ClientPacketHandler> getClientPacketHandler(Class<? extends ClientPacketHandler> clazz) {
        DCServerConfig dCServerConfig = this.getDCServerConfig();
        if (dCServerConfig != null) {
            return dCServerConfig.getClientPacketHandlerClass(clazz);
        }
        return clazz;
    }

    public static boolean startTrackServer(DCServerConfig dCServerConfig, Class<?> clazz, Class<? extends CommandPacketHandler> clazz2, boolean bl) {
        MethodAction methodAction;
        if (dCServerConfig != null) {
            clazz = dCServerConfig.getTrackServerAdapterClass(TrackServerAdapter.class, clazz);
            clazz2 = dCServerConfig.getCommandPacketHandlerClass(clazz2);
        }
        if (clazz == null) {
            Print.logError((String)"Specified TrackServer class is null", (Object[])new Object[0]);
            return false;
        }
        int n = Print.setIncludeStackFrame((int)0);
        if (trackServerInstance == null) {
            try {
                methodAction = new MethodAction((Object)clazz, new Class[]{DCServerConfig.class, Class.class});
                trackServerInstance = (TrackServerAdapter)methodAction.invoke(new Object[]{dCServerConfig, clazz2});
            }
            catch (Throwable throwable) {
                Print.setIncludeStackFrame((int)n);
                Print.logException((String)("Unable to create TrackServer subclass: " + clazz), (Throwable)throwable);
                return false;
            }
        }
        if (!bl) {
            Print.setIncludeStackFrame((int)n);
            return true;
        }
        Print.logInfo((String)"--------------------------------------------------------------------------", (Object[])new Object[0]);
        Print.setIncludeStackFrame((int)n);
        try {
            methodAction = trackServerInstance.getShutdownSignals();
            long l = trackServerInstance.getShutdownTimeoutMS();
            new ShutdownHandler((String[])methodAction, l);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Print.logException((String)"Unable to install Signal Handler", (Throwable)illegalArgumentException);
        }
        TrackServerAdapter.sleepWaitForever();
        throw new RuntimeException("Control should never reach here");
    }

    public static void sleepWaitForever() {
        long l = DateTime.MinuteSeconds((long)60L);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(l);
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public static TrackServerAdapter getInstance() {
        return trackServerInstance;
    }

    public TrackServerAdapter(DCServerConfig dCServerConfig, Class<?> clazz) throws Throwable {
        int[] nArray;
        int n;
        int[] nArray2;
        int n2 = 0;
        this.dcsConfig = dCServerConfig;
        if (this.dcsConfig == null && !TEST_MODE) {
            Print.logWarn((String)"Missing DCServerConfig instance (additional errors may follow)", (Object[])new Object[0]);
            return;
        }
        if (TEST_MODE) {
            Print.logWarn((String)"Running in test-mode, listeners will not be started", (Object[])new Object[0]);
            return;
        }
        int[] nArray3 = nArray2 = this.dcsConfig != null ? this.dcsConfig.getTcpPorts() : null;
        if (!ListTools.isEmpty((int[])nArray2)) {
            this.tcpThread = new OrderedMap();
            for (int i = 0; i < nArray2.length; ++i) {
                n = nArray2[i];
                if (ServerSocketThread.isValidPort((int)n)) {
                    try {
                        ServerSocketThread serverSocketThread = this._startTCP(n);
                        this.tcpThread.put((Object)new Integer(n), (Object)serverSocketThread);
                        ++n2;
                    }
                    catch (BindException bindException) {
                        Print.logError((String)"TCP: Error binding to port: %d", (Object[])new Object[]{n});
                    }
                    continue;
                }
                throw new Exception("TCP: Invalid port number: " + n);
            }
        }
        int[] nArray4 = nArray = this.dcsConfig != null ? this.dcsConfig.getUdpPorts() : null;
        if (!ListTools.isEmpty((int[])nArray)) {
            this.udpThread = new OrderedMap();
            this.udpSocket = new OrderedMap();
            for (n = 0; n < nArray.length; ++n) {
                int n3 = nArray[n];
                if (ServerSocketThread.isValidPort((int)n3)) {
                    try {
                        ServerSocketThread serverSocketThread = this._startUDP(n3);
                        this.udpThread.put((Object)new Integer(n3), (Object)serverSocketThread);
                        this.udpSocket.put((Object)new Integer(n3), (Object)serverSocketThread.getDatagramSocket());
                        ++n2;
                    }
                    catch (BindException bindException) {
                        Print.logError((String)"UDP: Error binding to port: %d", (Object[])new Object[]{n3});
                    }
                    continue;
                }
                throw new Exception("UDP: Invalid port number: " + n3);
            }
        }
        if (n2 <= 0) {
            Print.logWarn((String)"No active device communication listeners!", (Object[])new Object[0]);
        }
        int n4 = n = this.dcsConfig != null ? this.dcsConfig.getCommandDispatcherPort() : 0;
        if (n > 0) {
            if (clazz == null) {
                Print.logError((String)"Command: Command port specified, but CommandListener is null", (Object[])new Object[0]);
            } else {
                if (!ServerSocketThread.isValidPort((int)n)) {
                    throw new Exception("Command: Invalid port number: " + n);
                }
                try {
                    this._startCommand(n, clazz);
                }
                catch (BindException bindException) {
                    Print.logError((String)"Command: Error binding to port: %d", (Object[])new Object[]{n});
                }
            }
        }
    }

    public DCServerConfig getDCServerConfig() {
        return this.dcsConfig;
    }

    public static String getUniqueIDPrefixString(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? DCServerFactory.getUniquePrefixString((String[])dCServerConfig.getUniquePrefix()) : "";
    }

    public String getUniqueIDPrefixString() {
        return TrackServerAdapter.getUniqueIDPrefixString(this.dcsConfig);
    }

    public static int getCommandDispatcherPort(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getCommandDispatcherPort() : 0;
    }

    public int getCommandDispatcherPort() {
        return TrackServerAdapter.getCommandDispatcherPort(this.dcsConfig);
    }

    public static int[] getTcpPorts(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getTcpPorts() : null;
    }

    public static String getTcpPortsString(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? StringTools.join((int[])dCServerConfig.getTcpPorts(), (String)",") : "";
    }

    public int[] getTcpPorts() {
        return TrackServerAdapter.getTcpPorts(this.dcsConfig);
    }

    public static long getTcpIdleTimeoutMS(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getTcpIdleTimeoutMS(10000L) : 10000L;
    }

    public long getTcpIdleTimeoutMS() {
        return TrackServerAdapter.getTcpIdleTimeoutMS(this.dcsConfig);
    }

    public static long getTcpPacketTimeoutMS(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getTcpPacketTimeoutMS(4000L) : 4000L;
    }

    public long getTcpPacketTimeoutMS() {
        return TrackServerAdapter.getTcpPacketTimeoutMS(this.dcsConfig);
    }

    public static long getTcpSessionTimeoutMS(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getTcpSessionTimeoutMS(15000L) : 15000L;
    }

    public long getTcpSessionTimeoutMS() {
        return TrackServerAdapter.getTcpSessionTimeoutMS(this.dcsConfig);
    }

    public int getLingerOnCloseSec() {
        return 3;
    }

    public ServerSocketThread getServerSocketThread_tcp(int n) {
        if (ListTools.isEmpty(this.tcpThread)) {
            return null;
        }
        if (n <= 0) {
            return (ServerSocketThread)this.tcpThread.getFirstValue();
        }
        ServerSocketThread serverSocketThread = (ServerSocketThread)this.tcpThread.get((Object)new Integer(n));
        if (serverSocketThread != null) {
            return serverSocketThread;
        }
        Print.logWarn((String)("TCP 'Listen' port[" + n + "] not found, returning first ServerSocketThread"), (Object[])new Object[0]);
        return (ServerSocketThread)this.tcpThread.getFirstValue();
    }

    public static void GetActiveSessionsLog(StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            TrackServerAdapter trackServerAdapter = TrackServerAdapter.getInstance();
            trackServerAdapter.logActiveSessions(stringBuffer);
        }
    }

    public void logActiveSessions(StringBuffer stringBuffer) {
        ServerSocketThread serverSocketThread;
        if (!ListTools.isEmpty(this.tcpThread)) {
            for (Integer n : this.tcpThread.keySet()) {
                serverSocketThread = (ServerSocketThread)this.tcpThread.get((Object)n);
                if (serverSocketThread == null) continue;
                serverSocketThread.logActiveSessions("Active TCP Sessions:", stringBuffer);
            }
        }
        if (!ListTools.isEmpty(this.udpThread)) {
            for (Integer n : this.udpThread.keySet()) {
                serverSocketThread = (ServerSocketThread)this.udpThread.get((Object)n);
                if (serverSocketThread == null) continue;
                serverSocketThread.logActiveSessions("Active UDP Sessions:", stringBuffer);
            }
        }
    }

    public void logActiveSessions() {
        this.logActiveSessions(null);
    }

    public void sysPrintActiveSessions() {
        StringBuffer stringBuffer = new StringBuffer();
        this.logActiveSessions(stringBuffer);
        Print.sysPrintln((String)stringBuffer.toString(), (Object[])new Object[0]);
    }

    protected ServerSocketThread _startTCP(int n) throws Throwable {
        ServerSocketThread serverSocketThread = null;
        try {
            serverSocketThread = this.dcsConfig.createServerSocketThread_TCP(n);
            serverSocketThread.setName("TCPListener_" + n);
        }
        catch (BindException bindException) {
            Print.logException((String)("(TCP) Unable to bind to port [" + n + "]"), (Throwable)bindException);
            throw bindException;
        }
        catch (Throwable throwable) {
            Print.logException((String)("(TCP) ServerSocket error [port " + n + "]"), (Throwable)throwable);
            throw throwable;
        }
        this.initTCP(serverSocketThread);
        DCServerConfig.startServerSocketThread((ServerSocketThread)serverSocketThread, (String)"Event");
        return serverSocketThread;
    }

    protected ServerSocketThread initTCP(ServerSocketThread serverSocketThread) throws Throwable {
        return serverSocketThread;
    }

    public static int[] getUdpPorts(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getUdpPorts() : null;
    }

    public static String getUdpPortsString(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? StringTools.join((int[])dCServerConfig.getUdpPorts(), (String)",") : "";
    }

    public int[] getUdpPorts() {
        return TrackServerAdapter.getUdpPorts(this.dcsConfig);
    }

    public static long getUdpIdleTimeoutMS(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getUdpIdleTimeoutMS(1000L) : 1000L;
    }

    public long getUdpIdleTimeoutMS() {
        return TrackServerAdapter.getUdpIdleTimeoutMS(this.dcsConfig);
    }

    public static long getUdpPacketTimeoutMS(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getUdpPacketTimeoutMS(1000L) : 1000L;
    }

    public long getUdpPacketTimeoutMS() {
        return TrackServerAdapter.getUdpPacketTimeoutMS(this.dcsConfig);
    }

    public static long getUdpSessionTimeoutMS(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getUdpSessionTimeoutMS(2000L) : 2000L;
    }

    public long getUdpSessionTimeoutMS() {
        return TrackServerAdapter.getUdpSessionTimeoutMS(this.dcsConfig);
    }

    public ServerSocketThread getServerSocketThread_udp(int n) {
        if (ListTools.isEmpty(this.udpThread)) {
            return null;
        }
        if (n <= 0) {
            return (ServerSocketThread)this.udpThread.getFirstValue();
        }
        ServerSocketThread serverSocketThread = (ServerSocketThread)this.udpThread.get((Object)new Integer(n));
        if (serverSocketThread != null) {
            return serverSocketThread;
        }
        Print.logWarn((String)("UDP 'Listen' port[" + n + "] not found, returning first ServerSocketThread"), (Object[])new Object[0]);
        return (ServerSocketThread)this.udpThread.getFirstValue();
    }

    public DatagramSocket getUdpDatagramSocket(int n) {
        if (ListTools.isEmpty(this.udpSocket)) {
            return null;
        }
        if (n <= 0) {
            return (DatagramSocket)this.udpSocket.getFirstValue();
        }
        DatagramSocket datagramSocket = (DatagramSocket)this.udpSocket.get((Object)new Integer(n));
        if (datagramSocket != null) {
            return datagramSocket;
        }
        Print.logWarn((String)("'Listen' port[" + n + "] not found, returning first DatagramSocket"), (Object[])new Object[0]);
        return (DatagramSocket)this.udpSocket.getFirstValue();
    }

    protected ServerSocketThread _startUDP(int n) throws Throwable {
        ServerSocketThread serverSocketThread = null;
        try {
            serverSocketThread = this.dcsConfig.createServerSocketThread_UDP(n);
            serverSocketThread.setName("UDPListener_" + n);
        }
        catch (BindException bindException) {
            Print.logException((String)("(UDP) Unable to bind to port [" + n + "]"), (Throwable)bindException);
            throw bindException;
        }
        catch (Throwable throwable) {
            Print.logException((String)("(UDP) ServerSocket error [port " + n + "]"), (Throwable)throwable);
            throw throwable;
        }
        this.initUDP(serverSocketThread);
        DCServerConfig.startServerSocketThread((ServerSocketThread)serverSocketThread, (String)"Event");
        return serverSocketThread;
    }

    protected ServerSocketThread initUDP(ServerSocketThread serverSocketThread) throws Throwable {
        return serverSocketThread;
    }

    public ServerSocketThread _startInputStream() throws Throwable {
        int n = 0;
        ServerSocketThread serverSocketThread = null;
        try {
            serverSocketThread = this.dcsConfig.createServerSocketThread_UDP(n);
            serverSocketThread.setName("InputStreamListener_" + n);
        }
        catch (BindException bindException) {
            Print.logException((String)("(InputStream) Unable to bind to port [" + n + "]"), (Throwable)bindException);
            throw bindException;
        }
        catch (Throwable throwable) {
            Print.logException((String)("(InputStream) ServerSocket error [port " + n + "]"), (Throwable)throwable);
            throw throwable;
        }
        this.initUDP(serverSocketThread);
        DCServerConfig.startServerSocketThread((ServerSocketThread)serverSocketThread, (String)"Event");
        return serverSocketThread;
    }

    public static ServerSocketThread startTestSessionServer(DCServerConfig dCServerConfig, Class<?> clazz) {
        try {
            TrackServerAdapter.startTrackServer(dCServerConfig, clazz, null, false);
            return TrackServerAdapter.getInstance()._startInputStream();
        }
        catch (Throwable throwable) {
            Print.logStackTrace((String)"ERROR", (Throwable)throwable);
            return null;
        }
    }

    protected void _startCommand(int n, Class<? extends CommandPacketHandler> clazz) throws Throwable {
        this.cmdThread = DCServerConfig.startCommandHandler((int)n, clazz);
    }

    public static class ShutdownHandler
    extends PosixSignalHandler {
        private String[] shutdownSignals = SHUTDOWN_SIGNALS;
        private long shutdownTimeoutMS = 4000L;

        public ShutdownHandler() throws IllegalArgumentException {
            this(null, -1L);
        }

        public ShutdownHandler(String[] stringArray, long l) throws IllegalArgumentException {
            this.shutdownSignals = !ListTools.isEmpty((Object[])stringArray) ? stringArray : SHUTDOWN_SIGNALS;
            this.shutdownTimeoutMS = l >= 1000L ? l : 4000L;
            this.handleSignal(this.shutdownSignals);
            Print.logInfo((String)("Installed Signal Handler(s): " + StringTools.join((String[])SHUTDOWN_SIGNALS, (String)",")), (Object[])new Object[0]);
        }

        protected void signal_TERM() {
            Print.logWarn((String)"Received termination signal, starting shutdown procedure ...", (Object[])new Object[0]);
            try {
                boolean bl = ServerSocketThread.shutdownAll((long)this.shutdownTimeoutMS);
                if (bl) {
                    Print.logWarn((String)"Normal shutdown ...", (Object[])new Object[0]);
                    System.exit(0);
                } else {
                    Print.logError((String)"Forced shutdown ...", (Object[])new Object[0]);
                    System.exit(1);
                }
            }
            catch (Throwable throwable) {
                Print.logException((String)"Shutdown error, forcing shutdown ...", (Throwable)throwable);
                System.exit(1);
            }
        }
    }
}

